// #autoload
// #name = Chat Macros
// #version = 0.2
// #author = Barbarian
// #warrior = Barb4rian
// #email = conanford@hotmail.com
// #web = http://barb4rian.tripod.com/
// #description = adds % keys to chat messages, so you can tell about your loadout.  See readme for details
// #readme = scripts/barbarian/chatmacros.txt
// #category = barbarian
// #include = support/loadout.cs
// #credit = Daniel Neilsen (aka Wizard_TPG) (loadout.cs)

function ChatMacroProcess(%fmtString)
{
	// Following keys maybe be used in %fmtString:
	// keys have been kept intentionally short due to chat buffer limitations
	// %beac  = beacons
	// %chain = chaingun ammo
	// %disc  = discs
	// %gl    = ammo for grenade launcher grenades
	// %gtype = grenade type of in-hand grenades
	// %grens = grenades (hand type)
	// %kit   = health kits
	// %mine  = mines
	// %miss  = missiles
	// %mort  = mortars
	// %pack  = pack type you are holding or NoPack
	// %plas  = plasma ammo

	for(%i=0; %i<$ChatMacroProcess_subs; %i++)
	{
		if(isobject($ChatMacroProcess_sub[%i]))
		{
			%objname=$ChatMacroProcess_sub[%i];
			%fmtString=%objname.ChatMacroProcess(%fmtString);
		}
	}


	// test example
	// I have %pack, %grens %gtype, %miss missiles, %chain bullets, and %kit kits

	if( strstr(%fmtString,"%") == -1)
		return(%fmtString);	

	if( strstr(%fmtstring,"%chain") != -1)
	{
		%tempvalue=(loadout.getWeaponAmmo("Chaingun") > -1) ? loadout.getWeaponAmmo("Chaingun") : 0;
		%fmtString = strreplace(%fmtString, "%chain", %tempvalue);
	}
	if( strstr(%fmtstring,"%grens") != -1)
	{
		%tempvalue=(loadout.getGrenadeAmmo() > -1) ? loadout.getGrenadeAmmo() : 0;
		%fmtString = strreplace(%fmtString, "%grens", %tempvalue);
	}
	if( strstr(%fmtstring,"%gtype") != -1)
	{
		%tempvalue=(loadout.getGrenadeType() !$= "") ? loadout.getGrenadeType() : "No Grenades";
		%fmtString = strreplace(%fmtString, "%gtype", %tempvalue);
	}
	if( strstr(%fmtstring,"%miss") != -1)
	{
		%tempvalue=(loadout.getWeaponAmmo("MissileLauncher") > -1) ? loadout.getWeaponAmmo("MissileLauncher") : 0;
		%fmtString = strreplace(%fmtString, "%miss", %tempvalue);
	}
	if( strstr(%fmtstring,"%mort") != -1)
	{
		%tempvalue=(loadout.getWeaponAmmo("Mortar") > -1) ? loadout.getWeaponAmmo("Mortar") : 0;
		%fmtString = strreplace(%fmtString, "%mort", %tempvalue);
	}
	if( strstr(%fmtstring,"%disc") != -1)
	{
		%tempvalue=(loadout.getWeaponAmmo("Disc") > -1) ? loadout.getWeaponAmmo("Disc") : 0;
		%fmtString = strreplace(%fmtString, "%disc", %tempvalue);
	}
	if( strstr(%fmtstring,"%plas") != -1)
	{
		%tempvalue=(loadout.getWeaponAmmo("Plasma") > -1) ? loadout.getWeaponAmmo("Plasma") : 0;
		%fmtString = strreplace(%fmtString, "%plas", %tempvalue);
	}
	if( strstr(%fmtstring,"%gl") != -1)
	{
		%tempvalue=(loadout.getWeaponAmmo("GrenadeLauncher") > -1) ? loadout.getWeaponAmmo("GrenadeLauncher") : 0;
		%fmtString = strreplace(%fmtString, "%gl", %tempvalue);
	}
	if( strstr(%fmtstring,"%mine") != -1)
	{
		%tempvalue=(loadout.getMineAmmo() > -1) ? loadout.getMineAmmo() : 0;
		%fmtString = strreplace(%fmtString, "%mine", %tempvalue);
	}
	if( strstr(%fmtstring,"%kit") != -1)
	{
		%tempvalue=(loadout.getRepairKit() > -1) ? loadout.getRepairKit() : 0;
		%fmtString = strreplace(%fmtString, "%kit", %tempvalue);
	}
	if( strstr(%fmtstring,"%pack") != -1)
	{
		%tempvalue=(loadout.getPack() !$= "") ? loadout.getPack() : "NoPack";
		%fmtString = strreplace(%fmtString, "%pack", %tempvalue);
	}
	if( strstr(%fmtstring,"beac") != -1)
	{
		%tempvalue=(loadout.getBeaconAmmo() > -1) ? loadout.getBeaconAmmo() : 0;
		%fmtString = strreplace(%fmtString, "%beac", %tempvalue);
	}

	return(%fmtString);
}


package comtoserver {

function commandToServer(%taggedcommand,%a1,%a2,%a3,%a4,%a5,%a6,%a7,%a8,%a9)
{
	%command=gettaggedstring(%taggedcommand);
	if( ( %command $= "MessageSent") || (%command $= "TeamMessageSent") )
	{
		%a1=ChatMacroProcess(%a1);
	}


	// these if statements below are necessary---if it is not done this way, and you just
	// send all %a1 to %a9, you crash!

	if (%a9 !$= "")
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3,%a4,%a5,%a6,%a7,%a8,%a9));
	if (%a8 !$= "")
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3,%a4,%a5,%a6,%a7,%a8) );
	if (%a7 !$= "")
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3,%a4,%a5,%a6,%a7) );
	if (%a6 !$= "")
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3,%a4,%a5,%a6) ); 
	if (%a5 !$= "")
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3,%a4,%a5) );
	if (%a4 !$= "") 
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3,%a4) );
	if (%a3 !$= "") 
		return( parent::commandToServer(%taggedcommand,%a1,%a2,%a3) );
	if (%a2 !$= "") 
		return( parent::commandToServer(%taggedcommand,%a1,%a2) );
	if (%a1 !$= "") 
		return( parent::commandToServer(%taggedcommand,%a1) );
	return( parent::commandToServer(%taggedcommand) );
}

};
activatepackage(comtoserver);
