// #autoload
// #name = Chat Alert
// #version = 0.2
// #date = January 13, 2004.
// #author = Barbarian
// #warrior = Barb4rian
// #email = conanford@hotmail.com
// #web = http://barb4rian.tripod.com/
// #description = Takes messages which have your name (with or without tribe tag) in them and places them in a hud.  
// #include = support/team_tracker.cs
// #config = ChatAlertGUI
// #readme = scripts/barbarian/ChatAlert.txt
// #status = Beta
// #credit = Uberguy
// #credit = whoever wrote Bottomprint in tribes 2

if (!isobject(ChatAlert))
    	new ScriptObject(ChatAlert)
	{
	        class = ChatAlert;
		version = 0.1;
		keybinds = false;
		myName = "";
		active=false;
		remove="";
    	};


function ChatAlertPrint( %message, %time, %lines ) // time is specified in seconds
{
   if(ChatAlert.active)
   {   
      if( ChatAlert.remove !$= "")
      {
         cancel(ChatAlert.remove);
      }
         
      ChatAlertText.setText( "<just:center>" @ %message );
      ChatAlertHUD.extent = firstWord(ChatAlertHUD.extent) @ " " @ $ChatAlert::Sizes[%lines];

      if (%time > 10) %time = 10;
      if (%time < 0) %time = 1;

      if(%time > 0)
         ChatAlert.remove = schedule( ( %time * 1000 ), 0, "ChatAlertClear" );
      
      // were done.
      return;   
   }   
   
   ChatAlertHUD.setVisible(true);
   ChatAlert.active = true;
   ChatAlertText.setText( "<just:center>" @ %message );
   ChatAlertHUD.extent = firstWord(ChatAlertHUD.extent) @ " " @ $ChatAlert::Sizes[%lines];
   
   if(%time > 0)
   {   
      ChatAlert.remove = schedule( ( %time * 1000 ), 0, "ChatAlertClear" );
   }
}


function ChatAlert::resetcolors(%this)
{
	// function by Uberguy
	if(isobject(ChatAlertExample))
		ChatAlertExample.profile="GuiTextProfile";
	if(isobject(ChatAlertText))
		ChatAlertText.profile="GuiTextProfile";

	if (isObject(ChatAlertTextProfile)) ChatAlertTextProfile.delete();
	new GuiControlProfile(ChatAlertTextProfile) {
		fontType = "Univers Condensed";
		fontSize = "14";
		justify = "left";
		textOffset = "0 0";
		autoSizeWidth = "0";
		autoSizeHeight = "1";
		fontcolor=$pref::ChatAlert::color;
	};

	if(isobject(ChatAlertExample))
		ChatAlertExample.profile="ChatAlertTextProfile";
	if(isobject(ChatAlertText))
		ChatAlertText.profile="ChatAlertTextProfile";	
}


function ChatAlert::setup(%this)
{

	if ($pref::ChatAlert::trans $= "") $pref::ChatAlert::trans = false;
	if ($pref::ChatAlert::color $= "") $pref::ChatAlert::color = "124 252 0";
	if ($pref::ChatAlert::time $= "") $pref::ChatAlert::time = 4;

	%this.resetcolors();

	$ChatAlert::Sizes[1] = 18;
	$ChatAlert::Sizes[2] = 32;
	$ChatAlert::Sizes[3] = 48;
	if(!isobject(ChatAlertHUD))
	{
		// place it centered in x, 2/3 down the screen in y
		%x = mFloor( (getWord($pref::Video::resolution, 0) - 250)/2 );
		%y = mFloor( getWord($pref::Video::resolution, 1)*2/3 );
		
		new ShellFieldCtrl(ChatAlertHUD) {
			profile = $pref::ChatAlert::trans ? GuiConsoleProfile : GuiChatBackProfile;
			horizSizing = "center";
			vertSizing = "top";
			position = %x SPC %y;
			extent = "250 56";
			minExtent = "16 18";
			visible = "0";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";

			new GuiMLTextCtrl(ChatAlertText) {
				profile = "ChatAlertTextProfile";
				horizSizing = "center";
				vertSizing = "center";
				position = "0 0";
				extent = "246 36";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				lineSpacing = "2";
				allowColorChars = "0";
				maxChars = "-1";
				deniedSound = "InputDeniedSound";
			};
		};
	}
}

function ChatAlert::Reset(%this)
{
	if(ChatAlert.active)
		ChatAlertHUD.setvisible(false);

	ChatAlertHUD.profile = $pref::ChatAlert::trans ? GuiConsoleProfile : GuiChatBackProfile;
	if(playGui.isMember(ChatAlertHUD)) playGui.remove(ChatAlertHUD);
		playGui.add(ChatAlertHUD);

	if(ChatAlert.active)
		ChatAlertHUD.setvisible(true);


}

function ChatAlertClear()
{
   ChatAlert.active = false;
   ChatAlertHUD.visible = 0;
   
   ChatAlertHUD.remove = "";
}


function ChatAlertCheckMessage(%flag,%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
{
	for(%i=0; %i<$ChatAlertCheckMessage_subs; %i++)
	{
		if(isobject($ChatAlertCheckMessage_sub[%i]))
		{
			%objname=$ChatAlertCheckMessage_sub[%i];
			%flag=%objname.ChatAlertCheckMessage(%flag,%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
		}
	}
	if(%flag)
	{
		%str=detag(%msgString);
		if (strlen(%str) <=30)
			%lines=1;
		else if (strlen(%str) <=60)
			%lines=2;
		else
			%lines=3;
		if(strstr(%str,"~w") != -1)
			%str=getsubstr(%str,0,strstr(%str,"~w"));
		ChatAlertPrint( %str, $pref::ChatAlert::time, %lines );
	}

}

function ChatAlert::detribifyname(%this,%name)
{
	// we want the base name only for the player, if possible
	%name = detag(%name);

	%p6 = strstr(%name,"\c6");
	%p7 = strstr(%name,"\c7");
	%p10 = strstr(%name,"\x10");
	%p11 = strstr(%name,"\x11");
	
	// three cases: tribe tag after, before, or none
	// name will look like this: \x10\c6Barb4rian\c7.cs\x11
	// or \x10\c7=[OI]=\c6OnSale\x11
	// or \x10\c6Username\x11
	//    \x10\c7|HV| \c6_coldblood_\x11

	if( (%p7 == -1) && (%p6 != -1) && (%p11 != -1) )
	{
		// no tribe tag, simple.
		%detribed=stripMLControlChars(getSubStr(%name,%p6+1,%p11-1));
		return( %detribed );
	}
	if ( (%p7 > %p6) && (%p6 != -1) && (%p7 != -1) )
	{
		// tribes tag is after name..
		//sometimes no-tribe tags too
		%detribed=stripMLControlChars(getSubStr(%name,%p6+1,%p7-1));
		return( %detribed );
	}
	if ( (%p7 < %p6) && (%p6 != -1) && (%p7 != -1) && (%p11 != -1))
	{
		// tribes tag precedes name

		%detribed=stripMLControlChars(getSubStr(%name,%p6+1,%p11-1));
		return( %detribed );
	}
	
	// but if none matched
	return( stripMLcontrolchars(%name) );
}

package ChatAlertPkg 
{

	function clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10)
	{
		parent::clientCmdChatMessage(%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);

		%senderID=detag(%sender);
		%str = detag(%msgString);

		if(ChatAlert.myName $= "")
		{
			// we want the base name only for the player, with no tribe tags
			%name = detag(TeamTracker.getManagerName());
	
			ChatAlert.myName=ChatAlert.detribifyname(%name);
		}

		if ( (strstr(%str,ChatAlert.myName) != -1) && (%senderID != TeamTracker.myID) )
			ChatAlertCheckMessage(true,%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
		else
			ChatAlertCheckMessage(false,%sender, %voice, %pitch, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);

	}

	function LoadingGui::onWake(%this) {

		parent::onWake(%this);
		if(isObject(HM) && isObject(HudMover))
			hudmover::addhud(ChatAlertHUD, "Chat Alert");
		playGui.add(ChatAlertHUD);
	}


}; // package

activatepackage(ChatAlertPkg);

ChatAlert.setup();

function ChatAlertText::onResize(%this, %width, %height)
{
   %this.position = "0 0";
}

if (!isObject(ChatAlertGUI)) {
	// portions are from Uberguy's Timehud
	// color sliders are from Uberguy's UberChat
	new GuiControl(ChatAlertGUI) {
		profile = "GuiDefaultProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "0 21";
		extent = "300 300";
		minExtent = "300 300";
		visible = "1";
		hideCursor = "0";
		bypassHideCursor = "0";
		helpTag = "0";

		new ShellFieldCtrl() {
			profile = "ShellFieldProfile";
			horizSizing = "right";
			vertSizing = "bottom";
			position = "0 0";
			extent = "300 300";
			minExtent = "16 18";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";

			new GuiTextCtrl() {
				profile = "DebriefHeadlineTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "60 27";
				extent = "179 32";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Chat Alert Options";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new ShellToggleButton(ChatAlertTrans) {
				profile = "ShellRadioProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 73";
				extent = "106 30";
				minExtent = "26 27";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				variable = "$pref::ChatAlert::trans";
				command = "ChatAlert.Reset();";
				helpTag = "0";
				text = "Transparent HUD";
				longTextBuffer = "0";
				maxLength = "255";
			};
			new GuiTextCtrl(ChatAlertTime) {
				profile = "TaskHudTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 133";
				extent = "47 60";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Popup for " @ $pref::ChatAlert::time SPC "sec.";
				longTextBuffer = "0";
				maxLength = "255";
				fontcolor = "0 255 0";
				};
			new ShellFieldCtrl() {
				profile = "ShellFieldProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "26 147";
				extent = "96 27";
				minExtent = "16 18";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";

				new ShellSliderCtrl(ChatAlert_Time) {
					profile = "ShellSliderProfile";
					horizSizing = "center";
					vertSizing = "center";
					position = "5 1";
					extent = "86 24";
					minExtent = "12 24";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					variable = "value";
					command = "ChatAlertGui.settime(1);";
					altCommand = "ChatAlertGui.settime(0);";
					helpTag = "0";
					range = "1 10";
					ticks = "10";
					value = $pref::ChatAlert::time;
					usePlusMinus = "0";

					format = "%1.0f";
				};
			};

			new ShellFieldCtrl() {
				profile = "ShellFieldProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "150 62";
				extent = "119 143";
				minExtent = "16 18";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";

				new GuiTextCtrl(ChatAlertGreen) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 52";
					extent = "60 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "GREEN ("   @ getWord($pref::ChatAlert::color,1) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "0 255 0";
				};
				new GuiTextCtrl(ChatAlertRed) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 8";
					extent = "41 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "RED ("   @ getWord($pref::ChatAlert::color,0) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "255 0 0";
				};
				new GuiTextCtrl(ChatAlertBlue) {
					profile = "TaskHudTextProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "13 94";
					extent = "46 20";
					minExtent = "8 8";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";
					text = "BLUE ("   @ getWord($pref::ChatAlert::color,2) @ ")";
					longTextBuffer = "0";
					maxLength = "255";
					fontcolor = "0 0 255";
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 22";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(ChatAlert_Red) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "ChatAlertGui.setColors(1);";
						altCommand = "ChatAlertGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($pref::ChatAlert::color,0);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 66";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(ChatAlert_Green) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "ChatAlertGui.setColors(1);";
						altCommand = "ChatAlertGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($pref::ChatAlert::color,1);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};
				new ShellFieldCtrl() {
					profile = "ShellFieldProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "12 108";
					extent = "96 27";
					minExtent = "16 18";
					visible = "1";
					hideCursor = "0";
					bypassHideCursor = "0";
					helpTag = "0";

					new ShellSliderCtrl(ChatAlert_Blue) {
						profile = "ShellSliderProfile";
						horizSizing = "center";
						vertSizing = "center";
						position = "5 1";
						extent = "86 24";
						minExtent = "12 24";
						visible = "1";
						hideCursor = "0";
						bypassHideCursor = "0";
						variable = "value";
						command = "ChatAlertGui.setColors(1);";
						altCommand = "ChatAlertGui.setColors(0);";
						helpTag = "0";
						range = "0.000000 255.000000";
						ticks = "1000";
						value = getWord($pref::ChatAlert::color,2);
						usePlusMinus = "0";

						format = "%1.0f";
					};
				};

			}; // Color changer thingy
			new GuiTextCtrl(ChatAlertExample) {
				profile = "ChatAlertTextProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "154 205";
				extent = "111 14";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				text = "Example Text";
				longTextBuffer = "0";
				maxLength = "255";
			};


		};  //ShellField
		
	};
}

function ChatAlertGui::settime(%this, %done)
{
	%time=mCeil(ChatAlert_Time.value);
	ChatAlertTime.setValue("Popup for " @ %time SPC "sec.");
	if(%done)
		$pref::ChatAlert::time=%time;
}

function ChatAlertGui::setColors(%this, %done) 
{

	// function by Uberguy
	%R = mCeil(ChatAlert_Red.value);
	%G = mCeil(ChatAlert_Green.value);
	%B = mCeil(ChatAlert_Blue.value);

	ChatAlertRed.setValue("RED ("   @ %R @ ")");
	ChatAlertGreen.setValue("GREEN (" @ %G @ ")");
	ChatAlertBlue.setValue("BLUE ("  @ %B @ ")");

	if (%done) {
		$pref::ChatAlert::color=%R SPC %G SPC %B;
		ChatAlertExample.setvisible(false);
		ChatAlertText.setvisible(false);

		ChatAlert.resetcolors();

		ChatAlertExample.setvisible(true);
		ChatAlertText.setvisible(true);
	}
}

function ChatAlertGui::onWake(%this)
{

}
