// #autoload
// #name = Quick LOS
// #version = 1.0
// #date = April 12, 2003.
// #author = Barbarian
// #warrior = Barb4rian
// #email = conanford@hotmail.com
// #web = http://barb4rian.tripod.com/
// #description = Provides Multiple Line of Site Tasks.  Based on Silverspirit's TaskLOS.
// #category = Barbarian's scripts
// #status = Release
// #credit = Silverspirit (Chris Lee)
// #credit = LouCypher
// #credit = Uberguy
// #credit = Kaiten Commander
// #include = support/team_tracker.cs
// #include = support/player_support.cs
//
// additional stuff added:
//   - menu allows for toggling between task types (Attack Obj, Bomb at, Attack Location, Defend Location
//     this prevents overwriting your previous task if you use a new task type
//
//   - Option to send task to yourself only
//
//   - small hud next to reticle shows current setting (for target type).  

if ($pref::QuickLOS::Transparent $= "") $pref::QuickLOS::Transparent = true;

if (!isObject(QuickLOS))
    new ScriptObject(QuickLOS) {
        class = QuickLOS;
	shellProfileID = $pref::QuickLOS::Transparent;
	version = 1.0;
    };
	
    function QuickLOSToggleMulti(%val)  {
	if (!%val)
		return;

	$QuickLOS::CurTask++;

	if($QuickLOS::CurTask > $QuickLOS::Tasks)
		$QuickLOS::CurTask=1;
			
	QuickLOSHUD.settext($QuickLOS::Label[$QuickLOS::CurTask]);
	QuickLOS.show();
    }

    function QuickLOSSendMulti(%val) {
	if (!%val)
		return;
        %result=ServerConnection.sendLOSTarget();
        commandToServer('BuildClientTask',$QuickLOS::Task[$QuickLOS::CurTask],true);
        commandToServer('SendTaskToTeam');
	QuickLOS.show();
	echo(%result);
    }

    

    function QuickLOSOwnTask(%val) 
    {
          if (!%val) 
             return; 
        ServerConnection.sendLOSTarget(); 
	commandToServer('BuildClientTask',$QuickLOS::Task[$QuickLOS::CurTask],false); 
	commandToServer('SendTaskToClient', PlayerList.getMyID(), true);
	QuickLOS.show();
    }

    function QuickLOS::Setup(%this) {
        if (%this.Setup)
            return;

        $RemapName[$RemapCount]="LOS Task to Self";
        $RemapCmd[$RemapCount]="QuickLOSOwnTask";
        $RemapCount++;

        $RemapName[$RemapCount]="Cycle LOS Tasks";
        $RemapCmd[$RemapCount]="QuickLOSToggleMulti";
        $RemapCount++;

        $RemapName[$RemapCount]="LOS Task to Team";
        $RemapCmd[$RemapCount]="QuickLOSSendMulti";
        $RemapCount++;
	
	
	// This lists types of LOS Task's available.  Taken from LouCypher's QuickMenu, I believe
	// If you want to add these to the available tasks, add them to the arrays below this comment block
	// 
	// You only need the part from the left, and put it in single quotes ''.  The part from the right is
	// from LouCyper's QuickMenu code
	// %1 show the name of the targetted object.
	//"EscortPlayer", "Escort player %1"
	//"RepairPlayer", "Repair player %1"
	//"AttackPlayer", "Attack enemy player %1"
	//"DefendFlag", "Defend the flag"
	//"ReturnFlag", "Return our flag"
	//"CaptureFlag", "Capture the enemy flag"
	//"CaptureObjective", "Capture the %1"
	//"DefendObjective", "Defend the %1"
	//"DefendLocation", "Defend location"
	//"MeetLocation", "Meet at location"
	//"BombLocation", "Bomb at location"
	//"AttackLocation", "Attack at location"
	//"LazeTarget", "Laze the target"
	//"DeployTurretBarrel", "Deploy turret barrels"
	//"DeployTurret", "Deploy turrets"
	//"DeployEquipment", "Deploy stations"
	//DeploySensor", "Deploy sensors"
	//RepairObject", "Repair the %1"
	//DefendObject", "Defend the %1"
	//AttackObject", "Attack the enemy %1"
	//MortarObject", "Mortar the enemy %1"
	//LazeObject", "Laze the enemy %1"
	//BombObject", "Bomb the %1"
	//TakeFlag", "Take flag from %1"
	//GiveFlag", "Give flag to %1"
	//NeedRide", "%1 needs a ride."
	//NeedPassenger", "%1 needs vehicle support."

	// The generally most useful LOS tasks.
	// Note that you can get many LOS tasks with the voice chat menu already. (i.e. Deploy Sensors is a built-in
	// LOS task, V-V-H is "escort <your name>"
	//
	// These are most useful for general play, in my opinion, for general midfield play and interdicting enemy units.
	//
	// Task Type must be in ''
	$QuickLOS::Task[1]='AttackLocation';
	$QuickLOS::Task[2]='BombLocation';
	$QuickLOS::Task[3]='AttackObject';
	$QuickLOS::Task[4]='DefendLocation';
	//
	// Very short descriptive text, i.e. < 5 chars, this appears in next to your reticle.
	$QuickLOS::Label[1]="Loc";
	$QuickLOS::Label[2]="Bomb";
	$QuickLOS::Label[3]="Obj";
	$QuickLOS::Label[4]="Def";
	$QuickLOS::Tasks=4;
	// starting tak
	$QuickLOS::CurTask=1;

    }

function QuickLOS::show(%this) 
{

    if (!isObject(QuickLOSHud)) {

	// This is the starting location for the HUD text.


		%this.shellProfile[0] = "GuiChatBackProfile";
		%this.shellProfile[1] = "GuiConsoleProfile";

		QuickLOS.textProfile = new GuiControlProfile() {
		   fontType = "Univers Condensed";
		   fontSize = 16;
		   fontColor = "130 255 130";
		   justify = "left";
		   autoSizeWidth = false;
		   autoSizeHeight = true;
 		};

		new GuiTextCtrl(QuickLOSHud) {
			profile = QuickLOS.textProfile;
			horizSizing = "width";
			vertSizing = "top";
			position = "155 155";
			extent = "90 16";
			minExtent = "8 8";
			visible = "0";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "";
			longTextBuffer = "0";
			maxLength = "10";
		};

//	    PlayGui.add(QuickLOSHud);
  	    retCenterHud.add(QuickLOSHud);
		%x=155;
		%y=155;
	    QuickLOSHud.setPosition(%x,%y);
    	    QuickLOSHUD.settext($QuickLOS::Label[$QuickLOS::CurTask]);
	    if (isobject(hudmover)) hudmover::addhud(QuickLOSHud, "Quick LOS");
	}

	// QuickLOSHud.setPosition(%x,%y);
	QuickLOSHud.setVisible(true);
}


function QuickLOSHudToggleTransparent(%val) {

	if (%val) {
		QuickLOSHud.shellProfileID = !QuickLOSHud.shellProfileID;
		QuickLOSHud.profile = QuickLOS.shellProfile[QuickLOSHud.shellProfileID];
		$pref::QuickLOS::Transparent = QuickLOSHud.shellProfileID;

		if (playGui.isMember(QuickLOSHud)) {
			playGui.remove(QuickLOSHud);
			playGui.add(QuickLOSHud);
		}
	}
}
function QuickLOSHudHide() {

	if (isObject(QuickLOSHud)) QuickLOSHud.setVisible(false);
}


package QuickLOS
{
    function clientCmdSetPilotVehicleKeys() {

		parent::clientCmdSetPilotVehicleKeys();
		// copy toggle binds over
		passengerKeys.copyBind(moveMap, QuickLOSOwnTask);
		passengerKeys.copyBind(moveMap, QuickLOSToggleMulti);
		passengerKeys.copyBind(moveMap, QuickLOSSendMulti);
	}

    function clientCmdSetPassengerVehicleKeys() {
		// copy toggle binds over
		// thanks LouCypher
		parent::clientCmdSetPassengerVehicleKeys();
		passengerKeys.copyBind(moveMap, QuickLOSOwnTask);
		passengerKeys.copyBind(moveMap, QuickLOSToggleMulti);
		passengerKeys.copyBind(moveMap, QuickLOSSendMulti);
	}

};
activatePackage(QuickLOS);
QuickLOS.Setup();

// Different Type Tasks that are available.
//QuickTaskInstall( "EscortPlayer", "Escort player %1", 0 );
//QuickTaskInstall( "RepairPlayer", "Repair player %1", 0 );
//QuickTaskInstall( "AttackPlayer", "Attack enemy player %1", 1 );
//QuickTaskInstall( "DefendFlag", "Defend the flag", 1 );
//QuickTaskInstall( "ReturnFlag", "Return our flag", 1 );
//QuickTaskInstall( "CaptureFlag", "Capture the enemy flag",  1 );
//QuickTaskInstall( "CaptureObjective", "Capture the %1", 1 );
//QuickTaskInstall( "DefendObjective", "Defend the %1", 1 );
//QuickTaskInstall( "DefendLocation", "Defend location", 1 );
//QuickTaskInstall( "MeetLocation", "Meet at location", 1 );
//QuickTaskInstall( "BombLocation", "Bomb at location", 1 );
//QuickTaskInstall( "AttackLocation", "Attack at location", 1 );
//QuickTaskInstall( "LazeTarget", "Laze the target", 1 );
//QuickTaskInstall( "DeployTurretBarrel", "Deploy turret barrels", 1 );
//QuickTaskInstall( "DeployTurret", "Deploy turrets", 1 );
//QuickTaskInstall( "DeployEquipment", "Deploy stations", 1 );
//QuickTaskInstall( "DeploySensor", "Deploy sensors", 1 );
//QuickTaskInstall( "RepairObject", "Repair the %1", 1 );
//QuickTaskInstall( "DefendObject", "Defend the %1", 1 );
//QuickTaskInstall( "AttackObject", "Attack the enemy %1", 1 );
//QuickTaskInstall( "MortarObject", "Mortar the enemy %1", 1 );
//QuickTaskInstall( "LazeObject", "Laze the enemy %1", 1 );
//QuickTaskInstall( "BombObject", "Bomb the %1", 1 );
//QuickTaskInstall( "TakeFlag", "Take flag from %1", 0 );
//QuickTaskInstall( "GiveFlag", "Give flag to %1", 0 );
//QuickTaskInstall( "NeedRide", "%1 needs a ride.", 0 );
//QuickTaskInstall( "NeedPassenger", "%1 needs vehicle support.", 0 );
