// #autoload
// #name = Absynthe's Message Filter
// #version = 1.0.1
// #date = July 4th, 2001
// #description = Filters death messages, taunts, compliments, globals, and repeated messages.
// #author = Chuck "Absynthe" Simciak
// #warrior = Absynthe
// #email = absynthe@voyager.net
// #web = http://my.voyager.net/~absynthe
// #config = absFilterGui
// #readme = scripts/autoexec/absFilter/readme.txt
// #category = Absynthe's Scripts

package absFilter {

// --------------------------------------------------------------
//
//	Function Overrides
//
// --------------------------------------------------------------

function defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10) {
	if (strpos(%msgType,"Kill") > 0 && $absDeathMessageFilter != 0) {
		if ($absDeathMessageFilter $= 3) return;
		%Killer = detag(%a4);
		if ($absDeathMessageFilter $= 1) {
			%myTeam = getClientTeamId(getManagerId());
			if (getClientTeamId(getClientId(%Killer)) != %myTeam) return;
		}
		if ($absDeathMessageFilter $= 2 && strpos(%Killer,$absPlayerName) < 0) return;
		parent::defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
	}
	else
		parent::defaultMessageCallback(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6, %a7, %a8, %a9, %a10);
}


function clientCmdCannedChatMessage( %sender, %msgString, %name, %string, %keys, %voiceTag, %pitch ) {
	%temp = $PlayerList[%sender];
	%isItUs = (strpos(%temp.name,$absPlayerName) != -1);
	%isItTaunt = (strpos(%keys,"VGT") != -1);
	%isItCompliment = (strpos(%keys, "VGC") != -1);
	%isItGlobal = ((strpos(%keys, "VG") != -1) && (strlen(%keys) == 3));
	
	//echo(%temp.name @ "         " @ %keys @ "      " @ $absPrevPlayer @ " " @ $absPrevVoice);
	
	if ($absRepeatFilter) {
		if ($absPrevPlayer !$= "" && !%isItUs) {
			if (strpos(%temp.name, $absPrevPlayer) != -1) {
				if (strpos(%keys, $absPrevVoice) != -1) {
					return;
				}
			}
		}
		$absPrevPlayer = %temp.name;
		$absPrevVoice = %keys;
	}
	
	if (%isItUs) {
		parent::clientCmdCannedChatMessage( %sender, %msgString, %name, %string, %keys, %voiceTag, %pitch );
		return;		
		}
		
	//echo("Sender:" @ %sender @ "  Client:" @ %temp @ "  Name:" @ %temp.name);
	
	if (%isItTaunt) {
		if ($absTauntFilter == 2) return;
		if ($absTauntFilter == 1) {
			%i = strpos(%string,"~");
			%string = getsubstr(%string,0,%i);
			%i = strpos(%msgString,"~");
			%msgString = getsubstr(%msgString,0,%i);
		}
	}
	
	if (%isItCompliment) {
		if ($absComplimentFilter == 2) return;
		if ($absComplimentFilter == 1) {
			%i = strpos(%string,"~");
			%string = getsubstr(%string,0,%i);
			%i = strpos(%msgString,"~");
			%msgString = getsubstr(%msgString,0,%i);		
		}
	}

	if (%isItGlobal) {
		if ($absGlobalFilter == 2) return;
		if ($absGlobalFilter == 1) {
			%i = strpos(%string,"~");
			%string = getsubstr(%string,0,%i);
			%i = strpos(%msgString,"~");
			%msgString = getsubstr(%msgString,0,%i);		
		}
	}	

	parent::clientCmdCannedChatMessage( %sender, %msgString, %name, %string, %keys, %voiceTag, %pitch );
}

// --------------------------------------------------------------
//
//	absFilterGui Setup/Functions
//
// --------------------------------------------------------------

function savePrefs() {
	export("$absRepeatFilter", "prefs/absFilter.cs", false);
	export("$absComplimentFilter", "prefs/absFilter.cs", true);
	export("$absGlobalFilter", "prefs/absFilter.cs", true);
	export("$absDeathMessageFilter", "prefs/absFilter.cs", true);
	export("$absTauntFilter", "prefs/absFilter.cs", true);
}

function absDeathMessageMenu::init( %this ) {
   %this.clear();
   %this.add( "None", 0 );
   %this.add( "Allow Team Kills", 1 );
   %this.add( "Allow My Kills", 2);
   %this.add( "Everything", 3);

   %this.setSelected($absDeathMessageFilter);
   
}

function absTauntMessageMenu::init( %this ) {
   %this.clear();
   %this.add( "None", 0 );
   %this.add( "No Voice", 1 );
   %this.add( "No Voice/Text", 2);

   %this.setSelected($absTauntFilter);
}

function absCompMessageMenu::init( %this ) {
   %this.clear();
   %this.add( "None", 0 );
   %this.add( "No Voice", 1 );
   %this.add( "No Voice/Text", 2);

   %this.setSelected($absComplimentFilter);
}

function absGlobalMessageMenu::init( %this ) {
   %this.clear();
   %this.add( "None", 0 );
   %this.add( "No Voice", 1 );
   %this.add( "No Voice/Text", 2);

   %this.setSelected($absGlobalFilter);
}

function absFilterGui::onWake( %this ) {
	absDeathMessageMenu.init();
	absTauntMessageMenu.init();
	absCompMessageMenu.init();
	absGlobalMessageMenu.init();
	if ($absRepeatFilter)
		absNoRepeatRadioButton.setValue(1);
	else
		absNoRepeatRadioButton.setValue(0);
}

function absDeathMessageMenu::onSelect( %this, %id, %text ) {
	$absDeathMessageFilter = %id;
	savePrefs();
}

function absTauntMessageMenu::onSelect( %this, %id, %text ) {
	$absTauntFilter = %id;
	savePrefs();
}

function absCompMessageMenu::onSelect( %this, %id, %text ) {
	$absComplimentFilter = %id;
	savePrefs();
}

function absGlobalMessageMenu::onSelect( %this, %id, %text ) {
	$absGlobalFilter = %id;
	savePrefs();
}

function absNoRepeatRadioButton::onAction( %this ) {
	$absRepeatFilter = absNoRepeatRadioButton.getValue();
	savePrefs();
}

function DispatchLaunchMode() {
	if (isFile("support/launch_menu.cs")) {
		if(!isObject(absFilterGui)) {
		
			new GuiControl(absFilterGui) {
	        	profile = "GuiDefaultProfile";
	        	horizSizing = "width";
	        	vertSizing = "height";
	        	position = "0 10";
	        	extent = GM_Frame.extent;
	        	minExtent = "8 8";
	        	visible = "1";
	            hideCursor = "0";
	            bypassHideCursor = "0";
	        	helpTag = "0";
       	
		        new GuiTextCtrl(absDeathMessageLabel) {
				   profile = "ShellTextProfile";
				   horizSizing = "right";
				   vertSizing = "bottom";
				   position = "25 50";
				   extent = "50 26";
				   minExtent = "8 8";
				   visible = "1";
				   helpTag = "0";
				   text = "Death Message Filter:";
				};
				
				new ShellPopupMenu(absDeathMessageMenu) {
					profile = "ShellPopupProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "170 40";
					extent = "150 26";
					minExtent = "8 8";
					visible = "1";
					helpTag = "0";
					text = "Select Death Message Filter";
					maxLength = "255";
					maxPopupHeight = "200";
					buttonBitmap = "gui/shll_pulldown";
					rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					selectedBarBitmap = "gui/shll_pulldownbar_act";
					noButtonStyle = "0";
				};
					
				new GuiTextCtrl(absTauntMessageLabel) {
				   profile = "ShellTextProfile";
				   horizSizing = "right";
				   vertSizing = "bottom";
				   position = "25 80";
				   extent = "50 26";
				   minExtent = "8 8";
				   visible = "1";
				   helpTag = "0";
				   text = "Taunt Message Filter:";
				};			
	
				new ShellPopupMenu(absTauntMessageMenu) {
					profile = "ShellPopupProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "170 70";
					extent = "150 26";
					minExtent = "8 8";
					visible = "1";
					helpTag = "0";
					text = "Select Taunt Filter";
					maxLength = "255";
					maxPopupHeight = "200";
					buttonBitmap = "gui/shll_pulldown";
					rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					selectedBarBitmap = "gui/shll_pulldownbar_act";
					noButtonStyle = "0";
				};

				new GuiTextCtrl(absCompMessageLabel) {
				   profile = "ShellTextProfile";
				   horizSizing = "right";
				   vertSizing = "bottom";
				   position = "25 110";
				   extent = "50 26";
				   minExtent = "8 8";
				   visible = "1";
				   helpTag = "0";
				   text = "Compliment Message Filter:";
				};	
				
				new ShellPopupMenu(absCompMessageMenu) {
					profile = "ShellPopupProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "170 100";
					extent = "150 26";
					minExtent = "8 8";
					visible = "1";
					helpTag = "0";
					text = "Select Compliment Filter";
					maxLength = "255";
					maxPopupHeight = "200";
					buttonBitmap = "gui/shll_pulldown";
					rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					selectedBarBitmap = "gui/shll_pulldownbar_act";
					noButtonStyle = "0";
				};

				new GuiTextCtrl(absGlobalMessageLabel) {
				   profile = "ShellTextProfile";
				   horizSizing = "right";
				   vertSizing = "bottom";
				   position = "25 140";
				   extent = "50 26";
				   minExtent = "8 8";
				   visible = "1";
				   helpTag = "0";
				   text = "Global Message Filter:";
				};	
				
				new ShellPopupMenu(absGlobalMessageMenu) {
					profile = "ShellPopupProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "170 130";
					extent = "150 26";
					minExtent = "8 8";
					visible = "1";
					helpTag = "0";
					text = "Select Global Filter";
					maxLength = "255";
					maxPopupHeight = "200";
					buttonBitmap = "gui/shll_pulldown";
					rolloverBarBitmap = "gui/shll_pulldownbar_rol";
					selectedBarBitmap = "gui/shll_pulldownbar_act";
					noButtonStyle = "0";
				};
				
				new ShellToggleButton(absNoRepeatRadioButton) {
					profile = "ShellRadioProfile";
					horizSizing = "right";
					vertSizing = "bottom";
					position = "25 190";
					extent = "170 30";
					minExtent = "26 27";
					visible = "1";
					helpTag = "0";
					text = "FILTER REPEATED MESSAGES";
					maxLength = "255";
					value = "1";
				};
				
				new GuiMLTextCtrl(absWarningMessage) {
				   profile = "ShellTextProfile";
				   horizSizing = "right";
				   vertSizing = "bottom";
				   position = "10 240";
				   extent =  "380 100";
				   minExtent = "8 8";
				   visible = "1";
				   helpTag = "0";		
				};
			};
		}
	}
	
	if (!isFile("scripts/autoexec/absfilter/PJSupport1.cs") && !isFile("scripts/autoexec/panamajack/PJSupport1.cs")) {
		absWarningMessage.setValue("<lmargin:5><just:left><font:Courier New:16><color:c0c0c0>PJ's support script has not been installed. The option to filter DeathMessages to team only kills will not work. Download PJ's script pack and install it. Read the included ReadMe for details.");
	}
	parent::DispatchLaunchMode();
}
	
}; //end package

activatepackage(absFilter);

if (isFile("prefs/absFilter.cs")) {

	exec("prefs/absFilter.cs");

}
else
{

// values are:
//		0 = no filter
//		1 = filter all but team kills
//		2 = filter all but my kills
//		3 = filter everything

$absDeathMessageFilter = 2;

//values are:
//		0 = no filter
//		1 = no voice
//		2 = no voice or text

$absTauntFilter = 1;

// values are:
//		0 = allow repeats
//		1 = no repeated messages

$absRepeatFilter = 1;

//values are:
//		0 = no filter
//		1 = no voice
//		2 = no voice or text

$absComplimentFilter = 1;

//values are:
//		0 = no filter
//		1 = no voice
//		2 = no voice or text

$absGlobalFilter = 1;

}

$absPlayerName = getField($pref::Player[$pref::Player::Current], 0);
$absPrevPlayer = "";
$absPrevVoice = "";