
// #name = Tribes 2 Support
// #version = 1.71
// #date = June 19, 2001
// #author =Mark Dickenson ([AKA]PanamaJack)
// #email = akapanamajack@wildmail.com
// #web = http://www.planetstarsiege.com/pj
// #description = Support routines for my scripts
// #acknowledgements = none
// #status = working

$PJVersion::Support = "1.71";

//
//	Function Calls
//
//	If %detag is left off the following function calls
//	will not strip the tag information from the value passed.
//
//	If you would like the functions to automatically strip the tag set %detag to 1.
//
//	getClientName(%clientId, %detag) - Returns the Clients player name
//	getClientTag(%clientId, %detag) - Returns the Player Tag for use with %playertag.score, %playertag.getInventory(), ect
//	getClientId(%realname, %detag) - Returns the Client ID for that player name
//	getClientTeamId(%clientId, %detag) - Returns the Team ID for that client (usually 1 or 2)
//	getClientTeamName(%clientId, %detag) - Returns the Team Name for that client
//
//	getManagerId() - Returns your Client ID
//	getManagerName() - returns your Client Name
//	getManagerTribe() - Returns your Client Tribe ID if any
//	getManagerVehicle() - Returns vehicle type client is in - None, Hoverbike, Assault, MPB, Bomber, Shrike, HAPC
//	getManagerPosition() = Returns location in vehicle - None, Pilot, Bombardier, Tailgunner, Gunner, LeftRear, LeftFront, RightRear, RightFront
//
//	getEnemyTeam() - returns Enemy Team Name
//	getFriendlyTeam() - returns Friendly Team Name
//

//
//	isManagerName(%clientname, %detag) - Compares the client name with the Managers Name
//							No Match reurns false
//							Match returns true
//
//	isManagerName should be used for ALL checks of player names when you are trying to find a match to
//	the clients player name.

//
//	New Callback Triggers
//	All Callback triggers pass Detagged Information
//
//	'msgITeamChanged' - Is triggered when you change teams and passes your Client ID
//	'msgFriendlyJoined' - Is triggered when a new client joins your team and passes the players Client ID
//	'msgEnemyJoined' - Is triggered when a new client joins the enemy team and passes the players Client ID
//	'msgLeftTeam' - Is triggered when a client leaves your team and passes the players Client ID
//	'msgTeamCountUpdate' - Is triggered when player totals change and passes Team 1's Total and Team 2's Total
//
//	example:
//
//	addMessageCallback('msgFriendlyJoined', handleMyJoined);
//
//	function handleMyJoined(%msgType, %msgString, %clientId) {
//	}
//
//	%msgType = msgFriendlyJoined
//	%msgString = ""
//	%clientId = passed detagged client ID argument
//
//	example:
//
//	addMessageCallback('msgTeamCountUpdate', handleMyTeamCount);
//
//	function handleMyJoined(%msgType, %msgString, %team1total, %team2total, %observertotal) {
//	}
//
//	%msgType = msgFriendlyJoined
//	%msgString = ""
//	%team1total = passed total players on team 1
//	%team2total = passed total players on team 2
//	%observertotal = passed total number of observers
//

//
//
//	New Callback Triggers for Vehicle Mounting and Dismounting
//
//	I could have used the callbacks that are included in Writer Support package but they
//	took way too much code to do something so simple.  This single callback is much smaller
//	and gives even MORE information as to your location in the vehicle.  The callback is 
//	triggered when you enter or leave any position in any of the base vehicles.  You can 
//	also check at anytime to see if you are in a vehicle and the position using the 
//	getManagerVehicle() and getManagerPosition() functions.
//
//	'msgVehicleMode' - Returns the name of the vehicle entered and your position in the vehicle.
//
//	example:
//
//	addMessageCallback('msgVehicleMode', handleMyVehicle);
//
//	function handleMyVehicle(%msgType, %msgString, %vehType, %position) {
//	}
//
//	Here is the %vehType and %position tables of data sent.
//
//	%vehType	%position
//	--------	--------
//	None		None
//	Hoverbike	Pilot
//	Assault		Pilot, Gunner
//	MPB		Pilot
//	Shrike		Pilot
//	Bomber		Pilot, Bombardier, Tailgunner
//	HAPC		Pilot, Tailgunner, LeftRear, LeftFront, RightRear, RightFront
//
//	%vehType will be "None" when the client exits the vehicle.
//

//
//	You can now use an RGB Dialog for setting colors of text in the game.
//
//	setRGBcolor(%color, %variable, %routine)
//
//	%color - initial color value to open RGB Dialog
//
//	%variable - The variable you want the new color value stored
//
//	%routine - The routine you want to execute when dialog closes
//             This is usually an update routine for updating
//             a display. (optional)
//
//	example: setRGBcolor($startcolor, "$mycolor", "Showmyupdate();");
//
//	In the above example the RGB Dialog will open and the Red, Green and Blue
//	sliders will be set to the color in $startcolor.
//
//	When the dialog is closed either by clicking on the CANCEL or SELECT button the
//	previous or new color values will be stored in $mycolor.  You MUST place the variable name
//	within QUOTES!
//
//	And when the dialog is closed either by clicking the CANCEL or SELECT button the
//	Showmyupdate() function is called.  You would use this to cause the RGB Dialog to update
//	a display when the dialog closes.  It is an optional argument so you can leave it off.
//
//	Example of use in a Button GUI.
//
//			new ShellBitmapButton() {
//				profile = "ShellButtonProfile";
//				horizSizing = "center";
//				vertSizing = "bottom";
//				position = "0 55";
//				extent = "130 30";
//				minExtent = "26 27";
//				command = "setRGBcolor($PJColor::PopupTeam, \"$PJColor::PopupTeam\", \"PJshowPopupTeam();\");";
//				visible = "1";
//				helpTag = "0";
//				text = "Set Team Color";
//				maxLength = "255";
//			};
//
//	The above will execute the setRGBcolor command when the button is pressed.  $PJColor::PopupTeam is the
//	HEX code color information being passed to the routine for the initial slider setup.  The second
//	$PJColor::PopupTeam that is enclose in Quotes is the variable you would like the new HEX color codes
//	to be saved to when exiting the dialog.  The PJshowPopupTeam(); that is enclosed in quotes is the routine
//	you would like the Dialog to execute when the Select button is clicked.

//
//	You can now use a Font Selector Dialog for setting the font and size of text in the game.
//
//	PJselectFont(%variable, %routine)
//
//	%variable - The variable you want the new font tag value stored
//			Returned value will be in <font:fontname:fontsize> format
//			IE: <font:Arial Bold:25>
//			You would just insert the %variable in your text string to change the font and size.
//
//	%routine - The routine you want to execute when dialog closes
//       	      This is usually an update routine for updating
//     		      a display. (optional)
//
//	example: PJSelectFont("$myvariable", "echo($myvariable);");
//
//	In the above example the Font Selection Dialog will open.
//
//	When the dialog is closed either by clicking on the CANCEL or SELECT button the
//	font data is stored in the variable you indicated.  You MUST place the variable name
//	within QUOTES!  If CANCEL was selected your variable will not contain any data.
//
//	And when the dialog is closed either by clicking the CANCEL or SELECT button the
//	echo($myvariable); function is called.  In this case it would echo to your console 
//	the font tag in the variable name you supplied.  You would use this to cause the
//	Font Selector Dialog to update a display when the dialog closes.  
//	It is an optional argument so you can leave it off.
//
//	Example of use in a Button GUI.
//
//			new ShellBitmapButton() {
//				profile = "ShellButtonProfile";
//				horizSizing = "center";
//				vertSizing = "bottom";
//				position = "0 55";
//				extent = "130 30";
//				minExtent = "26 27";
//				command = "PJSelectFont(\"$PJFontData\", \"PJUpdateSpeedFont();\");";
//				visible = "1";
//				helpTag = "0";
//				text = "Set Speed Hud Font";
//				maxLength = "255";
//			};
//
//	The above will execute the PJSelectFont command when the button is pressed.  The first argument
//	$PJFontData that is enclose in Quotes is the variable you would like the new font tag
//	to be saved to when exiting the dialog.  The PJUpdateSpeedFont(); that is enclosed in 
//	quotes is the routine you would like the Dialog to execute when the Select button is clicked.

//
//
//	%newstring = StripAll(%string) - Removes all control, color and non 
//			alpha numerics from the string and returns the stripped string
//
//	%newstring = StripNameColors(%string) - Removes all control and color codes from the string
//
//	removeMessageCallback(%msgType, %func) - this is the reverse of the addMessageCallback routine.
//			It will remove the callback function from the array and reorder it.
//
//


new GuiControlProfile ("GuiRGBProfile")
{
	fontType = "Univers Condensed Bold";
	fontSize = 28;
	fontColor = "169 215 250";
};

new GuiControlProfile ("GuiFontProfile")
{
	fontType = "Univers Bold";
	fontSize = 18;
	fontColor = "169 215 250";
};

function getManagerPosition() {

	return $PJVehiclePosition;
}

function getManagerVehicle() {

	return $PJVehicleType;
}

function isManagerName(%clientname, %detag) {

	if(%detag == 1)
		%clientname = detag(%clientname);

	if(%clientname $= getManagerName()) {
		return true;
	} else {
		return false;
	}
}

function getManagerId() {

	return $CurrentClientId;
}

function getManagerName() {

	return $CurrentPlayerName;
}

function getManagerTribe() {

	return $CurrentPlayerTag;
}

function getEnemyTeam() {

	return $CurrentTeamEnemy;
}

function getFriendlyTeam() {

	return $CurrentTeamFriendly;
}

function getClientTag(%clientId, %detag) {

	if(%detag == 1)
		%clientId = detag(%clientId);

	return $PlayerList[%clientId];
}

function getClientName(%clientId, %detag) {

	if(%detag == 1)
		%clientId = detag(%clientId);

	%player = $PlayerList[%clientId];

	return %player.name;
}

function getClientId(%realname, %detag) {

	if(%detag == 1)
		%realname = detag(%realname);

	if($PJTeamData::name2id[%realname] $= "") {
		return false;
	} else {
		return $PJTeamData::name2id[%realname];
	}
}

function getClientTeamId(%clientId, %detag) {

	if(%detag == 1)
		%clientId = detag(%clientId);

	%player = $PlayerList[%clientId];

	return %player.teamId;
}

function getClientTeamName(%clientId, %detag) {

	if(%detag == 1)
		%clientId = detag(%clientId);

	%player = $PlayerList[%clientId];
	%teamId = %player.teamId;

	return $clTeamScore[%teamId,0];
}

function handleTTjoin(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid) {

	if(StrStr(%msgString, "Welcome to Tribes") != -1) {
		echo("I found your Client Number: "@%clientId);
		$CurrentClientId = %clientId;
		$CurrentPlayerName = detag(%clientName);

		if(%isSmurf) {
			echo("Oh How Smurfy you are...");
			$CurrentPlayerTag = "";
		}
	}
}

function handleTTjointeam(%msgType, %msgString, %clientName, %teamName, %clientId, %teamId) {

	%realname = detag(%clientName);
	%realteam = detag(%teamName);

	if(%clientId == getManagerId()) {
		if(%teamId == 0) {
			$CurrentTeamFriendly = "Unassigned";
			$CurrentTeamEnemy = "Unassigned";
		} else {
			$CurrentTeamFriendly = $clTeamScore[%teamId, 0];
			FindEnemyTeam();
		}
	}

	if($PJTeamTotals < %teamId)
		$PJTeamTotals = %teamId;

	if(%realname $= "")
		%realname = getClientName(%clientid);

	%oldteam = getClientTeamId(%clientId);

	for(%i = 0; %i <= $clTeamCount; %i++) {
		if(%i != %oldteam)
			PJTeam::DeleteFromTeam(%clientid, %i);
	}

	PJTeam::Joined(%clientid, %realname, %teamid, %realteam);

}

function handleTTdrop(%msgType, %msgString, %clientName, %clientId) {

	%realname = detag(%clientName);
	$PJTeamData::name2id[%realname] = "";

	PJTeam::List();

	for(%i = 0; %i <= $clTeamCount; %i++) {
		PJTeam::DeleteFromTeam(%clientid, %i);
	}
}

function FindEnemyTeam() {

	for(%i = 1; %i <= $clTeamCount; %i++) {
		if ($clTeamScore[%i, 0] !$= $CurrentTeamFriendly)
			$CurrentTeamEnemy = $clTeamScore[%i, 0];
	}
}

function PJTeam::Reset() {
	deletevariables("$PJTeamData::name2id*");
	$CurrentTeamFriendly = "";
	$CurrentTeamEnemy = "";
	$CurrentClientId = 0;
}


function PJTeam::Joined(%clientid, %realname, %teamid, %realteam) {

	$PJTeamData::name2id[%realname] = %clientid;

	if(isManagerName(%realname)) {
		clientCmdServerMessage('msgITeamChanged', "", %clientId);
	}

	PJTeam::List();
	PJTeam::AddToTeam(%clientid, %teamid);
}



function PJTeam::AddToTeam(%client, %team) {

	if(%client == $CurrentClientId) {
		for(%i = 0; %i < PlayerListGroup.getCount(); %i++) {
			%player = PlayerListGroup.getObject(%i);
			if(%player.teamId == %team) {
				clientCmdServerMessage('msgFriendlyJoined', "", %player.clientId);
			}
		}
	} else if(%team == getClientTeamId(getManagerId())) {
		clientCmdServerMessage('msgFriendlyJoined', "", %client);
		} else clientCmdServerMessage('msgEnemyJoined', "", %client);
}

function PJTeam::DeleteFromTeam(%client, %team) {

	if(%client == $CurrentClientId) {
		for(%i = 0; %i < PlayerListGroup.getCount(); %i++) {
			%player = PlayerListGroup.getObject(%i);
			if(%player.teamId == %team)
				clientCmdServerMessage('msgFriendlyDropped', "", %player.clientId);
		}
	} else clientCmdServerMessage('msgLeftTeam', "", %client);
}


function PJTeam::List(%show) {

	if($PJTeamTotals < 2)
		$PJTeamTotals = 2;

	for(%tt = 0; %tt <= $PJTeamTotals; %tt++) {
	$PJteam::Totals[%tt] = 0;

		for(%i = 0; %i < PlayerListGroup.getCount(); %i++) {
			%player = PlayerListGroup.getObject(%i);
			if(%player.teamId == %tt) {
				if(%show !$= "")
					echo($PJteam::Totals[%tt]@". Name = "@%player.name@", Team = "@%player.teamId@", Teamname = "@$clTeamScore[%player.teamId,0]);
				$PJteam::Totals[%tt]++;
			}
		}

		if(%show !$= "")
			echo("\nTeam " @ %tt @ " Total = "@$PJteam::Totals[%tt] @ "\n\n");
	}

	clientCmdServerMessage('msgTeamCountUpdate', "", $PJteam::Totals[1], $PJteam::Totals[2], $PJTeam::Totals[0]);
}

package PJSupportLoad {

function DispatchLaunchMode() {

// Support
	addMessageCallback('MsgClientJoin', handleTTjoin);
	addMessageCallback('MsgClientJoinTeam', handleTTjointeam);
	addMessageCallback('MsgClientDrop', handleTTdrop);

//Call the Parent
	parent::DispatchLaunchMode();

	PJMakeRGBdlg();
	PJMakeFontDlg();
	findAllFonts();
}

function DisconnectedCleanup() {

// Call Parent
	parent::DisconnectedCleanup();

// Support 1
	echo("Disconnected Clearing Team List");
	PJTeam::Reset();

}

function LoadingGui::onWake(%this) {

// Support 1
	$CurrentPlayerTag = getField( wonGetAuthInfo(), 1);

//Call the Parent
	parent::onWake(%this);
}

// End of Player Events

//
//
// Vehicle Events
//
//


function ClientCmdDisplayHuds() {

parent::ClientCmdDisplayHuds();

	switch$ ($HudMode) {

		case "Pilot":
			$HudMode = $HudMode;

		case "Passenger":
			$HudMode = $HudMode;

		case "Object":
			clientCmdServerMessage('msgVehicleMode', "", "None", "None");
			$PJVehiclePosition = "None";
			$PJVehicleType = "None";

		case "Observer":
			clientCmdServerMessage('msgVehicleMode', "", "None", "None");
			$PJVehiclePosition = "None";
			$PJVehicleType = "None";

		case "PickTeam":
			clientCmdServerMessage('msgVehicleMode', "", "None", "None");
			$PJVehiclePosition = "None";
			$PJVehicleType = "None";

		default:
			clientCmdServerMessage('msgVehicleMode', "", "None", "None");
			$PJVehiclePosition = "None";
			$PJVehicleType = "None";
	}

}


function clientCmdShowVehicleGauges(%vehType, %node) {

	parent::clientCmdShowVehicleGauges(%vehType, %node);

	$PJVehiclePosition = "Pilot";
	$PJVehicleType = %vehType;

	if(%vehType $= "HAPC") {
		switch(%node) {
			case 0:
				$PJVehiclePosition = "Pilot";
			case 1:
				$PJVehiclePosition = "Tailgunner";
			case 2:
				$PJVehiclePosition = "LeftFront";
			case 3:
				$PJVehiclePosition = "LeftRear";
			case 4:
				$PJVehiclePosition = "RightRear";
			case 5:
				$PJVehiclePosition = "RightFront";
		}
	}

	if(%vehType $= "Bomber") {
		switch(%node) {
			case 0:
				$PJVehiclePosition = "Pilot";
			case 1:
				$PJVehiclePosition = "Bombardier";
			case 2:
				$PJVehiclePosition = "Tailgunner";
		}
	}

	if(%vehType $= "Assault") {
		switch(%node) {
			case 0:
				$PJVehiclePosition = "Pilot";
			case 1:
				$PJVehiclePosition = "Gunner";
		}
	}

	clientCmdServerMessage('msgVehicleMode', "", %vehType, $PJVehiclePosition);
}

// End of Vehicle Events

function PJMakeRGBdlg() {

//--- OBJECT WRITE BEGIN ---
new GuiControl(PJRGBDlg) {
	profile = "DlgBackProfile";
	horizSizing = "right";
	vertSizing = "bottom";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";

	new ShellPaneCtrl() {
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "134 64";
		extent = "372 240";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "Select Color";
		noTitleBar = "0";

		new ShellBitmapButton(PJRGBCANCEL) {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "57 175";
			extent = "128 38";
			minExtent = "32 38";
			visible = "1";
			command = "$PJColor = $PJOldColor; RGBonSleep();";
			helpTag = "0";
			text = "Cancel";
			simpleStyle = "0";
		};

			new GuiTextCtrl() {
				profile = "ShellTextCenterProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "25 60";
				extent = "320 20";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				text = "Red";
				maxLength = "255";
				};
			new ShellSliderCtrl(GMH_PJRedSlider) {
				profile = "ShellSliderProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 75";
				extent = "320 24";
				minExtent = "12 24";
				visible = "1";
				variable = "value";
				altCommand = "setPJRedColor();";
				helpTag = "0";
				range = "0.000000 0.996094";
				ticks = "256";
				value = "1";
				usePlusMinus = "1";
			};
			new GuiTextCtrl() {
				profile = "ShellTextCenterProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "25 95";
				extent = "320 20";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				text = "Green";
				maxLength = "255";
				};
			new ShellSliderCtrl(GMH_PJGreenSlider) {
				profile = "ShellSliderProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 110";
				extent = "320 24";
				minExtent = "12 24";
				visible = "1";
				variable = "value";
				altCommand = "setPJGreenColor();";
				helpTag = "0";
				range = "0.000000 0.996094";
				ticks = "256";
				value = "1";
				usePlusMinus = "1";
			};
			new GuiTextCtrl() {
				profile = "ShellTextCenterProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "25 130";
				extent = "320 20";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				text = "Blue";
				maxLength = "255";
				};
			new ShellSliderCtrl(GMH_PJBlueSlider) {
				profile = "ShellSliderProfile";
				horizSizing = "right";
				vertSizing = "bottom";
				position = "27 145";
				extent = "320 24";
				minExtent = "12 24";
				visible = "1";
				variable = "value";
				altCommand = "setPJBlueColor();";
				helpTag = "0";
				range = "0.000000 0.996094";
				ticks = "256";
				value = "1";
				usePlusMinus = "1";
			};

		new ShellBitmapButton(PJRBGOK) {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "194 175";
			extent = "128 38";
			minExtent = "32 38";
			visible = "1";
			command = "$PJColor = PJMakeRGB(); RGBonSleep();";
			helpTag = "0";
			text = "Select";
			simpleStyle = "0";
		};
		new GuiMLTextCtrl(PJ_RGBShowMe) {
			profile = "GuiRGBProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "179 35";
			extent = "200 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
			text = "** Current Color **";
		};
	};
};
//--- OBJECT WRITE END ---
}


};

activatePackage(PJSupportLoad);

//
//  %color - initial color value to open RGB Dialog
//
//  %variable - The variable you want the new color value stored
//
//  %routine - The routine you want to execute when dialog closes
//             This is usually an update routine for updating
//             a display.
//

function setRGBcolor(%color, %variable, %routine) {

    PJRBGOK.command = %variable @ " = PJMakeRGB(); RGBonSleep(); " @ %routine;
    PJRGBCANCEL.command = %variable @ " = $PJOldColor; RGBonSleep(); " @ %routine;
	Canvas.pushDialog(PJRGBDlg);

    $PJOldColor = %color;

	$PJRed = HexToDecimal(getSubStr(%color, 0, 2));
	GMH_PJRedSlider.setValue ( $PJRed * 0.00390625);

	$PJGreen = HexToDecimal(getSubStr(%color, 2, 2));
	GMH_PJGreenSlider.setValue ( $PJGreen * 0.00390625);

	$PJBlue = HexToDecimal(getSubStr(%color, 4, 2));
	GMH_PJBlueSlider.setValue ( $PJBlue * 0.00390625);

}

$PJHex = "0123456789ABCDEF";

function HexToDecimal(%hex) {

    %hex = strupr(%hex);
    
    %number = StrStr($PJHex, getSubStr(%hex, 0, 1)) * 16;
    %number = %number + StrStr($PJHex, getSubStr(%hex, 1, 1));

    return %number;
}

function DecimalToHex(%decimal) {

    %hex1 = mfloor(%decimal / 16);
    %hex2 = %decimal - (%hex1 * 16);
    
    %hex = getSubStr($PJHex, %hex1, 1) @ getSubStr($PJHex, %hex2, 1);
    
    return %hex;

}

function setPJRedColor() {

	$PJRed = mfloor(GMH_PJRedSlider.getValue() * 256);
    %color = PJMakeRGB();
	PJ_RGBShowMe.setText("<just:center><color:" @ %color @">** Current Color **");

}

function setPJGreenColor() {

	$PJGreen = mfloor(GMH_PJGreenSlider.getValue() * 256);
    %color = PJMakeRGB();
	PJ_RGBShowMe.setText("<just:center><color:" @ %color @">** Current Color **");

}

function setPJBlueColor() {

	$PJBlue = mfloor(GMH_PJBlueSlider.getValue() * 256);
    %color = PJMakeRGB();
	PJ_RGBShowMe.setText("<just:center><color:" @ %color @">** Current Color **");

}

function PJMakeRGB() {

    %color = DecimalToHex($PJRed);
    %color = %color @ DecimalToHex($PJGreen);
    %color = %color @ DecimalToHex($PJBlue);

    return %color;
}

function RGBonSleep() {

	Canvas.popDialog(PJRGBDlg);
}

function StripAll(%in) {

	%name = "";

	for (%i = 0; %i < Strlen(%in); %i++)
	{
		%ascii = String::ascii(%in, %i);
		if (((%ascii > 47) && (%ascii < 58)) || ((%ascii > 64) && (%ascii < 91)) || ((%ascii > 96) && (%ascii < 123)))
			%name = %name @ String::char(%ascii);
	}

	%name = %name @ "";
	return %name;
}

function StripNameColors(%in) {

	%name = "";

	for (%i = 0; %i < Strlen(%in); %i++)
	{
		%ascii = String::ascii(%in, %i);
		if ((%ascii > 31) && (%ascii < 129))
			%name = %name @ String::char(%ascii);
	}

	%name = %name @ "";
	return %name;
}

function String::ascii(%string, %idx)
{

	if(Strlen(%string) <= %idx || %idx < 0)
	    return -1;
	%char = getSubStr(%string, %idx, 1);
	%idx = Strstr($String::asciiString, %char);
	if(%idx < 0)
		return -1;

	if(Strcmp(%char, getSubStr($String::asciiString, %idx, 1)) == 0)
		return %idx + 32;
    else
        return %idx + 64;
}

function String::char(%ascii)
{
	if(%ascii < 32 || %ascii > 128)
		return "";
	else
		return getSubStr($String::asciiString, %ascii-32, 1);
}

$String::asciiString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

function removeMessageCallback(%msgType, %func) {

	for(%i = 0; (%afunc = $MSGCB[%msgType, %i]) !$= ""; %i++) {

		if(%afunc $= %func) {
			doCallbackDelete(%msgtype, %i);
			return;
		}
	}
}

function doCallbackDelete(%msgType, %location) {

	for(%i = %location; $MSGCB[%msgType, %i] !$= ""; %i++) {
		$MSGCB[%msgType, %i] = $MSGCB[%msgType, %i + 1];
	}

	$MSGCB[%msgType, %i] = "";
}

//
// Font Selector
//

function PJMakeFontDlg() {

//--- OBJECT WRITE BEGIN ---
new GuiControl(PJFontDlg) {
	profile = "DlgBackProfile";
	horizSizing = "right";
	vertSizing = "bottom";
	position = "0 0";
	extent = "640 480";
	minExtent = "8 8";
	visible = "1";
	helpTag = "0";

	new ShellPaneCtrl() {
		profile = "ShellDlgPaneProfile";
		horizSizing = "center";
		vertSizing = "center";
		position = "134 64";
		extent = "372 240";
		minExtent = "48 92";
		visible = "1";
		helpTag = "0";
		text = "Set Font Selection";
		noTitleBar = "0";

		new ShellBitmapButton(PJFontCANCEL) {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "57 175";
			extent = "128 38";
			minExtent = "32 38";
			visible = "1";
			command = "$PJSelectedFont = \"\"; $PJSelectedFontSize = \"\"; PJfontonSleep();";
			helpTag = "0";
			text = "Cancel";
			simpleStyle = "0";
		};

		new ShellPopupMenu(PJFontList) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "50 50";
			extent = "205 36";
			minExtent = "49 36";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Font Type";
			maxLength = "255";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};

		new ShellPopupMenu(PJFontSizeList) {
			profile = "ShellPopupProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "265 50";
			extent = "65 36";
			minExtent = "49 36";
			visible = "1";
			hideCursor = "0";
			bypassHideCursor = "0";
			helpTag = "0";
			text = "Font Size";
			maxLength = "255";
			maxPopupHeight = "200";
			buttonBitmap = "gui/shll_pulldown";
			rolloverBarBitmap = "gui/shll_pulldownbar_rol";
			selectedBarBitmap = "gui/shll_pulldownbar_act";
			noButtonStyle = "0";
		};

		new ShellFieldCtrl() {
			profile = "ShellFieldProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "0 90";
			extent = "300 85";
			minExtent = "16 18";
			visible = "1";
			helpTag = "0";

			new GuiMLTextCtrl(PJFontDisplay) {
				profile = "ShellTextCenterProfile";
				horizSizing = "center";
				vertSizing = "center";
				position = "4 4";
				extent = "298 83";
				minExtent = "8 8";
				visible = "1";
				helpTag = "0";
				maxLength = "255";
			};
		};

		new ShellBitmapButton(PJFontOK) {
			profile = "ShellButtonProfile";
			horizSizing = "right";
			vertSizing = "top";
			position = "194 175";
			extent = "128 38";
			minExtent = "32 38";
			visible = "1";
			command = "PJfontonSleep();";
			helpTag = "0";
			text = "Select";
			simpleStyle = "0";
		};
		new GuiMLTextCtrl(PJFontText) {
			profile = "GuiFontProfile";
			horizSizing = "center";
			vertSizing = "top";
			position = "179 35";
			extent = "250 22";
			minExtent = "8 8";
			visible = "1";
			helpTag = "0";
		};
	};
};
//--- OBJECT WRITE END ---
}

function findAllFonts() {

	%path = "fonts/*.gft";
	for( %file = findFirstFile( %path ); %file !$= ""; %file = findNextFile( %path ) ) {
		%temp =getSubStr(%file, 6, 256);
		%location = StrStr(%temp, "_");
		%fontname = getSubStr(%temp, 0, %location);
		%temp = getSubStr(%temp, %location + 1, 256);
		%location = StrStr(%temp, ".");
		%fontsize = getSubStr(%temp, 0, %location);

		if($FontTotal[%fontname] < 1) {
			$TotalFonts++;
			$Fontname[$TotalFonts] = %fontname;
		}

		$FontTotal[%fontname]++;
		%temp = $FontTotal[%fontname];
		$FontSize[%fontname @ %temp] = %fontsize;

	}

	for(%font = 1; %font <= $TotalFonts; %font++) {
		%fontname = $Fontname[%font];
		%temp = $FontTotal[%fontname];

		for (%i = 1; %i <= %temp; %i++) {
			for (%j = %i+1; %j <= %temp; %j++) {
				if ($FontSize[%fontname @ %i] > $FontSize[%fontname @ %j]) {
					%temp2 = $FontSize[%fontname @ %j];
					$FontSize[%fontname @ %j] = $FontSize[%fontname @ %i];
					$FontSize[%fontname @ %i] = %temp2;
				}
			}
		}
	}
}

function PJFontList::onSelect( %this, %id, %text ) {

	$PJSelectedFont = %text;

	PJFontSizeList.clear();
	%fontname = $Fontname[%id + 1];
	%temp = $FontTotal[%fontname];
	for(%i1 = 1; %i1 <= %temp; %i1++) {
		PJFontSizeList.add( $FontSize[%fontname @ %i1], %i1 - 1 );
	}

	PJFontSizeList.setSelected( 0 );
	$PJSelectedFontSize = $FontSize[%fontname @ "1"];
	PJUpdateFontDisplay();
}

function PJFontSizeList::onSelect( %this, %id, %text ) {

	$PJSelectedFontSize = %text;
	PJUpdateFontDisplay();
}

function PJfontonSleep() {

	Canvas.popDialog(PJFontDlg);
}

function PJselectFont(%variable, %routine) {

    PJFontOK.command = %variable @ " = \"<Font:\" @ $PJSelectedFont @ \":\" @ $PJSelectedFontSize @ \">\"; PJFontonSleep(); " @ %routine;
    PJFontCANCEL.command = %variable @ " = \"\"; PJFontonSleep(); " @ %routine;
	Canvas.pushDialog(PJFontDlg);
	PJFontText.setText("<just:center><color:00df30>Make Font and Size Selection");
	PJFontList.clear();
	for( %i = 1; %i <= $TotalFonts; %i++ )
		PJFontList.add( $Fontname[%i], %i - 1);

	PJFontList.sort();
	PJFontList.setSelected( 0 );
	$PJSelectedFont = $FontName[1];

	PJFontSizeList.clear();
	%fontname = $Fontname[1];
	%temp = $FontTotal[%fontname];
	for(%i1 = 1; %i1 <= %temp; %i1++) {
		PJFontSizeList.add( $FontSize[%fontname @ %i1], %i1 - 1 );
	}

	PJFontSizeList.setSelected( 0 );
	$PJSelectedFontSize = $FontSize[%fontname @ "1"];

	PJUpdateFontDisplay();
}

function PJUpdateFontDisplay() {

	PJFontDisplay.setValue("<just:center><font:" @ $PJSelectedFont @ ":" @ $PJSelectedFontSize @ "><color:ccdf30>1234 AaBbCcDdEe");

}

function isFont(%fontname, %fontsize) {

	for( %i = 1; %i <= $TotalFonts; %i++ ) {
		if( $Fontname[%i] $= %fontname) {
			%tempFont = $FontName[%i];
			%temptotal = $FontTotal[%tempFont];

			for(%i1 = 1; %i1 <= %temptotal; %i1++) {
				if( $FontSize[%tempFont @ %i1] $= %fontsize )
					return true;
			}
		}
	}

	return false;
}

$PJVehiclePosition = "None";
$PJVehicleType = "None";

$CurrentPlayerName = "";
$CurrentPlayerTag = "";
$CurrentTeamFriendly = "";
$CurrentTeamEnemy = "";
$CurrentClientId = 0;
$PJScript::Support1 = 1;

PJTeam::Reset();
