////////////////////////////////////////////////////////////////////////////////
// logpositiondata.cs
//
//
// Pipe Data Format:
//
// position data
////////////////////////////////////////////////////////////////////////////////

schedule(1000, 0, pipe_wait_for_start);



////////////////////////////////////////////////////////////////////////////////

 
function pipe_wait_for_start()
{
    $pipe_current = $missionSequence;
    $pipe_flag_count = 0;


    if (($LoadingMission)  || (!isObject(MissionGroup)))
    {
        $pipe_wait_schedule = schedule(1000, 0, pipe_wait_for_start);
        return;
    }

    if (isObject(MissionGroup))
        pipe_find_flags(MissionGroup);


    $pipe_out_schedule = schedule(1000, 0, pipe_out_data);
}

////////////////////////////////////////////////////////////////////////////////

$n_players = 0;
$playerIDs = "nothing";
$data = "nothing";

function pipe_out_data()
{
    if ($missionSequence != $pipe_current)
    {
        $pipe_wait_schedule = schedule(1000, 0, pipe_wait_for_start);
        return;
    }

    $n_players = 0;

    // players
    for (%ci = 0; %ci < ClientGroup.getCount(); %ci++)
    {
        %client = ClientGroup.getObject(%ci);
        %playerID = %client.player;
        
        if (%client.nameBase $= "Omroth")
            $me = %client;
            
        if (%playerID.position !$= "")  // alive player
        {
            $data[%playerID,0] = getWord(%playerID.position, 0);
            $data[%playerID,1] = getWord(%playerID.position, 1);
            $data[%playerID,2] = getWord(%playerID.position, 2);
            $data[%playerID,3] = %client.team;
            $data[%playerID,4] = %client.nameBase;
            $data[%playerID,5] = 0;

            // add to playerIDs array
            $playerIDs[$n_players] = %playerID;
            $n_players ++;
        }
    }

    // flags
    for (%i = 0; %i != $pipe_flag_count; %i++)
    {
        %flag = $pipe_flag[%i];
        if (%flag.carrier $= "")
        {
            %flagID = "flag" @ %flag.team;
            $data[%flagID,0] = getWord(%flag.position, 0);
            $data[%flagID,1] = getWord(%flag.position, 1);
            $data[%flagID,2] = getWord(%flag.position, 2);
            $data[%flagID,3] = %flag.team;
            $data[%flagID,4] = "flag" @ %flag.team;
            $data[%flagID,5] = %flag.isHome;

            // add to playerIDs array
            $playerIDs[$n_players] = %flagID;
            $n_players ++;
        }
        else
        {
            $data[%flag.carrier,5] = 1;
        }
    }
    

    main_snapcam_loop();
    $pipe_out_schedule = schedule(1000, 0, pipe_out_data);
}

////////////////////////////////////////////////////////////////////////////////


function pipe_find_flags(%group)
{
    for (%i = 0; %i < %group.getCount(); %i++)
    {
        %obj = %group.getObject(%i);
        %type = %obj.getClassName();

        if (%type $= "SimGroup")
        {
            pipe_find_flags(%obj);
        }
        else if (%type $= "Item" && %obj.dataBlock $= "Flag")
        {
            $pipe_flag[$pipe_flag_count] = %obj;
            $pipe_flag_count ++;
        }
    }
}



////////////////////////////////////////////////////////////////////////////////


