$time_in_state = 0;
$max_time = 15;



function choose_focus( %current )
{
    %change = 0;
    
    %bestscore = -5; // yes.  -5.
    %n_bclusters = 0;
    
    for (%i = 0; %i < $n_clusters; %i ++)
    {
        %score = cluster_score(%i);
        if (%score > %bestscore)
        {
            %bestscore = %score;
            
            %best_clusters[0] = %i;
            %n_bclusters = 1;
        }
        else if (%score == %bestscore)
        {
            %best_clusters[%n_bclusters] = %i;
            %n_bclusters ++;
        }
    }

    %best_cluster = %best_clusters[getRandom(0,%n_bclusters-1)];

    if (!watchable_player(%current))
        %change = 1;
    else if ($time_in_state > $max_time)
        %change = 1;
    else if ((2 * cluster_score($players_to_clusters_map[%current])) < %bestscore)
        %change = 1;



    if (%change) // watch the best cluster
    {
        %player_to_watch = valid_player_from_cluster( %best_cluster );
        $time_in_state = 0;
        //echo("changed to " @ %player_to_watch);
    }
    else
    {
        %player_to_watch = %current;
        $time_in_state ++;
    }


    //echo("best cluster: " @ %best_cluster);
    //echo("best score: " @ %bestscore);
    //echo("player_to_watch: " @ %player_to_watch);
    //echo("owning_cluster: " @ $players_to_clusters_map[%player_to_watch]);
    //echo("owning cluster score: " @ cluster_score($players_to_clusters_map[%player_to_watch]));
    //echo("---------------");

    return %player_to_watch;
}



function cluster_score( %cluster_index )
{
    %carried_flags = 0;
    %field_flags = 0;
    %n_teamplayers[1] = 0;
    %n_teamplayers[2] = 0;
    
    for (%i = 0; %i < $n_pc[%cluster_index]; %i ++)
    {
        %playerID = $clusters[%cluster_index,%i];
        if (($data[%playerID,4] $= "flag1") || ($data[%playerID,4] $= "flag2"))  // it's a flag
        {
            if (!$data[%playerID,5])
                %field_flags ++;
        }
        else    // it's a player
        {
            %n_teamplayers[$data[%playerID,3]] ++;
            if ($data[%playerID,5])
                %carried_flags ++;
        }
    }
    
    if (%n_teamplayers[1] < %n_teamplayers[2])
        %min_teamplayers = %n_teamplayers[1];
    else
        %min_teamplayers = %n_teamplayers[2];
    
    %score = %min_teamplayers;
    %score += 2 * %min_teamplayers * %field_flags;
    %score += 100 * %carried_flags;

    return %score;
}

function lower_team( %cluster_index )
{
    %n_teamplayers[1] = 0;
    %n_teamplayers[2] = 0;

    for (%i = 0; %i < $n_pc[%cluster_index]; %i ++)
    {
        %playerID = $clusters[%cluster_index,%i];
        if (($data[%playerID,4] $= "flag1") || ($data[%playerID,4] $= "flag2"))  // it's a flag
        {
            // nothing
        }
        else    // it's a player
        {
            %n_teamplayers[$data[%playerID,3]] ++;
        }
    }

    if (%n_teamplayers[1] < %n_teamplayers[2])
        %low_team = 1;
    else
        %low_team = 2;

    return %low_team;
}

function watchable_player( %playerID )
{
    for (%i = 0; %i < $n_players_to_watch; %i ++)
    {
        %other = $playerIDs_to_watch[%i];
        if (%playerID == %other)
            return 1;
    }
    
    return 0;
}


function valid_player_from_cluster( %cluster_index )
{
    %playerID = -1;

    %flag_player = -1;
    %team_player[1] = -1;
    %team_player[2] = -1;
    
    for (%i = 0; %i < $n_players_to_watch; %i ++)
    {
        %pid = $playerIDs_to_watch[%i];
        if ($players_to_clusters_map[%pid] == %cluster_index)
        {
            if ($data[%pid,5])
            {
                %flag_player = %pid;
            }
            else if (($data[%pid,3] == 1) && (%team_player[1] == -1))
            {
                %team_player[1] = %pid;
            }
            else if (($data[%pid,3] == 2) && (%team_player[2] == -1))
            {
                %team_player[2] = %pid;
            }
        }
    }
    
    %low_team = lower_team( %cluster_index );  // we want to watch someone from the minority side in this cluster
    
    if (%flag_player != -1)
    {
        %playerID = %flag_player;
    }
    else if (%team_player[%low_team] != -1)
    {
        %playerID = %team_player[%low_team];
    }
    else
    {
        %playerID = %team_player[3-%low_team];
    }
    
    
    if (%playerID == -1)
        echo("WARNING!  No valid player in cluster");
    return %playerID;
}


