$debug = 0;

$distances = "nothing";
$clason_constant = 0.25;

$n_clusters = 0;
$n_pc = "nothing";
$clusters = "nothing";
$players_to_clusters_map = "nothing";


function construct_distances()
{
    for (%i = 0; %i < $n_players; %i ++)
    {
        for (%j = %i; %j < $n_players; %j ++)
        {
            %playerID1 = $playerIDs[%i];
            %playerID2 = $playerIDs[%j];

            %distance = distance_between( %playerID1, %playerID2 );

            $distances[%playerID1,%playerID2] = %distance;
            $distances[%playerID2,%playerID1] = %distance;
        }
    }
}


function clason()
{
    if ($debug)
        echo("clason 0");

    // make a local copy of the playerIDs array
    for (%i = 0; %i < $n_players; %i ++)
    {
        %local_playerIDs[%i] = $playerIDs[%i];
    }

    if ($debug)
        echo("clason 1");
        

    if ($debug)
        echo("clason 2");

    %n_hubs = 0;
    
    %hubs[0] = %local_playerIDs[0]; // choose arbitrary first hub
    %n_hubs ++;
    
    %hubs[1] = find_furthest_from( %hubs[0] );  // choose second hub as furthest player from first hub
    %n_hubs ++;
    
    if ($debug)
        echo("clason 3");
    
    for (%i = 0; %i < $n_players; %i ++)  // set players_to_hubs_map
    {
        %playerID = $playerIDs[%i];
        %distance0 = $distances[%playerID,%hubs[0]];
        %distance1 = $distances[%playerID,%hubs[1]];
        
        if (%distance0 < %distance1)
            %players_to_hubs_map[%playerID] = 0;
        else
            %players_to_hubs_map[%playerID] = 1;
    }
    
    if ($debug)
        echo("clason 4");
        
    while (1)
    {
        %sum = 0;
        %n = 0;
        
        for (%i = 0; %i < %n_hubs; %i ++)
        {
            for (%j = %i + 1; %j < %n_hubs; %j ++)
            {
                %sum += $distances[%hubs[%i],%hubs[%j]];
                %n ++;
            }
        }
    
        if ($debug)
            echo("clason 5");
        
        %r = (%sum / %n) * $clason_constant;
        
        %max_distance = 0;
        for (%i = 0; %i < $n_players; %i ++)  // find player who is furthest from his hub
        {
            %playerID = $playerIDs[%i];
            %hub = %hubs[%players_to_hubs_map[%playerID]];
            %distance = $distances[%playerID,%hub];
        
            if (%distance > %max_distance)
            {
                %max_distance = %distance;
                %max_player = %playerID;
            }
        }
        
        if ($debug)
            echo("clason 6");
        
        if (%max_distance < %r)   // we don't need another hub
            break;
            
        %hubs[%n_hubs] = %max_player;
        %n_hubs ++;
        
        for (%i = 0; %i < $n_players; %i ++)
        {
            %playerID = $playerIDs[%i];
            %hub = %hubs[%players_to_hubs_map[%playerID]];
            %distance_old = $distances[%playerID,%hub];
            %distance_new = $distances[%playerID,%hubs[%n_hubs-1]];
            
            if (%distance_new < %distance_old)
                %players_to_hubs_map[%playerID] = %n_hubs - 1;
        }
        
        if ($debug)
            echo("clason 7");
    }
    
    
    $n_clusters = %n_hubs;
    for (%i = 0; %i < %n_hubs; %i ++) // initiate n_players in cluster array
        $n_pc[%i] = 0;
    
    if ($debug)
        echo("clason 8");
    
    for (%i = 0; %i < $n_players; %i ++)
    {
        %playerID = $playerIDs[%i];
        %hubindex = %players_to_hubs_map[%playerID];

        $clusters[%hubindex,$n_pc[%hubindex]] = %playerID;
        $n_pc[%hubindex] ++;
        
        $players_to_clusters_map[%playerID] = %hubindex;
    }
}

function find_furthest_from( %playerID )
{
    %distance = 0;
    %furthestID = %playerID;
    
    for (%i = 0; %i < $n_players; %i ++)
    {
        %other = $playerIDs[%i];
        if ($distances[%playerID, %other] > %distance)
        {
            %distance = $distances[%playerID, %other];
            %furthestID = %other;
        }
    }
    
    return %furthestID;
}


function distance_between( %playerID1, %playerID2 )
{
    %distance = mPow( mPow( $data[%playerID1,0] - $data[%playerID2,0], 2 ) +
                      mPow( $data[%playerID1,1] - $data[%playerID2,1], 2 ), 0.5 );

    return %distance;
}
