$version = 0.6;

////////////////////////////////////////////////////////////////////////////
//  Snapcam
////////////////////////////////////////////////////////////////////////////




function main_snapcam_loop()
{
    // construct the watchable players array
    construct_watchables_array();

    // construct the distances array
    construct_distances();

    // construct the clustering
    clason();
    
    //construct_spector
    construct_spector();
    
    //remove clients no longer in the game from the observers array
    update_observers();
    
    for (%i = 0; %i < $observers_count; %i ++)
    {
        %observer = $observers[%i];

        if (($observer_target[%i] != -10) && (!watchable_player($observer_target[%i])))
            $observer_target[%i] = $playerIDs_to_watch[0];
            
        deal_with(%observer, $observer_target[%i], 1);
    }
}


function snapcam_gui(%observer, %target)
{
    bottomPrint(%observer, getTaggedString(%target.getControllingClient().name), 0, 1);
    //displayObserverHud(%observer, $player_to_watch.getControllingClient(), 0);
}



function deal_with( %observer, %target, %override )
{

    if (%target == -10)
    {
        if (($spector_radius_changed) || (%override))
        {
            snap_follow(%observer.camera, $player_to_watch, 0.5, $spector_active_radius, 4.5);
        }
        snapcam_gui(%observer, $player_to_watch);
    }
    else
    {
        construct_target(%target);
        if (($target_radius_changed[%target]) || (%override))
        {
            snap_follow(%observer.camera, %target, 0.5, $target_active_radius[%target], 4.5);
        }
        snapcam_gui(%observer, %target);
    }
}


function construct_target(%target)
{
        %cluster_to_watch = $players_to_clusters_map[%target];

        // get the radius of the enclosing sphere of the cluster
        %radius = $min_height;
        for (%i = 0; %i < $n_pc[%cluster_to_watch]; %i ++)
        {
            %playerID = $clusters[%cluster_to_watch,%i];
            %distance = $distances[%target,%playerID];
            if (%distance > %radius)
                %radius = %distance;
        }

        if (%radius > $max_height)
            %radius = $max_height;

        if (mAbs( %radius - $last_radius[%observer] ) > $difference_to_change)
        {
            $last_radius[%target] = %radius;
            $target_active_radius[%target]= %radius;
            $target_radius_changed[%target] = 1;
        }
        else
        {
            $target_radius_changed[%target] = 0;
        }
}

$min_height = 25.0;
$max_height = 100.0;
$radius_multiplier = 1.15;
$difference_to_change = 20;

$player_to_watch = -1;
$spector_last_radius = -100;
$last_radius = -100;

function construct_spector()
{
    %last_player_watched = $player_to_watch;

    // get player to watch
    $player_to_watch =  choose_focus($player_to_watch);

    // get the owning cluster of the player to watch
    %cluster_to_watch = $players_to_clusters_map[$player_to_watch];

    // get the radius of the enclosing sphere of the cluster
    %radius = $min_height;
    for (%i = 0; %i < $n_pc[%cluster_to_watch]; %i ++)
    {
        %playerID = $clusters[%cluster_to_watch,%i];
        %distance = $distances[$player_to_watch,%playerID];
        if (%distance > %radius)
            %radius = %distance;
    }

    if (%radius > $max_height)
        %radius = $max_height;

    if ((%last_player_watched != $player_to_watch) || (mAbs( %radius - $spector_last_radius ) > $difference_to_change))
    {
        $spector_last_radius = %radius;
        $spector_active_radius = %radius;
        $spector_radius_changed = 1;
    }
    else
    {
        $spector_radius_changed = 0;
    }
    
    $spector_text = event_text( $player_to_watch, %cluster_to_watch );
    
    //echo("Actual player to watch: " @ $player_to_watch);

}


function event_text( %player_to_watch, %cluster_to_watch )
{

    %line[1] = "Observing: " @ $data[%player_to_watch, 4] @ " (team " @ $data[%player_to_watch, 3] @ ")";
    %line[2] = "With (Team 1):";
    %line[3] = "and (Team 2):";

    for (%i = 0; %i < $n_pc[%cluster_to_watch]; %i ++)
    {
        %team = $data[$clusters[%cluster_to_watch,%i],3];
        %player_name = $data[$clusters[%cluster_to_watch,%i],4];
        %line[%team+1] = %line[%team+1] @ " " @ %player_name;
    }
    
    return %line[1] @ "\n" @ %line[2] @ "\n" @ %line[3] @ "\n";
}



function active_player( %playerID )
{
    for (%i = 0; %i < $n_players; %i ++)
    {
        if ($playerIDs[%i] == %playerID)
            return 1;
    }
    
    return 0;
}




////////////////////////////////////////////////////////////////////////////
// constuct watchables array
////////////////////////////////////////////////////////////////////////////


$n_players_to_watch = 0;
$playerIDs_to_watch = "nothing";

function construct_watchables_array()
{
    $n_players_to_watch = 0;
    
    for (%i = 0; %i < $n_players; %i ++)
    {
        if (( $playerIDs[%i] !$= "flag1" ) && ( $playerIDs[%i] !$= "flag2" ))
        {
            $playerIDs_to_watch[$n_players_to_watch] = $playerIDs[%i];
            $n_players_to_watch ++;
        }
    }
}



///////////////////////////////////////////////////////////////////////////
// managing the observers array
///////////////////////////////////////////////////////////////////////////

$observers_count = 0;
$observers[0] = "none";

function serverCmdsnap_version( %client )
{
       commandToClient(%client, 'snap_v', $version);
}



function update_observers() // remove clients who have left the game from the Observers list
{
    %new_observer_count = 0;
    for (%i = 0; %i < $observers_count; %i ++)
    {
        if (isObject($observers[%i]))
        {
            %new_observers[%new_observer_count] = $observers[%i];
            %new_observer_count ++;
        }
    }
    

    for (%i = 0; %i < %new_observer_count; %i ++)
    {
        $observers[%i] = %new_observers[%i];
    }
    $observers_count = %new_observer_count;
}


function serverCmdsnap_command( %client, %snap_command, %snap_mode )
{
    $me = %client;
        
    if (%snap_command $= "stop") // client doesn't want to watch the snapcam feed anymore
    {
        // remove client from observer list
        for (%i = 0;  %i < $observers_count && $observers[%i] != %client; %i ++)
        {
        }

        if (%i == $observers_count)   // the client wasn't in the observer list
        {
            return;
        }

        for (%moo = "moo"; %i < $observers_count - 1; %i ++)
        {
            $observers[%i] = $observers[%i+1];
        }

        $observers_count --;

        // set back to a free flying camera
        set_free(%client);
    }
    else if (%snap_command $= "start") // start client watching snapcam feed
    {
        %already = 0;

        for (%k = 0; %k < $observers_count; %k ++)
        {
            if ($observers[%k] $= %client)
            {
                %already = 1;       // client is already an observer
                %observer_number = %k;
            }
        }

        if (!%already)
        {
            $observers[$observers_count] = %client;
            %observer_number = $observers_count;
            $observers_count ++;
            //triangles(%client);
        }

        if (%snap_mode == -10) // watch the spector feed
        {
            $observer_target[%observer_number] = -10;
            // don't wait until the next scheduled run of snapcam, set orbit now
            deal_with(%client, $observer_target[%observer_number], 1);
        }
        else  // watch a player
        {
            $observer_target[%observer_number] = $playerIDs_to_watch[%snap_mode % $n_players_to_watch];
            // don't wait until the next scheduled run of snapcam, set orbit now
            %target = $observer_target[%observer_number];
            %transform = %target.getTransform();
            snap_set_orbit( %client.camera, %target, %transform, 0.5, 60, 4.5 );
        }
    }
}

function set_free(%client)
{
    %client.camera.mode = "observerFly";
    %client.setControlObject(%client.player);
    %client.camera.setFlyMode();


    clearBottomPrint(%client);
}

function blah_blah(%client)
{
   commandToClient(%client, 'setHudMode', 'Standard');
     Game.assignClientTeam(%client);

     %armor = $DefaultPlayerArmor @ "Male" @ %client.race @ Armor;
     %client.armor = $DefaultPlayerArmor;

     %player = new Player() {
       //dataBlock = $DefaultPlayerArmor;
       dataBlock = %armor;
     };


   %player.setTransform( "-318 -160 135 0.22 -0.09 0.9 0.78" );
   MissionCleanup.add(%player);

   // setup some info
   %player.setOwnerClient(%client);
   %player.team = %client.team;
   %client.outOfBounds = false;
   %player.setEnergyLevel(60);
   %client.player = %player;

   // updates client's target info for this player
   %player.setTarget(%client.target);
   setTargetDataBlock(%client.target, %player.getDatablock());
   setTargetSensorData(%client.target, PlayerSensor);
   setTargetSensorGroup(%client.target, %client.team);
   %client.setSensorGroup(%client.team);

   //make sure the player has been added to the team rank array...
   Game.populateTeamRankArray(%client);

   Game.playerSpawned(%client.player);

    %client.camera.mode = "observerFly";
    //%client.setControlObject(%client.player);
    %client.camera.setFlyMode();
    
    
    clearBottomPrint(%client);
}


////////////////////////////////////////////////////////////////////////////////
//  Set orbit functions
////////////////////////////////////////////////////////////////////////////////

$snap_refresh_rate = 20;
$snap_time_interval = 1000 / $snap_refresh_rate;

function snap_follow(%observer, %targetObj, %param1, %param2, %param3)
{
    commandToClient('set_vel', 0);
    %client = %observer.getControllingClient();

    %client.observeFlyClient = -1;
    cancel(%client.obsHudSchedule);

    %transform = %targetObj.getTransform();

    %new_height = %param2;
    %step = (%new_height - $last_height[%client]) / $snap_refresh_rate;
    %current_height = $last_height[%client];
    %next_time = $snap_time_interval;
    for(%i = 0; %i < $snap_refresh_rate; %i ++)
    {
        %current_height += %step;
        schedule(%next_time, 0, snap_set_orbit, %observer, %targetObj, %transform, %param1, %current_height, %param3);
        %next_time += $snap_time_interval;
    }

    //bottomPrint(%client, "\nYou are now observing: " @ getTaggedString(%targetObj.name), 0, 3);

    $last_target[%client] = %targetObj;
    $last_height[%client] = %param2 ;

    %observer.mode = "observerFollow";
    %client.setControlObject(%client.camera);
}


function snap_nothing()
{
}


function snap_set_orbit( %observer, %targetObj, %transform, %param1, %param2, %param3 )
{
    %observer.setOrbitMode(%targetObj, %transform, %param1, %param2, %param3);
}

////////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////
// debug helper functions
///////////////////////////////////////////////////////////////////////////

function print_clusters()
{
    for (%i = 0; %i < $n_clusters; %i ++)
    {
        echo("cluster " @ %i @ ":");
        for (%j = 0; %j < $n_pc[%i]; %j ++)
        {
            echo($clusters[%i,%j]);
        }
        echo("--------------------");
    }
}


function print_data()
{
    for (%i = 0; %i < $n_players; %i ++)
    {
        echo($playerIDs[%i]);
        for (%j = 0; %j <= 5; %j ++)
        {
            echo($data[$playerIDs[%i],%j]);
        }
        echo("----------");
    }
}


function print_playerIDs()
{
    for (%i = 0; %i < $n_players; %i ++)
    {
        echo($playerIDs[%i]);
    }
}

function print_playerIDs_to_watch()
{
    for (%i = 0; %i < $n_players_to_watch; %i ++)
    {
        echo($playerIDs_to_watch[%i]);
    }
}



////////////////////////

function triangles_old(%client)   // might as well try
{
   %team = 1;
   %client.setSensorGroup(%team);
   setTargetSensorGroup(%client.camera.getTraget(), %team);


   $dCam = new Turret()
   {
      dataBlock = "TurretDeployedCamera";
      team = %team;
      needsNoPower = true;
      owner = $player_to_watch.getControllingClient();
      ownerHandle = $player_to_watch.getControllingClient().handle;
      position = %client.camera.position;
      rotation = %client.camera.rotation;
   };
   //addToDeployGroup($dCam);

   if($dCam.getTarget() != -1)
      setTargetSensorGroup($dCam.getTarget(), %team);

   //$dCam.deploy();

   $dcam.setTransform(%client.camera.getTransform());



   //%client.setControlObject($dCam);

}
