// Exec playlist
exec("scripts/autoexec/playlist.cs");

// Direction 1 plays music
// Direction 2 stops music
// Direction 3 moves playlist forward
// Direction 4 moves playlist backward
// Direction 5 resets playlist to beginning

// Bind MP3 Command keys
GlobalActionMap.bindCmd(keyboard, "ctrl a", "", "musicplayer.advMp3_control(1);");
GlobalActionMap.bindCmd(keyboard, "ctrl s", "", "musicplayer.advMp3_control(2);");
GlobalActionMap.bindCmd(keyboard, "ctrl d", "", "musicplayer.advMp3_control(3);");
GlobalActionMap.bindCmd(keyboard, "ctrl f", "", "musicplayer.advMp3_control(4);");
GlobalActionMap.bindCmd(keyboard, "ctrl z", "", "musicplayer.advMp3_control(5);");
GlobalActionMap.bindCmd(keyboard, "ctrl x", "", "musicplayer.showPlaylist();");
GlobalActionMap.bindCmd(keyboard, "ctrl c", "", "musicplayer.showCurrent();");

// Create the index to order the playlist
$current_track = 0;

// Method allows user to flip thru the playlist using stereo-like controls
function MP3Audio::advMp3_control(%this, %direction) {
	
	// Direction 3 moves playlist forward
	if (%direction == 3) {
			if($current_track + 1 <= $max_track) { 
				$current_track++;
			} else {
			%play_toggle = 1;
			}

	// Direction 4 moves playlist backward
	} else if (%direction == 4) {
			
			if($current_track - 1 >= 0) { 
				$current_track--;
			} else {
			%play_toggle = 1;
			}

	// Direction 2 stops music
	} else if (%direction == 2) {

	MusicPlayer.stop();
	
	%play_toggle = 1;

	// Direction 5 resets playlist to beginning
	} else if (%direction == 5) {

	$current_track = 0;

	// Direction 1 plays the currently selected track
	} else if (%direction == 1) {

	} else {

	%play_toggle = 1;

	}

// Play toggle is set to check whether or not the file should be played. 1 means don't play, 0 means play
if(%play_toggle != 1) {

   if($pref::Audio::musicEnabled) {
      
      alxPlayMusic("base\\music\\" @ $track[$current_track] @ ".mp3");

	} else {
	
	}

} else {

}

}

// Method allows for direct access to a specific file in the playlist
function MP3Audio::advMp3_direct(%this, %file) {

   $current_track = %file;

   if($pref::Audio::musicEnabled) {
      
      alxPlayMusic("base\\music\\" @ $track[%file] @ ".mp3");

	} else {
	
	}

}

function MP3Audio::showPlaylist() {

%tr = $max_track;
%list = "";
%min = -1;

while(%tr > %min) {

%list = %list @ "<just:left>#" @ %tr @ " " @ $track[%tr] @ "\n";

%tr--;

}

MessageBoxOK("MP3 Playlist", %list);

}

function MP3Audio::showCurrent() {

MessageBoxOK("Currently Playing", $track[$current_track]);

}