<?php

########################################################################
# PHP-Nuke Module: TWL XML History v1.0                                #
#                                                                      #
# Copyright (c) 2002 by {sKg} Screaming Kings (werm@screamingkings.com)#
#                    http://www.screamingkings.com                     #
#                                                                      #
########################################################################
# This program is freeware. You can redistribute it and/or modify it.  #
# All I ask is that you do not take credit for my work. Others have    #
# been kind enough to credit me, {sKg}werm_xrt, on their site when     #
# they have used my code.                                              #
########################################################################

if (!eregi("modules.php", $PHP_SELF)) {
   die ("You can't access this file directly...");
}

$index = 1;

require_once("mainfile.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);

include("header.php");

$file = "http://www.teamwarfare.net/xml/teamhistory.asp?team=Screaming+Kings";

class MatchInfo {
    var $status;
    var $opponent;
    var $opponenthtmllink;
    var $opponentxmllink;
    var $date;
    var $result;
    var $maps;
    var $defenderscores;
    var $attackerscores;

    function MatchInfo() {
        $maps = array();
        $defenderscores = array();
        $attackerscores = array();
    }
}

class LadderInfo {
    var $ladder;
    var $ladderhttplink;
    var $ladderxmllink;
    var $wins = 0;
    var $losses = 0;
    var $forfeits = 0;
    var $matchinfo;

    function LadderInfo() {
        $matchinfo = array();
    }
}

class Team {
    var $name;
    var $url;
    var $email;
    var $founder;
    var $description;
    var $ircserver;
    var $channel;
    var $status;
    var $ladderinfo;

    function Team() {
        $ladderinfo = array();
    }
}

$team = new Team();

function xml_get_children($vals, &$i) {
    $children = array();
    if (isset($vals[$i]['value'])) $children[] = $vals[$i]['value'];

    while (++$i < count($vals)) {
        switch ($vals[$i]['type']) {
        case 'cdata':
            $children[] = $vals[$i]['value'];
            break;

        case 'complete':
            $children[] = array(
                'tag'        => $vals[$i]['tag'],
                'attributes' => isset($vals[$i]['attributes'])? $vals[$i]['attributes'] : null,
                'value'      => $vals[$i]['value'],
            );
            break;

        case 'open':
            $children[] = array(
                'tag'        => $vals[$i]['tag'],
                'attributes' => isset($vals[$i]['attributes'])? $vals[$i]['attributes'] : null,
                'children'   => xml_get_children($vals, $i),
            );
            break;

        case 'close':
            return $children;
        }
    }
}

function xml_get_tree($file) {
    $data = join('', file($file));

    $parser = xml_parser_create();
    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
    xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
    xml_parse_into_struct($parser, $data, $vals, $index);
    xml_parser_free($parser);

   return array(
       'tag'        => $vals[0]['tag'],
       'attributes' => isset($vals[0]['attributes'])? $vals[0]['attributes'] : null,
       'children'   => xml_get_children($vals, $i = 0),
   );
}

$tree = xml_get_tree($file);

foreach ($tree['children'] as $children) {
    if ($children['tag'] == "teaminformation") {
        $team->name = $tree['children'][0]['children'][0]['value'];
        $team->url = $tree['children'][0]['children'][1]['value'];
        $team->email = $tree['children'][0]['children'][2]['value'];
        $team->founder = $tree['children'][0]['children'][5]['value'];
        $team->description = $tree['children'][0]['children'][6]['value'];
        $team->ircserver = $tree['children'][0]['children'][3]['value'];
        $team->channel = $tree['children'][0]['children'][3]['attributes']['channel'];
        $team->status = $tree['children'][0]['children'][4]['value'];
    } else if ($children['tag'] == "ladderinformation") {
        if (array_key_exists("children", $children)) {
            foreach ($children['children'] as $ladder) {
                $lil = count($team->ladderinfo);
                $team->ladderinfo[$lil] = new LadderInfo();
                $team->ladderinfo[$lil]->ladder = $ladder['attributes']['name'];
                $team->ladderinfo[$lil]->ladderhttplink = $ladder['children'][0]['children'][0]['value'];
                $team->ladderinfo[$lil]->ladderxmllink = $ladder['children'][0]['children'][1]['value'];

                foreach ($ladder['children'] as $match) {
                    if ($match['tag'] == "match") {
                        $mil = count($team->ladderinfo[$lil]->matchinfo);
                        $team->ladderinfo[$lil]->matchinfo[$mil] = new MatchInfo();
                        $team->ladderinfo[$lil]->matchinfo[$mil]->status = $match['attributes']['status'];
                        $team->ladderinfo[$lil]->matchinfo[$mil]->opponent = $match['children'][0]['value'];
                        $team->ladderinfo[$lil]->matchinfo[$mil]->opponenthtmllink = $match['children'][1]['children'][0]['value'];
                        $team->ladderinfo[$lil]->matchinfo[$mil]->opponentxmllink = $match['children'][1]['children'][1]['value'];
                        $team->ladderinfo[$lil]->matchinfo[$mil]->date = $match['children'][2]['value'];
                        $team->ladderinfo[$lil]->matchinfo[$mil]->result = $match['children'][3]['value'];
                        switch ($match['children'][3]['value']) {
                            case "win": $team->ladderinfo[$lil]->wins++; break;
                            case "forfeit win": $team->ladderinfo[$lil]->wins++; break;
                            case "loss": $team->ladderinfo[$lil]->losses++; break;
                            case "forfeit loss": $team->ladderinfo[$lil]->forfeits++; break;
                        }
                        if (array_key_exists("children", $match['children'][4])) {
                            $team->ladderinfo[$lil]->matchinfo[$mil]->maps[0] = $match['children'][4]['children'][0]['children'][0]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->defenderscores[0] = $match['children'][4]['children'][0]['children'][2]['children'][0]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->attackerscores[0] = $match['children'][4]['children'][0]['children'][2]['children'][1]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->maps[1] = $match['children'][4]['children'][1]['children'][0]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->defenderscores[1] = $match['children'][4]['children'][1]['children'][2]['children'][0]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->attackerscores[1] = $match['children'][4]['children'][1]['children'][2]['children'][1]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->maps[2] = $match['children'][4]['children'][2]['children'][0]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->defenderscores[2] = $match['children'][4]['children'][2]['children'][2]['children'][0]['value'];
                            $team->ladderinfo[$lil]->matchinfo[$mil]->attackerscores[2] = $match['children'][4]['children'][2]['children'][2]['children'][1]['value'];
                        }
                    }
                }
            }
        }
    }
}

$html = "
<table  bgcolor=\"".$bgcolor1."\" width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">
    <tr>
        <td align=\"left\" colspan=\"5\">
            <a href=\"".$team->url."\">".$team->name."</a> <i>(".$team->status.")</i>
        </td>
    </tr>";
    for ($i = 0; $i < count($team->ladderinfo); $i++) {
        $html .= "
    <tr>
        <td align=\"left\" colspan=\"5\">
            <a href=\"".$team->ladderinfo[$i]->ladderhttplink."\">".$team->ladderinfo[$i]->ladder."</a>&nbsp;&nbsp;<b>Record:</b> ".$team->ladderinfo[$i]->wins."W ".$team->ladderinfo[$i]->losses."L ".$team->ladderinfo[$i]->forfeits."F
        </td>
    </tr>";
        for ($j = 0; $j < count($team->ladderinfo[$i]->matchinfo); $j++) {
            $html .= "
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>";
            if (($j % 2) == 0) $backgroundcolor = $bgcolor1;
            else $backgroundcolor = $bgcolor2;
            $html .= "
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\"><a href=\"".$team->ladderinfo[$i]->matchinfo[$j]->opponenthtmllink."\">".$team->ladderinfo[$i]->matchinfo[$j]->opponent."</a></td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\">".$team->ladderinfo[$i]->matchinfo[$j]->result."</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\">".$team->ladderinfo[$i]->matchinfo[$j]->date."</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\">".$team->ladderinfo[$i]->matchinfo[$j]->status."</td>";
            if (count($team->ladderinfo[$i]->matchinfo[$j]->maps) > 0) {
                if ($team->ladderinfo[$i]->matchinfo[$j]->status == "defending") {
                    $html .= "
    </tr>
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;".$team->ladderinfo[$i]->matchinfo[$j]->maps[0].": ".$team->ladderinfo[$i]->matchinfo[$j]->defenderscores[0]."-".$team->ladderinfo[$i]->matchinfo[$j]->attackerscores[0]."</td>
    </tr>
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;".$team->ladderinfo[$i]->matchinfo[$j]->maps[1].": ".$team->ladderinfo[$i]->matchinfo[$j]->defenderscores[1]."-".$team->ladderinfo[$i]->matchinfo[$j]->attackerscores[1]."</td>
    </tr>
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;".$team->ladderinfo[$i]->matchinfo[$j]->maps[2].": ".$team->ladderinfo[$i]->matchinfo[$j]->defenderscores[2]."-".$team->ladderinfo[$i]->matchinfo[$j]->attackerscores[2]."</td>
    </tr>";
                } else {
                    $html .= "
    </tr>
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;".$team->ladderinfo[$i]->matchinfo[$j]->maps[0].": ".$team->ladderinfo[$i]->matchinfo[$j]->attackerscores[0]."-".$team->ladderinfo[$i]->matchinfo[$j]->defenderscores[0]."</td>
    </tr>
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;".$team->ladderinfo[$i]->matchinfo[$j]->maps[1].": ".$team->ladderinfo[$i]->matchinfo[$j]->attackerscores[1]."-".$team->ladderinfo[$i]->matchinfo[$j]->defenderscores[1]."</td>
    </tr>
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;".$team->ladderinfo[$i]->matchinfo[$j]->maps[2].": ".$team->ladderinfo[$i]->matchinfo[$j]->attackerscores[2]."-".$team->ladderinfo[$i]->matchinfo[$j]->defenderscores[2]."</td>
    </tr>";
                }
            } else {
                $html .= "
    <tr>
        <td align=\"left\">&nbsp;&nbsp;</td>
        <td bgcolor=\"".$backgroundcolor."\" align=\"left\" colspan=\"4\">&nbsp;&nbsp;Admin Forfeited Match</td>
    </tr>";
            }
        }
        $html .= "
    <tr>
        <td align=\"left\" colspan=\"5\">&nbsp;</td>
    </tr>";
    }

$html .= "
</table>";

echo $html;

include("footer.php");

?>
