<?php

########################################################################
# PHP-Nuke Block: TWL XML Feed v1.4                                    #
#                                                                      #
# Copyright (c) 2002 by {sKg} Screaming Kings (werm@screamingkings.com)#
#                    http://www.screamingkings.com                     #
#                                                                      #
########################################################################
# This program is freeware. You can redistribute it and/or modify it.  #
# All I ask is that you do not take credit for my work. Others have    #
# been kind enough to credit me, {sKg}werm_xrt, on their site when     #
# they have used my code.                                              #
########################################################################

if (eregi("block-TWL_XML_Feed.php", $PHP_SELF)) {
    Header("Location: index.php");
    die();
}

$file = "http://www.teamwarfare.net/xml/viewteam_v2.asp?team=Screaming+Kings";

class LadderInfo {
    var $ladder;
    var $ladderhtmllink;
    var $ladderxmllink;
    var $rank;
    var $wins;
    var $losses;
    var $forfeits;
    var $status;
    var $opponent;
    var $opponenthtmllink;
    var $opponentxmllink;
    var $date;
    var $maps;
    var $sides;

    function LadderInfo() {
        $maps = array();
        $sides = array();
    }
}

class LeagueInfo {
    var $league;
    var $leaguehtmllink;
    var $leaguexmllink;
    var $conference;
    var $division;
    var $status;
    var $opponent;
    var $opponenthtmllink;
    var $opponentxmllink;
    var $date;
    var $maps;

    function LeagueInfo() {
        $maps = array();
    }
}

class Team {
    var $name;
    var $url;
    var $email;
    var $founder;
    var $description;
    var $ircserver;
    var $channel;
    var $status;
    var $ladderinfo;
    var $leagueinfo;

    function Team() {
        $this->ladderinfo = array();
        $this->leagueinfo = array();
    }
}

$team = new Team();

function formatDate($datetime) {
    $splitDate = split(" ", $datetime);
    array_splice($splitDate, 3, 0, date("Y"));

    if (count($splitDate) > 0) {
        $datetime = $splitdate[0];

        for ($j = 0; $j < count($splitDate); $j++) {
            $datetime = $datetime." ".$splitDate[$j];
        }

        $timestamp = (int)strtotime($datetime);
        putenv("TZ=EST5EDT");
        $datetime = strftime("%D %r %Z", $timestamp);
    }

    return $datetime;
}

function formatDate1($datetime) {
    $timestamp = (int)strtotime($datetime);
    putenv("TZ=EST5EDT");
    $datetime = strftime("%A, %B %d", $timestamp);

    return $datetime;
}

function xml_get_children($vals, &$i) {
    $children = array();
    if (isset($vals[$i]['value'])) $children[] = $vals[$i]['value'];

    while (++$i < count($vals)) {
        switch ($vals[$i]['type']) {
        case 'cdata':
            $children[] = $vals[$i]['value'];
            break;

        case 'complete':
            $children[] = array(
                'tag'        => $vals[$i]['tag'],
                'attributes' => isset($vals[$i]['attributes'])? $vals[$i]['attributes'] : null,
                'value'      => $vals[$i]['value'],
            );
            break;

        case 'open':
            $children[] = array(
                'tag'        => $vals[$i]['tag'],
                'attributes' => isset($vals[$i]['attributes'])? $vals[$i]['attributes'] : null,
                'children'   => xml_get_children($vals, $i),
            );
            break;

        case 'close':
            return $children;
        }
    }
}

function xml_get_tree($file) {
    $data = join('', file($file));

    $parser = xml_parser_create();
    xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
    xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
    xml_parse_into_struct($parser, $data, $vals, $index);
    xml_parser_free($parser);

    return array(
        'tag'        => $vals[0]['tag'],
        'attributes' => isset($vals[0]['attributes'])? $vals[0]['attributes'] : null,
        'children'   => xml_get_children($vals, $i = 0),
    );
}

$tree = xml_get_tree($file);

foreach ($tree['children'] as $children) {
    if ($children['tag'] == "teaminformation") {
        $team->name = $tree['children'][0]['children'][0]['value'];
        $team->url = $tree['children'][0]['children'][1]['value'];
        $team->email = $tree['children'][0]['children'][2]['value'];
        $team->founder = $tree['children'][0]['children'][5]['value'];
        $team->description = $tree['children'][0]['children'][6]['value'];
        $team->ircserver = $tree['children'][0]['children'][3]['value'];
        $team->channel = $tree['children'][0]['children'][3]['attributes']['channel'];
        $team->status = $tree['children'][0]['children'][4]['value'];
    }  else if ($children['tag'] == "competitioninformation") {
        if (array_key_exists("children", $children)) {
            foreach ($children['children'] as $comp) {
                if ($comp['tag'] == "ladder") {
                    $lil = count($team->ladderinfo);
                    $team->ladderinfo[$lil] = new LadderInfo();
                    $team->ladderinfo[$lil]->ladder = $comp['attributes']['name'];
                    $team->ladderinfo[$lil]->ladderhttplink = $comp['children'][0]['children'][0]['value'];
                    $team->ladderinfo[$lil]->ladderxmllink = $comp['children'][0]['children'][1]['value'];
                    $team->ladderinfo[$lil]->rank = $comp['children'][1]['value'];
                    $team->ladderinfo[$lil]->wins = $comp['children'][2]['value'];
                    $team->ladderinfo[$lil]->losses = $comp['children'][3]['value'];
                    $team->ladderinfo[$lil]->forfeits = $comp['children'][4]['value'];
                    $team->ladderinfo[$lil]->status = $comp['children'][5]['attributes']['status'];

                    if (array_key_exists("children", $comp['children'][5])) {
                        $team->ladderinfo[$lil]->opponent = $comp['children'][5]['children'][0]['value'];
                        $team->ladderinfo[$lil]->opponenthtmllink = $comp['children'][5]['children'][1]['children'][0]['value'];
                        $team->ladderinfo[$lil]->opponentxmllink = $comp['children'][5]['children'][1]['children'][1]['value'];
                        $team->ladderinfo[$lil]->date = $comp['children'][5]['children'][2]['value'];
                        $team->ladderinfo[$lil]->maps[0] = $comp['children'][5]['children'][3]['attributes']['name'];
                        if (array_key_exists("children", $comp['children'][5]['children'][3])) $team->ladderinfo[$lil]->sides[0] = $comp['children'][5]['children'][3]['children'][0]['children'][0]['value'];
                        $team->ladderinfo[$lil]->maps[1] = $comp['children'][5]['children'][4]['attributes']['name'];
                        if (array_key_exists("children", $comp['children'][5]['children'][4])) $team->ladderinfo[$lil]->sides[1] = $comp['children'][5]['children'][4]['children'][0]['children'][0]['value'];
                        $team->ladderinfo[$lil]->maps[2] = $comp['children'][5]['children'][5]['attributes']['name'];
                        if (array_key_exists("children", $comp['children'][5]['children'][5])) $team->ladderinfo[$lil]->sides[2] = $comp['children'][5]['children'][5]['children'][0]['children'][0]['value'];
                    }
                } else if ($comp['tag'] == "league") {
                    $lil = count($team->leagueinfo);
                    $team->leagueinfo[$lil] = new LeagueInfo();
                    $team->leagueinfo[$lil]->league = $comp['attributes']['name'];
                    $team->leagueinfo[$lil]->leaguehttplink = $comp['children'][0]['children'][0]['value'];
                    $team->leagueinfo[$lil]->leaguexmllink = $comp['children'][0]['children'][1]['value'];
                    $team->leagueinfo[$lil]->conference = $comp['children'][1]['value'];
                    $team->leagueinfo[$lil]->division = $comp['children'][2]['value'];
                    $team->leagueinfo[$lil]->status = $comp['children'][3]['children'][0]['attributes']['status'];

                    if (array_key_exists("children", $comp['children'][3])) {
                        $team->leagueinfo[$lil]->opponent = $comp['children'][3]['children'][0]['children'][0]['value'];
                        $team->leagueinfo[$lil]->opponenthtmllink = $comp['children'][3]['children'][0]['children'][1]['children'][0]['value'];
                        $team->leagueinfo[$lil]->opponentxmllink = $comp['children'][3]['children'][0]['children'][1]['children'][1]['value'];
                        $team->leagueinfo[$lil]->date = formatDate1($comp['children'][3]['children'][0]['children'][5]['value'])." 10:00 PM EST";
                        $team->leagueinfo[$lil]->maps[0] = $comp['children'][3]['children'][0]['children'][2]['attributes']['name'];
                        $team->leagueinfo[$lil]->maps[1] = $comp['children'][3]['children'][0]['children'][3]['attributes']['name'];
                        $team->leagueinfo[$lil]->maps[2] = $comp['children'][3]['children'][0]['children'][4]['attributes']['name'];
                    }
                }
            }
        }
    }
}

$html = "
<table  bgcolor=\"".$bgcolor1."\" width=\"100%\" cellspacing=\"0\" cellpadding=\"1\">
    <tr>
        <td align=\"left\" colspan=\"3\">
            <a href=\"".$team->url."\">".$team->name."</a>&nbsp;<i>(".$team->status.")</i>&nbsp;&nbsp;".$team->channel." on ".$team->ircserver."
        </td>
    </tr>";
for ($i = 0; $i < count($team->ladderinfo); $i++) {
    $html .= "
    <tr>
        <td align=\"left\" colspan=\"3\"><a href=\"".$team->ladderinfo[$i]->ladderhtmllink."\">".$team->ladderinfo[$i]->ladder."</a></td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
            <b>Current Rung:</b> ".$team->ladderinfo[$i]->rank."  <b>Record:</b> ".$team->ladderinfo[$i]->wins."W ".$team->ladderinfo[$i]->losses."L ".$team->ladderinfo[$i]->forfeits."F
        </td>
    </tr>";

    if (isset($team->ladderinfo[$i]->opponent)) {
        $html .= "
    <tr>
        <td align=\"left\" colspan=\"3\">
            <b>Current Status:</b> ".$team->ladderinfo[$i]->status." <a href=\"".$team->ladderinfo[$i]->opponenthtmllink."\">".$team->ladderinfo[$i]->opponent."</a>
        </td>
    </tr>
    <tr>
        <td align=\"left\">
            <b>Map</b>
        </td>
        <td align=\"left\">
            <b>Side</b>
        </td>
    </tr>
    <tr>
        <td align=\"left\">
           ".$team->ladderinfo[$i]->maps[0]."
        </td>
        <td align=\"left\">
           ".$team->ladderinfo[$i]->sides[0]."
        </td>
    </tr>
    <tr>
        <td align=\"left\">
           ".$team->ladderinfo[$i]->maps[1]."
        </td>
        <td align=\"left\">
           ".$team->ladderinfo[$i]->sides[1]."
        </td>
    </tr>
    <tr>
        <td align=\"left\">
           ".$team->ladderinfo[$i]->maps[2]."
        </td>
        <td align=\"left\">
           ".$team->ladderinfo[$i]->sides[2]."
        </td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
           <b>Match Date:</b> ".$team->ladderinfo[$i]->date."
        </td>
    </tr>";
    } else {
        $html .= "
    <tr>
        <td align=\"center\" colspan=\"3\">
            No Match Scheduled
        </td>
    </tr>";
    }
    $html .= "
    <tr>
        <td align=\"left\" colspan=\"3\">&nbsp;</td>
    </tr>";
}

for ($i = 0; $i < count($team->leagueinfo); $i++) {
    $html .= "
    <tr>
        <td align=\"left\" colspan=\"3\"><a href=\"".$team->leagueinfo[$i]->leaguehtmllink."\">".$team->leagueinfo[$i]->league."</a></td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
            <b>Conference:</b> ".$team->leagueinfo[$i]->conference."  <b>Division:</b> ".$team->leagueinfo[$i]->division."
        </td>
    </tr>";

    if (isset($team->leagueinfo[$i]->opponent)) {
        $html .= "
    <tr>
        <td align=\"left\" colspan=\"3\">
            <b>Current Status:</b> ".$team->leagueinfo[$i]->status." against <a href=\"".$team->leagueinfo[$i]->opponenthtmllink."\">".$team->leagueinfo[$i]->opponent."</a>
        </td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
            <b>Map</b>
        </td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
           ".$team->leagueinfo[$i]->maps[0]."
        </td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
           ".$team->leagueinfo[$i]->maps[1]."
        </td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
           ".$team->leagueinfo[$i]->maps[2]."
        </td>
    </tr>
    <tr>
        <td align=\"left\" colspan=\"3\">
           <b>Match Date:</b> ".$team->leagueinfo[$i]->date."
        </td>
    </tr>";
    } else {
        $html .= "
    <tr>
        <td align=\"center\" colspan=\"3\">
            No Match Scheduled
        </td>
    </tr>";
    }
    $html .= "
    <tr>
        <td align=\"left\" colspan=\"3\">&nbsp;</td>
    </tr>";
}

$html .= "</table>";

$content = $html;

?>