// Use of this file
// To add a new map follow this rules:
// 1. Find the file name, ending in .mis (ie BeggarsRun.mis)
// 2. Add a line with this syntact: addRotationMap(filename, gametype, %ffa, %cycle);
//
// %ffa = changing this to 0, will remove the map from the FFA mode
// %cycle = changing this to 0 will remove the map from the FFA cycle, but not from the rotation (optional)
//				if %ffa is 0, %cycle is useless
//
// Note: filename must be written without .mis
//
// Example: addRotationMap(BeggarsRun, CTF, 1);
//				addRotationMap(BeggarsRun, CTF, 1, 1);
//				Beggar's Run will be in the FFA mapRotation. It's in the cycle and can be voted
//
// Example: addRotationMap(BeggarsRun, CTF, 1, 0);
//				Beggar's Run will be in the FFA mapRotation. It's not in the cycle, but can be voted
//
// Example: addRotationMap(BeggarsRun, CTF, 0);
//				Beggar's Run won't be in the FFA mapRotation. It's not in the cycle and can't be voted
//
// Info:
// If you don't want a map to be played neither in Tournement Mode, write // at the beginning of the line (or delete the line)
// If you don't want a gametype to be played, just don't add any map of that gametype
// Some Mods (ie LakRabbit) use own maps. To use this mods, you must add the maps in this file
// %cycle variable is optional and if not included the map will always be in the cycle (if %ffa is 1).


// Capture The Flag
addRotationMap(AcidRain, CTF, 1);
addRotationMap(Archipelago, CTF, 1);
addRotationMap(BeggarsRun, CTF, 1);
addRotationMap(Blastside_nef, CTF, 1);
addRotationMap(Broadside_nef, CTF, 1);
addRotationMap(Confusco, CTF, 1);
addRotationMap(Damnation, CTF, 1);
addRotationMap(DangerousCrossing_nef, CTF, 1);
addRotationMap(DeathBirdsFly, CTF, 1);
addRotationMap(DesertofDeath_nef, CTF, 1);
addRotationMap(Desiccator, CTF, 1);
addRotationMap(DustToDust, CTF, 1);
addRotationMap(Firestorm, CTF, 1);
addRotationMap(Gorgon, CTF, 1);
addRotationMap(Hillside, CTF, 1);
addRotationMap(IceRidge_nef, CTF, 1);
addRotationMap(Katabatic, CTF, 1);
addRotationMap(Lakefront, CTF, 1);
addRotationMap(Magmatic, CTF, 1);
addRotationMap(Minotaur, CTF, 1);
addRotationMap(Quagmire, CTF, 1);
addRotationMap(Raindance_nef, CTF, 1);
addRotationMap(Ramparts, CTF, 1);
addRotationMap(Recalescence, CTF, 1);
addRotationMap(Reversion, CTF, 1);
addRotationMap(RiverDance, CTF, 1);
addRotationMap(Rollercoaster_nef, CTF, 1);
addRotationMap(Sanctuary, CTF, 1);
addRotationMap(Sandstorm, CTF, 1);
addRotationMap(Scarabrae_nef, CTF, 1);
addRotationMap(ShockRidge, CTF, 1);
addRotationMap(Slapdash, CTF, 1);
addRotationMap(Snowblind_nef, CTF, 1);
addRotationMap(Starfallen, CTF, 1);
addRotationMap(Stonehenge_nef, CTF, 1);
addRotationMap(SubZero, CTF, 1);
addRotationMap(Surreal, CTF, 1);
addRotationMap(ThinIce, CTF, 1);
addRotationMap(Titan, CTF, 1);
addRotationMap(TombStone, CTF, 1);
addRotationMap(WhiteDwarf, CTF, 1);

// Capture The Flag
addRotationMap(AcidRain, PracticeCTF, 1);
addRotationMap(Archipelago, PracticeCTF, 1);
addRotationMap(BeggarsRun, PracticeCTF, 1);
addRotationMap(Blastside_nef, PracticeCTF, 1);
addRotationMap(Broadside_nef, PracticeCTF, 1);
addRotationMap(Confusco, PracticeCTF, 1);
addRotationMap(Damnation, PracticeCTF, 1);
addRotationMap(DangerousCrossing_nef, PracticeCTF, 1);
addRotationMap(DeathBirdsFly, PracticeCTF, 1);
addRotationMap(DesertofDeath_nef, PracticeCTF, 1);
addRotationMap(Desiccator, PracticeCTF, 1);
addRotationMap(DustToDust, PracticeCTF, 1);
addRotationMap(Firestorm, PracticeCTF, 1);
addRotationMap(Gorgon, PracticeCTF, 1);
addRotationMap(Hillside, PracticeCTF, 1);
addRotationMap(IceRidge_nef, PracticeCTF, 1);
addRotationMap(Katabatic, PracticeCTF, 1);
addRotationMap(Lakefront, PracticeCTF, 1);
addRotationMap(Magmatic, PracticeCTF, 1);
addRotationMap(Minotaur, PracticeCTF, 1);
addRotationMap(Quagmire, PracticeCTF, 1);
addRotationMap(Raindance_nef, PracticeCTF, 1);
addRotationMap(Ramparts, PracticeCTF, 1);
addRotationMap(Recalescence, PracticeCTF, 1);
addRotationMap(Reversion, PracticeCTF, 1);
addRotationMap(RiverDance, PracticeCTF, 1);
addRotationMap(Rollercoaster_nef, PracticeCTF, 1);
addRotationMap(Sanctuary, PracticeCTF, 1);
addRotationMap(Sandstorm, PracticeCTF, 1);
addRotationMap(Scarabrae_nef, PracticeCTF, 1);
addRotationMap(ShockRidge, PracticeCTF, 1);
addRotationMap(Slapdash, PracticeCTF, 1);
addRotationMap(Snowblind_nef, PracticeCTF, 1);
addRotationMap(Starfallen, PracticeCTF, 1);
addRotationMap(Stonehenge_nef, PracticeCTF, 1);
addRotationMap(SubZero, PracticeCTF, 1);
addRotationMap(Surreal, PracticeCTF, 1);
addRotationMap(ThinIce, PracticeCTF, 1);
addRotationMap(Titan, PracticeCTF, 1);
addRotationMap(TombStone, PracticeCTF, 1);
addRotationMap(WhiteDwarf, PracticeCTF, 1);

// Bounty
addRotationMap(Casern_Cavite, Bounty, 1);
addRotationMap(Confusco, Bounty, 1);
addRotationMap(Escalade, Bounty, 1);
addRotationMap(Gorgon, Bounty, 1);
addRotationMap(Ramparts, Bounty, 1);
addRotationMap(Rasp, Bounty, 1);
addRotationMap(RiverDance, Bounty, 1);
addRotationMap(SunDried, Bounty, 1);
addRotationMap(Surreal, Bounty, 1);
addRotationMap(Talus, Bounty, 1);
addRotationMap(Underhill, Bounty, 1);
addRotationMap(Whiteout, Bounty, 1);

// Capture and Hold
addRotationMap(Abominable, CnH, 1);
addRotationMap(AshesToAshes, CnH, 1);
addRotationMap(Equinox, CnH, 1);
addRotationMap(Firestorm, CnH, 1);
addRotationMap(Flashpoint, CnH, 1);
addRotationMap(Insalubria, CnH, 1);
addRotationMap(JacobsLadder, CnH, 1);
addRotationMap(Lakefront, CnH, 1);
addRotationMap(Overreach, CnH, 1);
addRotationMap(Sandstorm, CnH, 1);
addRotationMap(ShockRidge, CnH, 1);
addRotationMap(Sirocco, CnH, 1);

// DeathMatch
addRotationMap(AgentsOfFortune, DM, 1);
addRotationMap(Casern_Cavite, DM, 1);
addRotationMap(Confusco, DM, 1);
addRotationMap(Equinox, DM, 1);
addRotationMap(Escalade, DM, 1);
addRotationMap(Fracas, DM, 1);
addRotationMap(Gorgon, DM, 1);
addRotationMap(Invictus, DM, 1);
addRotationMap(MyrkWood, DM, 1);
addRotationMap(Oasis, DM, 1);
addRotationMap(Pyroclasm, DM, 1);
addRotationMap(Ramparts, DM, 1);
addRotationMap(Rasp, DM, 1);
addRotationMap(SunDried, DM, 1);
addRotationMap(Surreal, DM, 1);
addRotationMap(Talus, DM, 1);
addRotationMap(Underhill, DM, 1);
addRotationMap(Whiteout, DM, 1);

// Defend and Destroy
addRotationMap(AcidRain, DnD, 1);
addRotationMap(Blastside_nef, DnD, 1);
addRotationMap(Broadside_nef, DnD, 1);
addRotationMap(Hillside, DnD, 1);
addRotationMap(Lakefront, DnD, 1);
addRotationMap(Ramparts, DnD, 1);
addRotationMap(Sandstorm, DnD, 1);
addRotationMap(Scarabrae_nef, DnD, 1);
addRotationMap(Starfallen, DnD, 1);

// Hunters
addRotationMap(AgentsOfFortune, Hunters, 1);
addRotationMap(Casern_Cavite, Hunters, 1);
addRotationMap(DustToDust, Hunters, 1);
addRotationMap(Escalade, Hunters, 1);
addRotationMap(Fracas, Hunters, 1);
addRotationMap(Gehenna, Hunters, 1);
addRotationMap(MyrkWood, Hunters, 1);
addRotationMap(Rasp, Hunters, 1);
addRotationMap(Rimehold, Hunters, 1);
addRotationMap(SunDried, Hunters, 1);
addRotationMap(Talus, Hunters, 1);
addRotationMap(Underhill, Hunters, 1);

// Rabbit
addRotationMap(Escalade, Rabbit, 1);
addRotationMap(MyrkWood, Rabbit, 1);
addRotationMap(SunDried, Rabbit, 1);

// Siege
addRotationMap(Alcatraz, Siege, 1);
addRotationMap(Caldera, Siege, 1);
addRotationMap(Gauntlet, Siege, 1);
addRotationMap(IceBound, Siege, 1);
addRotationMap(Masada, Siege, 1);
addRotationMap(Respite, Siege, 1);
addRotationMap(UltimaThule, Siege, 1);

// Team Hunters
addRotationMap(AgentsOfFortune, TeamHunters, 1);
addRotationMap(DustToDust, TeamHunters, 1);
addRotationMap(Escalade, TeamHunters, 1);
addRotationMap(Gehenna, TeamHunters, 1);
addRotationMap(Ramparts, TeamHunters, 1);
addRotationMap(Rimehold, TeamHunters, 1);

// Team Rabbit 2
addRotationMap(Crater71, TR2, 1);
addRotationMap(FrozenFury, TR2, 1);
addRotationMap(GodsRift, TR2, 1);
addRotationMap(Haven, TR2, 1);
addRotationMap(PhasmaDust, TR2, 1);
addRotationMap(SkinnyDip, TR2, 1);
addRotationMap(SolsDescent, TR2, 1);
addRotationMap(TreasureIsland, TR2, 1);
