// =========================
// | EVOLUTION PREFERENCES |
// =========================


// *********
// * STATS *
// *********

// Enable stats?
// 0 = disabled, 1 = enabled (default)
$Host::EvoStats = 1;

// Enable stats in tournament mode? (only if $Host::EvoStats is 1)
// 0 = disabled (default), 1 = enabled
$Host::EvoStatsTourney = 0;

// Show stats during debriefing?
// 0 = disabled, 1 = enabled (default)
$Host::EvoShowStats = 1;

// Weapon stats
// 0 = disabled, 1 = kills, 2 = total damage (default)
$Host::EvoStatsType = 2;

// Where do you want display the stats during the debriefing?
// 0 = before player scores (default), 1 = after player scores
$Host::EvoStatsPosition = 0;

// Show average pings of a team in scorehud
// 0 = disabled, 1 = enabled (default)
$Host::EvoAveragePings = 1;


// ******************
// * ADMIN COMMANDS *
// ******************

// Allow Admin to vote for mission change and mission time change
// 0 = disabled, 1 = enabled (default)
$Host::EvoForcedVotes = 1;

// Allow Admin to change server password while ingame? (use SADsetpassword("newpw"); or PizzaClient)
// 0 = disabled, 1 = enabled (default)
$Host::EvoAdminServerPW = 1;

// Allow Admin to change max Players while ingame? (need PizzaClient)
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminMaxPlayers = 1;

// Allow Admin to admin other Players if $Host::allowAdminPlayerVotes is 0?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAdminAdmin = 1;

// Allow Admin to ban Players?
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminBan = 0;

// Allow Admin to stop running votes?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAdminStopVotes = 1;

// Allow Admin to pass running votes?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAdminPassVote = 1;

// Allow SuperAdmin to pass running votes?
// 0 = disabled, 1 = enabled (default)
$Host::EvoSuperPassVote = 1;

// Allow Admins to view player's info (name, realname, clan, guid, ip address. Need Pizza Client)
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminWhois = 0;

// Allow SuperAdmins to view player's info? (name, realname, clan, guid, ip address. Need Pizza Client)
// 0 = disabled, 1 = enabled (default)
$Host::EvoSuperAdminWhois = 1;

// Block SuperAdmin's whois information from view
// 0 = disabled (default), 1 = enabled
$Host::EvoBlockSuperAdminWhois = 0;

// Allow Admins to reset server?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAdminReset = 0;

// Allow SuperAdmins to reset server?
// 0 = disabled, 1 = enabled (default)
$Host::EvoSuperAdminReset = 1;

// Allow SuperAdmins to superadmin other Players?
// 0 = disabled, 1 = enabled (default)
$Host::EvoSuperAdminSuper = 1;

// Allow Admins to enable/disable CRC check? (server must be started with ispawn or tribes2d-restart.sh!)
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminCRCCheck = 0;

// Allow SuperAdmin to enable/disable CRC check? (server must be started with ispawn or tribes2d-restart.sh!)
// 0 = disabled (default), 1 = enabled
$Host::EvoSuperAdminCRCCheck = 1;

// Allow Admins to enable Clanlock?
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminClanLock = 0;

// Allow SuperAdmins to enable Clanlock?
// 0 = disabled (default), 1 = enabled
$Host::EvoSuperAdminClanLock = 1;

// Allow Admins to clear the server for a match?
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminClearServer = 0;

// Allow SuperAdmins to clear the server for a match?
// 0 = disabled, 1 = enabled (default)
$Host::EvoSuperClearServer = 1;


// **************
// * MOD SWITCH *
// **************

// Allow Admin to switch mod?
// 0 = disabled (default), 1 = enabled
$Host::EvoAdminSwitch = 0;

// Allow SuperAdmin to switch mod?
// 0 = disabled, 1 = enabled (default)
$Host::EvoSuperAdminSwitch = 1;

// Restore original mod when all Players drop?
// 0 = disabled, 1 = enabled (default)
$Host::EvoRestoreMod = 1;


// *****************
// * AUTO PASSWORD *
// *****************

// Enable auto-password reaching an amount of Players?
// 0 = disabled (default), 1 = enabled
$Host::EvoAutoPWEnabled = 1;

// Enter the auto-password password
$Host::EvoAutoPWPassword = "changeit";

// Set the number of Players server must reach, to enable auto-password
$Host::EvoAutoPWPlayerCount = 28;

// If enabled, auto-password will work in tournament mode, but once the password is set, it won't be removed
// 0 = disabled, 1 = enabled (default)
$Host::EvoAutoPWTourneyNoRemove = 1;


// ************************
// * FULL SERVER PASSWORD *
// ************************

// If enabled, when the server is full, automatically raises the allowed connected Players and set the password
// 0 = disabled, 1 = enabled (default)
$Host::EvoFullServerPWEnabled = 1;

// This is the password that will be set, once the server is full
$Host::EvoFullServerPWPassword = "changeit";

// This is the number of allowed admin the server will add when it's full
$Host::EvoFullServerPWAddAllowed = 4;


// ****************
// * NO BASE RAPE *
// ****************

// Enable No Base Rape option when there aren't too much Players on the server (works only with FFA mode)
// 0 = disabled, 1 = enabled (default)
$Host::EvoNoBaseRapeEnabled = 1;

// Set the number of Players server must reach, to disable No Base Rape (for Base)
$Host::EvoNoBaseRapePlayerCount = 20;

// Set the number of Players server must reach, to disable No Base Rape (for Classic)
$Host::EvoNoBaseRapeClassicPlayerCount = 16;


// *************
// * TEAMKILLS *
// *************

// Number of teamkills for being warned the first time (kick vote warning, 0 to disable)
$Host::EvoTKWarn1 = 3;

// Number of teamkills for starting a vote to kick the player (0 to disable)
$Host::EvoTKVote = 5;

// Number of teamkills for being warned the second time (kick warning, 0 to disable)
$Host::EvoTKWarn2 = 6;

// Number of teamkills for being kicked out of the server (0 to disable)
$Host::EvoTKMax = 8;


// **************************
// * EVOLUTION SERVER PREFS *
// **************************

// Pop up Team Me message when someone join the server, in tournament mode?
// 0 = disabled (default), 1 = enabled
$Host::EvoTeamMeMsg = 1;

// Randomize teams on mission start? (only FFA)
// 0 = disabled, 1 = enabled (default)
$Host::EvoRandomTeams = 1;

// Enable fair teams? (prevents llama team swaps)
// 0 = disabled, 1 = enabled (default)
$Host::EvoFairTeams = 1;

// List of time limits for FFA
// Seperate times in minutes by spaces
// Set to "" to use default list
$Host::EvoTimeLimitList = "25 30 45 60 120 150 180 240";

// Reset voted time limits to default on map change?
// 0 = disabled, 1 = enabled (default)
$Host::EvoDefaultTimeLimit = 1;

// Start a vote to skip the current mission on match start?
// 0 = disabled, 1 = enabled (default)
$Host::EvoSkipMission = 1;

// Message of the day
// This will be centerprinted on joining server (if FFA mode), \n to change line
$Host::EvoMOTD = "Welcome to this T2 server running\nEvolution Admin Mod";

// Lenght of time the MOTD will be visible (in seconds)
$Host::EvoMOTDtime = 10;

// Number of lines in MOTD (max is 3)
$Host::EvoMOTDlines = 3;

// Server Rules:
// Server rules are specified in the array $Host::EvoServerRules[]
// Example:
// $Host::EvoServerRules[1] = "1.) No VPad-Snipers";
// $Host::EvoServerRules[2] = "2.) No Turtling";
// $Host::EvoServerRules[3] = "...";
// etc...

$Host::EvoServerRules[1] = "1.) No VPad-Snipers";
$Host::EvoServerRules[2] = "2.) No Turtling";
$Host::EvoServerRules[3] = "3.) No Multi Taunting";


// Load TR2 gametype?
// 0 = disabled, 1 = enabled (default)
$Host::EvoLoadTR2Gametype = 1;

// Set this to 0 if your server is having stuttering problems
$Host::EvoUseHighPerformanceCounter = 1;

// Filter FX spam sounds? (TR2 and so on)
// 0 = disabled, 1 = enabled (default)
$Host::EvoMuteSpamFX = 0;

// Kick observers?
// 0 = disabled, > 0 seconds before observer is kicked
$Host::EvoKickObservers = 300;

// Enable Game Fixes like cheat protection etc.
// 0 = disabled, 1 = enabled (default)
$Host::EvoGameFixes = 1;


// *********************
// * VOTE RESTRICTIONS *
// *********************

// Allow Players to vote change the mission?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAllowPlayerVoteChangeMission = 1;

// Allow Players to vote change the time limit?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAllowPlayerVoteTimeLimit = 1;

// Allow Players to vote change to tournament mode?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAllowPlayerVoteTournamentMode = 1;

// Allow Players to vote change the team damage?
// 0 = disabled (default), 1 = enabled
$Host::EvoAllowPlayerVoteTeamDamage = 0;

// Allow Players to vote change the game type?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAllowPlayerVoteGameType = 1;

// Allow Admins to vote change the game type?
// 0 = disabled, 1 = enabled (default)
$Host::EvoAllowAdminVoteGameType = 1;

// ***************************
// * TOURNAMENT RESTRICTIONS *
// ***************************

// Allow players to chat on global channel during
// pre-match phase of tournament mode
// 0 = disabled, 1 = enabled (default)
$Host::EvoPreMatchSpamAllowed = 1;

// Allow players to use canned chat (voice binds)
// on global channel during pre-match phase of
// tournament mode
// 0 = disabled, 1 = enabled (default)
$Host::EvoPreMatchCannedSpamAllowed = 1;

// Allow players to chat on global channel during
// match in tournament mode
// 0 = disabled, 1 = enabled (default)
$Host::EvoSpamAllowed = 1;

// Allow players to use canned chat (voice binds)
// on global channel during match in tournament
// mode
// 0 = disabled, 1 = enabled (default)
$Host::EvoCannedSpamAllowed = 1;

// Allow spamming of team channel
// 0 = disabled, 1 = enabled (default)
$Host::EvoTeamSpam = 1;

// Allow spamming of team channel with canned chat
// (voice binds)
// 0 = disabled, 1 = enabled (default)
$Host::EvoTeamCannedSpam = 1;


// ****************
// * MAP ROTATION *
// ****************

// Enable custom map rotation?
// 0 = disabled, 1 = enabled (default)
$Host::EvoCustomMapRotation = 1;

// Custom map rotation file
// Choose only one map rotation file
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_arena2vs2.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_de.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_duel.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_dynamix.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-arena2vs2-lakrabbit-duel.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-arena2vs2-lakrabbit.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-arena2vs2.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-de-arena2vs2-lakrabbit-duel.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-de-arena2vs2-lakrabbit.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-de-arena2vs2.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix-de.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2-dynamix.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2-xpack2.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_euro2.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_lakrabbit.cs";
// $Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation_xpack2.cs";
$Host::EvoCustomMapRotationFile = "prefs/evo_mapRotation.cs";

// Load a random map when a mission ends?
// 0 = disabled, 1 = enabled (default)
$Host::EvoRandomMissions = 1;

// Load the same map ending a tournament mode match?
// 0 = disabled (default), 1 = enabled
$Host::EvoTourneySameMap = 0;

// One map only in FFA?
// 0 = disabled (default), 1 = enabled
$Host::EvoOneMapOnly = 0;


// **********
// * TELNET *
// **********

// Allow remote telnet access?
// 0 = disabled, 1 = enabled (default)
$Host::Telnet = 1;

// Read only telnet access password, for Admins
$Host::TelnetListenPass = "ListenOnyPassword";

// Full access telnet password, for SuperAdmins
$Host::TelnetPassword = "FullAccessPassword";

// Server port for remote telnet applications can connect to
$Host::TelnetPort = 28100;

// Chat Messages for Total CONtrol on telnet console
// 0 = disabled, 1 = enabled (default)
$Host::EvoTCMessages = 1;

// Enable display of ingame voice communication in the Total Control Client
// 0 = disabled, 1 = enabled (default)
$Host::EvoTCCannedMessages = 1;


// ********
// * LOGS *
// ********

// Use daily logs? (they will be saved like this: logs/ConnectLog-17-Dec-02.txt)
// 0 = disabled, 1 = enabled (default)
$Host::EvoDailyLogs = 1;

// Starts the new log at this time (use 00-23 hours)
$Host::EvoDailyHour = "00:00";

// Log the ingame chat? (file: logs/Chat/ChatLog.txt)
// 0 = disabled (default), 1 = enabled
$Host::EvoChatLogging = 0;

// Log the ingame voice commands?
// 0 = disabled (default), 1 = enabled
$Host::EvoCannedChatLogging = 0;

// Log what Admins and SuperAdmins do? (file: logs/Admin/AdminLog.txt)
// 0 = disabled, 1 = enabled (default)
$Host::EvoAdminLogging = 1;

// Log client info on connect? (realname, tag, guid and ip address. File: logs/Connect/ConnectLog.txt)
// 0 = disabled, 1 = enabled (default)
$Host::EvoConnectLogging = 1;

// Log Teamkills? (file: logs/TK/TKLog.txt)
// 0 = disabled (default), 1 = enabled
$Host::EvoTKLogging = 0;


// **********************
// * SERVER PREFERENCES *
// **********************


// ***********
// * GENERAL *
// ***********

// Name of the server
$Host::GameName = "T2 Evolution Server";

// Server info
$Host::Info = "This is a server running the Evolution Admin Mod.";

// CRC Textures ON?
// 0 = disabled, 1 = enabled (default)
$Host::CRCTextures = 1;

// Pure server
// 0 = disabled, 1 = enabled (default)
$Host::PureServer = 1;

// Server password, Players have to enter this to get on the server
// Leave this free, when server should run public
$Host::Password = "";

// Admin password
$Host::AdminPassword = "changeme";

// SuperAdmin password
$Host::SuperAdminPassword = "changeme";

// Allow Players to vote for an Admin?
// 0 = disabled, 1 = enabled (default)
$Host::allowAdminPlayerVotes = 1;

// Minimum number of Players to enable?
$Host::EvoAdminMinPlayers = 5;

// Enable Flood Protection?
// 0 = disabled, 1 = enabled (default)
$Host::FloodProtectionEnabled = 1;

// Max lenght of text messages
$Host::MaxMessageLen = 120;

// Set the max number of Players the server allow
$Host::MaxPlayers = 32;

// Enable team damage?
// 0 = disabled (default), 1 = enabled
$Host::TeamDamageOn = 1;

// Allow aliased Players?
// 0 = allow alias, 1 = doesn't allow alias (default)
$Host::NoSmurfs = 1;

// High Visibility
// 0 = High Frame Rate (default), 1 = High Visibility
$Host::HiVisibility = 0;

// Show player scores during debriefing?
// 0 = disabled, 1 = enabled (default)
$Host::ShowEndingPlayerScores = 1;

// Let Players view own score?
// 0 = disabled, 1 = enabled (default)
$Host::ShowIngamePlayerScores = 1;


// ****************
// * BAN AND KICK *
// ****************

// Lenght of time a player is banned for (in seconds)
$Host::BanTime = 1800;

// Lenght of time Players are banned for when kicked (in seconds)
$Host::KickBanTime = 600;


// ****************
// * NET SETTINGS *
// ****************

// Is server dedicated?
// Setting this to 0 won't reset the server when everyone drops (NULL bug comes more times)
// 0 = disabled, 1 = enabled (default)
$Host::Dedicated = 1;

// Server port
$Host::Port = 28000;

// Set to an ip address if the server wants to specify which NIC/IP to use
// Example:
// $Host::BindAddress = "213.41.38.142.76";
$Host::BindAddress = "";

// Display server on master
// Set to "Always" (default) or "Never"
$pref::Net::DisplayOnMaster = "Always";

// Servers physical location
// 1  = North America East
// 2  = North America West
// 4  = South America
// 8  = Australia
// 16 = Asia
// 32 = Europe (default)
$pref::Net::RegionMask = 32;

// This is the number of packets per second the server will send to clients
// Increasing these values will greatly improve the performance of your server for most users
// Raising them too high will decrease phoneline clients performance.
// I would suggest trying the DSL settings out on your server to see how it runs then adjust from there.
// 12 = 28.8k
// 16 = 56k
// 20 = DSL (default)
// 24 = Cable
// 32 = T1-LAN
$pref::Net::PacketRateToClient = 20;

// This is the size of the packets
// Increasing these values will greatly improve the performance of your server for most users
// Raising it too high will decrease phoneline clients performance.
// 200 = 28.8k
// 240 = 56k
// 350 = DSL (default)
// 400 = Cable
// 450 = T1-LAN
$pref::Net::PacketSize = 350;


// **************
// * AUTO ADMIN *
// **************

// All Players that will be automatically an Admin upon joining server
// Seperate WonID's by \t eg "1234\t4321\t456321"
$Host::AdminList = "";

// All Players that will be automatically a SuperAdmin upon joining server
// Seperate WonID's by \t eg "1234\t4321\t456321\t179453"
$Host::SuperAdminList = "";


// ******************
// * MATCH SETTINGS *
// ******************

// Start the server in Tournament mode?
// 0 = disabled (default), 1 = enabled
$Host::TournamentMode = 0;

// Length of time before match starts in FFA mode (in seconds)
$Host::warmupTime = 25;

// Time limit (in minutes)
$Host::TimeLimit = 25;

// Choose the mission type to starting with
$Host::MissionType = "CTF";

// Choose the map to starting with
$Host::Map = "Minotaur";

// Lenght of time Players can idle before being switched to observer (in seconds)
$Host::PlayerRespawnTimeout = 60;

// Half time mark for Siege mode
$Host::Siege::Halftime = 20000;


// *********
// * TEAMS *
// *********

// Choose team names to use
$Host::TeamName0 = "Unassigned";
$Host::TeamName1 = "Storm";
$Host::TeamName2 = "Inferno";
$Host::TeamName3 = "Starwolf";
$Host::TeamName4 = "Diamond Sword";
$Host::TeamName5 = "Blood Eagle";
$Host::TeamName6 = "Phoenix";

// Choose skins to use
$Host::TeamSkin0 = "blank";
$Host::TeamSkin1 = "base";
$Host::TeamSkin2 = "baseb";
$Host::TeamSkin3 = "swolf";
$Host::TeamSkin4 = "dsword";
$Host::TeamSkin5 = "beagle";
$Host::TeamSkin6 = "cotp";

// Choose holo names, used in CnH
$Host::holoName1 = "Storm";
$Host::holoName2 = "Inferno";
$Host::holoName3 = "Starwolf";
$Host::holoName4 = "DSword";
$Host::holoName5 = "BloodEagle";
$Host::holoName6 = "Harbinger";

// Use only Storm/Inferno in FFA matches?
// 0 = disabled, 1 = enabled (default)
$Host::useCustomSkins = 1;


// ****************
// * VOTE OPTIONS *
// ****************

// Length of time the vote lasts for (in seconds)
$Host::VoteTime = 30;

// Percentage of total votes required for vote to pass
$Host::VotePassPercent = 60;

// Min length of time between votes (in seconds)
$Host::VoteSpread = 20;


// ********
// * BOTS *
// ********

// Enable Bots?
// 0 = disabled (default), 1 = enabled
$Host::BotsEnabled = 0;

// Number of bots to start up with
$Host::BotCount = 2;

// Min Bot difficulty
// 0 = least difficult, 1 = most difficult
$Host::MinBotDifficulty = 0.5;

// Max Bot difficulty
// 0 = least difficult, 1 = most difficult
$Host::MaxBotDifficulty = 0.75;


// **************************
// * Base Practice CTF Mode *
// **************************

// Number of telepads ?
// Deploy telpads using beacon key after selecting Telepad mode
// in the PracticeHud
$Host::BaseMaxTelepads = 3;

// Tag of home clan on this server
// only home clan members may use the save/load deployable feature.
// If this string is left empty, anybody may use these options.
$Host::EvoHomeClan = "";

// ******************************
// * EVOLUTION LEASED SA SYSTEM *
// ******************************

// Interval of automatic SA list updates
// 0 = disabled (default), otherwise time in minutes
$Host::EvoLeaseInterval = 0;

// Location of automatic SA list
// Can be either a local filename, or a web address, prefixed with "http://".
// Hostnames with special characters might cause problems. Use IP adress
// instead then.
// examples:
// $Host::EvoLeaseLocation = "http://130.183.3.130/~jubelgas/timedSA.txt";
// $Host::EvoLeaseLocation = "prefs/leasedSA.txt";
$Host::EvoLeaseLocation = "prefs/leasedSA.txt";

// Default lease level when no specific admin level is specified for a lease,
// using the 1.0 3-value syntax
// 1 = Admin (default), 2 = SuperAdmin
$Host::EvoDefaultLeaseLevel = 1;

// For HTTP accesses, specify this if you need to use a proxy. If left blank,
// no proxy will be used for HTTP accesses.
// Example:
// $Host::EvoHTTPProxy = "my.proxy.com:3130";
$Host::EvoHTTPProxy = "";

// Debug HTTP transfers, displaying every line received on the server console
// 0 = disabled (default), 1 = enabled
// As the HTTP feature is not quite stable yet, this might be a useful switch
// for error detection
$Host::EvoDebugHTTP = 1;


// **************************
// * EVOLUTION CHAT CONSOLE *
// **************************

// Enable Evolution Chat console
// 0 = disabled (default), 1 = enabled
// If chat console is disabled, all chat console commands will be swallowed without
// a response. This is to not accidentially reveal security relevant information.
// A list of console commands can be obtained by typing ".help" in global chat
$Host::EvoChatConsole = 1;


// *********************
// * OBSERVE FLAG MODE *
// *********************

// $Host::EvoObserveFlag   (Enable Observe Flag mode)
// 0 = disabled, 1 = enabled (default)
// Setting this variable to 0 allows to deactivate the ObserveFlag feature,
// for policy or compatibility reasons
$Host::EvoObserveFlag = 1;












