// ConvTED.cpp : Defines the entry point for the console application.
//

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <stdio.h>
#include <tchar.h>
#include <iostream>

using namespace std;

#define BUFFER_SIZE			32000
#define HEADER_SKIP_BYTES	0
#define FOOTER_SKIP_BYTES	0

int main(int argc, _TCHAR* argv[])
{
	FILE *inputFile, *outputFile;
	char buffer[10];
	short height;
	int numWritten = 0;

	cout << "ConvTED 1.0" << endl;
	cout << "Written by Michael Johnston at Irrational Games Australia, 2003" << endl << endl;

	// Count args, show usage
	if (argc < 3)
	{
		cout << "This program converts a Tribes 1 terrain file (in exported" << endl;
		cout << "text format) to a raw 16-bit binary file." << endl << endl;
		cout << "Usage:" << endl;
		cout << "   ConvTED inputFile outputFile" << endl;
		return 1;
	}

	// Open the input file
	cout << "Opening " << argv[1] << " for read..." << endl;
    if( (inputFile = fopen( argv[1], "r" )) == NULL )
    {
       cout << "Could not open file for reading!" << endl;
	   return 1;
    }

	// Write to output file
	cout << "Opening " << argv[2] << " for write..." << endl;
    if( (outputFile = fopen( argv[2], "wb" )) == NULL )
    {
       cout << "Could not open file for writing!" << endl;
	   return 1;
    }

	// Convert
	numWritten = 0;
    while (fgets(buffer, 10, inputFile) != NULL)
	{
		height = atoi(buffer);
		numWritten += (int)fwrite( &height, sizeof( height ), 1, outputFile );
	}

	cout << "Wrote " << numWritten << " bytes" << endl;

	// Close files
	fclose( inputFile );
	fclose( outputFile );

	cout << "Done." << endl;

	return 0;
}

