// #autoload
// #name = FlagCircle
// #version = 1.5
// #date = 15 February, 2003
// #author = ilys
// #description = Two coloured circles, one for each team. Changes colour, green(home) flashing green/orange(taken) and flashing green/red(dropped).
// #category = ilys' Scripts
// #status = release
// #include = support/callback.cs
// #include = support/flag_tracker.cs
// #include = support/player_support.cs

package FlagCircle {
function PlayGui::onWake(%this) {
	callback.add(onCTFGrab, FlagCircleFlagTaken);
	callback.add(onCTFCap, FlagCircleFlagReturn);
	callback.add(onCTFDrop, FlagCircleFlagDrop);
	callback.add(onCTFPicked, FlagCircleFlagTaken);
	callback.add(onCTFReturn, FlagCircleFlagReturn);
	callback.add(MyTeamChanged, FlagCircleTeamChange);
	parent::onWake(%this);

	if(!isObject(PlayGui)) return;

	if (isObject(YourFlagCircle)) return;
	new GuiBitmapCtrl(YourFlagCircle) {
		horizSizing = "right";
		vertSizing = "bottom";
		position = "0 0";
		extent = "25 25";
		minExtent = "8 8";
		visible = "0";
		bitmap = "gui/hud_flag_home.png";
	};

	if (isObject(EnemyFlagCircle)) return;
	new GuiBitmapCtrl(EnemyFlagCircle) {
		horizSizing = "right";
		vertSizing = "bottom";
		position = "0 0";
		extent = "25 25";
		minExtent = "8 8";
		visible = "0";
		bitmap = "gui/hud_flag_home.png";
	};

	playGui.add(YourFlagCircle);
	playGui.add(EnemyFlagCircle);
	if(isObject(HM) && isObject(HudMover))
	{
		hudmover::addhud(YourFlagCircle,"FlagCircleYours");
		hudmover::addhud(EnemyFlagCircle,"FlagCircleEnemy");
	}
}

function FlagCircleFlagDrop(%flagref)
{
	%myname = PlayerList.getMyName();
	%myteam = PlayerList.getTeamByName(%myname);
	%flagteam = %flagref.teamID;
	if(%flagteam == %myteam)
	{
		if ($circleyourtakencolorswapSchedule != 0) cancel($circleyourtakencolorswapSchedule);
		circleyourdropcolorswapcycle();
	}
	if(%flagteam != %myteam && %myteam != 0)
	{
		if ($circleenemytakencolorswapSchedule != 0) cancel($circleenemytakencolorswapSchedule);
		circleenemydropcolorswapcycle();
	}
}

function FlagCircleFlagTaken(%flagref)
{
	%myname = PlayerList.getMyName();
	%myteam = PlayerList.getTeamByName(%myname);
	%flagteam = %flagref.teamID;
	if(%flagteam == %myteam)
	{
		if ($circleyourdropcolorswapSchedule != 0) cancel($circleyourdropcolorswapSchedule);
		circleyourtakencolorswapcycle();
	}
	if(%flagteam != %myteam && %myteam != 0)
	{
		if ($circleenemydropcolorswapSchedule != 0) cancel($circleenemydropcolorswapSchedule);
		circleenemytakencolorswapcycle();
	}
}

function FlagCircleFlagReturn(%flagref)
{
	%myname = PlayerList.getMyName();
	%myteam = PlayerList.getTeamByName(%myname);
	%flagteam = %flagref.teamID;
	if(%flagteam == %myteam)
	{
		if ($circleyourtakencolorswapSchedule != 0) cancel($circleyourtakencolorswapSchedule);
		if ($circleyourdropcolorswapSchedule != 0) cancel($circleyourdropcolorswapSchedule);
		YourFlagCircle.setbitmap("gui/hud_flag_home.png");
	}
	if(%flagteam != %myteam && %myteam != 0)
	{
		if ($circleenemytakencolorswapSchedule != 0) cancel($circleenemytakencolorswapSchedule);
		if ($circleenemydropcolorswapSchedule != 0) cancel($circleenemydropcolorswapSchedule);
		EnemyFlagCircle.setbitmap("gui/hud_flag_home.png");
	}
}

function circleyourdropcolorswapcycle()
{
	if($circleyourdropcolorswap == 1)
	{
		$circleyourdropcolorswap = 0;
		YourFlagCircle.setbitmap("gui/hud_flag_drop.png");
	}
	else
	{
		$circleyourdropcolorswap = 1;
		YourFlagCircle.setbitmap("gui/hud_flag_home.png");
	}
	if ($circleyourdropcolorswapSchedule != 0) cancel($circleyourdropcolorswapSchedule);
	$circleyourdropcolorswapSchedule = schedule(500, 0, circleyourdropcolorswapcycle);
}

function circleenemydropcolorswapcycle()
{
	if($circleenemydropcolorswap == 1)
	{
		$circleenemydropcolorswap = 0;
		EnemyFlagCircle.setbitmap("gui/hud_flag_drop.png");
	}
	else
	{
		$circleenemydropcolorswap = 1;
		EnemyFlagCircle.setbitmap("gui/hud_flag_home.png");
	}

	if ($circleenemydropcolorswapSchedule != 0) cancel($circleenemydropcolorswapSchedule);
	$circleenemydropcolorswapSchedule = schedule(500, 0, circleenemydropcolorswapcycle);
}

function circleyourtakencolorswapcycle()
{
	if($circleyourtakencolorswap == 1)
	{
		$circleyourtakencolorswap = 0;
		YourFlagCircle.setbitmap("gui/hud_flag_taken.png");
	}
	else
	{
		$circleyourtakencolorswap = 1;
		YourFlagCircle.setbitmap("gui/hud_flag_home.png");
	}
	if ($circleyourtakencolorswapSchedule != 0) cancel($circleyourtakencolorswapSchedule);
	$circleyourtakencolorswapSchedule = schedule(250, 0, circleyourtakencolorswapcycle);
}

function circleenemytakencolorswapcycle()
{
	if($circleenemytakencolorswap == 1)
	{
		$circleenemytakencolorswap = 0;
		EnemyFlagCircle.setbitmap("gui/hud_flag_taken.png");
	}
	else
	{
		$circleenemytakencolorswap = 1;
		EnemyFlagCircle.setbitmap("gui/hud_flag_home.png");
	}

	if ($circleenemytakencolorswapSchedule != 0) cancel($circleenemytakencolorswapSchedule);
	$circleenemytakencolorswapSchedule = schedule(250, 0, circleenemytakencolorswapcycle);
}

function FlagCircleTeamChange(%teamID)
{
	if ($circleyourtakencolorswapSchedule != 0) cancel($circleyourtakencolorswapSchedule);
	if ($circleenemytakencolorswapSchedule != 0) cancel($circleenemytakencolorswapSchedule);
	if ($circleyourdropcolorswapSchedule != 0) cancel($circleyourdropcolorswapSchedule);
	if ($circleenemydropcolorswapSchedule != 0) cancel($circleenemydropcolorswapSchedule);
	YourFlagCircle.setbitmap("gui/hud_flag_home.png");
	EnemyFlagCircle.setbitmap("gui/hud_flag_home.png");
	if(%teamID != 0)
	{
		YourFlagCircle.setvisible("1");
		EnemyFlagCircle.setvisible("1");
		%myteam = %teamID;
		if(%myteam == 1)
			%enemyteam = 2;
		else
			%enemyteam = 1;

		error(%myteam);
		error(%enemyteam);
		%myflag = FlagTracker.team[%myteam];
		%enemyflag = FlagTracker.team[%enemyteam];
		if(%myflag.stateCurrent $= "At Home")
		{
			YourFlagCircle.setbitmap("gui/hud_flag_home.png");
		}
		else if(%myflag.stateCurrent $= "Taken")
		{
			circleyourtakencolorswapcycle();
		}
		else if(%myflag.stateCurrent $= "In Field")
		{
			circleyourdropcolorswapcycle();
		}
		if(%enemyflag.stateCurrent $= "At Home")
		{
			YourFlagCircle.setbitmap("gui/hud_flag_home.png");
		}
		else if(%enemyflag.stateCurrent $= "Taken")
		{
			circleenemytakencolorswapcycle();
		}
		else if(%enemyflag.stateCurrent $= "In Field")
		{
			circleenemydropcolorswapcycle();
		}
	}
	else
	{
		YourFlagCircle.setvisible("0");
		EnemyFlagCircle.setvisible("0");
	}
}
};
activatePackage(FlagCircle);