// #name = FreeHUDs
// #version = 1.65
// #date = Dec 15, 2001
// #author = Paul Tousignant
// #warrior = UberGuy (FT)
// #email = uberguy@skyreach.cas.nwu.edu
// #description = Creates independant, hudMover compatible Compass and life/energy bars


if(!isObject(uberGUI)) {
    new ScriptObject(uberGUI) { class = uberGUI; };
}

function uberGUI::setDefaults(%this) {

	CompassVisible.setValue(true);
	CompassFancy.setValue(true);
	CompassRing.setValue(true);
	CompassXpar.setValue(1.0);
	CompassClock.setValue(true);
	CompassRadar.setValue(true);

	ClockVisible.setValue(true);
	ClockXpar.setValue(1.0);
	ClockOpaque.setValue(false);

	RadarVisible.setValue(true);
	RadarRing.setValue(true);
	RadarXpar.setValue(1.0);

	HealthVisible.setValue(true);
	HealthXpar.setValue(1.0);
	HealthFrame.setValue(true);

	EnergyVisible.setValue(true);
	EnergyXpar.setValue(1.0);
	EnergyFrame.setValue(true);
}

function uberGUI::loadPrefs(%this, %force) {

	if (!$uberPref::loaded || %force) {
		exec("prefs/uberPrefs.cs");
		$uberPref::loaded = 1;
	}

	CompassVisible.setValue($uberPref::freeHUDs::show_["uberCompassFrame"]);
	eval(CompassVisible.command);
	CompassXpar.setValue($uberPref::freeHUDs::opacity_["uberCompassFrame"]);
	eval(CompassXpar.command);
	CompassRing.setValue($uberPref::freeHUDs::show_["uberCompassRing"]);
	eval(CompassRing.command);
	CompassFancy.setValue($uberPref::freeHUDs::show_["uberCompassImage"]);
	eval(CompassFancy.command);
	CompassClock.setValue($uberPref::freeHUDs::show_["uberClock"]);
	eval(CompassClock.command);
	CompassRadar.setValue($uberPref::freeHUDs::show_["uberSensorGrp"]);
	eval(CompassRadar.command);

	ClockVisible.setValue($uberPref::freeHUDs::show_["uberClockFrame"]);
	eval(ClockVisible.command);
	ClockXpar.setValue($uberPref::freeHUDs::opacity_["uberClockFrame"]);
	eval(ClockXpar.command);
	ClockOpaque.setValue($uberPref::freeHUDs::transparentClock);
	eval(ClockOpaque.command);

	RadarVisible.setValue($uberPref::freeHUDs::show_["uberSensorFrame"]);
	eval(RadarVisible.command);
	RadarXpar.setValue($uberPref::freeHUDs::opacity_["uberSensorFrame"]);
	eval(RadarXpar.command);
	RadarRing.setValue($uberPref::freeHUDs::show_["uberSensorRing"]);
	eval(RadarRing.command);

	HealthVisible.setValue($uberPref::freeHUDs::show_["uberDamageFrame"]);
	eval(HealthVisible.command);
	HealthXpar.setValue($uberPref::freeHUDs::opacity_["uberDamageFrame"]);
	eval(HealthXpar.command);
	HealthFrame.setValue($uberPref::freeHUDs::show_["uberDamageBitmap"]);
	eval(HealthFrame.command);

	EnergyVisible.setValue($uberPref::freeHUDs::show_["uberEnergyFrame"]);
	eval(EnergyVisible.command);
	EnergyXpar.setValue($uberPref::freeHUDs::opacity_["uberEnergyFrame"]);
	eval(EnergyXpar.command);
	EnergyFrame.setValue($uberPref::freeHUDs::show_["uberEnergyBitmap"]);
	eval(EnergyFrame.command);
}

function uberGUI::savePrefs(%this) {

	export("$uberPref::*", "prefs/uberPrefs.cs", false);
}

function uberGUI::activate(%this) {

	activatePackage(uberGuiPkg);
}

function uberGUI_toggleFHpane(%val) {

	if (%val) {
		if (freeHUDsPane.displayed) Canvas.popDialog(freeHUDsPane);
		else Canvas.pushDialog(freeHUDsPane);
		freeHUDsPane.displayed = ! freeHUDsPane.displayed;
	}
}

// New GuiControl methods =====================================================

function GuiControl::setAllOpacity(%this, %val, %child) {

	//Record preference of root object
	if (!%child) $uberPref::freeHUDs::opacity_[%this] = %val;

	//Set opacity
	if (%this.opacity !$= "") {
		if (%this.baseOpacity $= "") %this.baseOpacity = %this.opacity;
		%this.opacity = (%this.baseOpacity + 0) * %val;
	}

	//Recursively set opacity of all child objects
	for(%i=0; %i<%this.getCount(); %i++) {
		%this.getObject(%i).setAllOpacity(%val, true);
	}
}

// Try to show the object based on it's last visiblity setting call
// May be overriden by prefs (see setVisible())
function GuiControl::refreshVisible(%this) {

	if (%this.desiredVis $= "") %this.desiredVis = %this.visible;
	%this.setVisible(%this.desiredVis);
}

function uberClockFrame::toggleProfile(%this) {

	%this.profile =
		$uberPref::freeHUDs::transparentClock ? GuiDefaultProfile : GuiChatBackProfile;
	playGui.remove(%this);
	playGui.add(%this);
}

// Function Overrides =========================================================

package uberGuiPkg {

	// Allow prefs for hiding objects to override the parameter sent
	function GuiControl::setVisible(%this, %val) {

		if ($uberPref::freeHUDs::show_[%this] !$= "") {
			%this.desiredVis = %val;
			parent::setVisible(%this,$uberPref::freeHUDs::show_[%this] && %val);
		}
		else
			parent::setVisible(%this,%val);
	}

	// Keep game from re-adding the Sensor back to the original compass cluster
	function hudClusterBack::add(%this, %object) {

		if (%object $= SensorHud) return;
		parent::add(%this, %object);
	}

	// Toggle the FreeHUDs with the rest
	function clientCmdTogglePlayHuds(%val) {

		uberClockFrame.setVisible(%val);
		uberDamageFrame.setVisible(%val);
		uberEnergyFrame.setVisible(%val);
		uberSensorFrame.setVisible(%val);
		uberCompassFrame.setVisible(%val);
		parent::clientCmdTogglePlayHuds(%val);
	}

	// Keep game from re-adding the clock or compass cluster back to the playGui
	function playGui::add(%this, %object) {

		if (%object $= clockHud || %object $=hudClusterBack) return;
		parent::add(%this, %object);
	}

	// Update my new sensor HUD with the old one
	function SensorHud::update(%this) {

		uberSensor.setVisible(%this.ping || %this.jam);

		if(%this.jam) uberSensor.color = %this.jamColor;
		else uberSensor.color = %this.pingColor;
		parent::update(%this);
	}

	// Create and initialize everything
//	function LoadingGui::onWake(%this) {
	function playGui::onWake(%this) {

		parent::onWake(%this);
		if (!isObject(freeHUDsPane)) {
			exec("scripts/UberGuy/freeHUDs.gui");
			uberGUI.createElements();
			uberGUI.setDefaults();
			uberGUI.loadPrefs(true);
		}
	}

	// Keep my clocks in synch
	function clientCmdSyncHudClock(%time) {

		uberClock.setTime(%time);
		uberClock2.setTime(%time);
		parent::clientCmdSyncHudClock(%time);
	}

	function setSystemClock(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6) {

		$Hud::TimeLimit = detag(%a1);
		%timeLeftMS = detag(%a2);
		uberClock.setTime(%time = %timeLeftMS / (60 * 1000));
		uberClock2.setTime(%time);
		parent::setSystemClock(%msgType, %msgString, %a1, %a2, %a3, %a4, %a5, %a6);
	}

	function OptionsDlg::onWake(%this) {

		if (!uberGUI.options) {
			$RemapName[$RemapCount] = "FreeHUDs Options";
			$RemapCmd[$RemapCount]  = "uberGUI_toggleFHpane";
			$RemapCount++;
			uberGUI.options = true;
		}
		parent::onWake(%this);
	}
};

// Main GUI Construction Area (LONG) ==========================================

function uberGUI::createElements(%this) {

	if (!isObject(uberCompassFrame)) {

		new GuiControl(uberCompassFrame) {

			profile = "GuiDefaultProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "561 0";
			extent = "81 81";
			minExtent = "8 8";
			visible = "1";
			opacity = "1.0";
			autoCenter = "0";

			new GuiControl() {

				profile = "GuiDefaultProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 1";
				extent = "100 100";
				minExtent = "8 8";
				visible = "1";
				opacity = "1.0";
				autoCenter = "0";

				new HudCompass(uberCompassHud) {

					profile = "clockProfile";
					horizSizing = "left";
					vertSizing = "bottom";
					position = "0 0";
					extent = "81 81";
					minExtent = "8 8";
					visible = "1";
					opacity = "1.0";
					textColor = "0 255 0";
				};
			};

			new HudBitmapCtrl(uberCompassRing) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "81 81";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 1 0 1";
				opacity = "0.9";
				bitmap = "gui/hud_new_compass.png";
			};

			new HudBitmapCtrl(uberCompassImage) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "81 81";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 1 0 1";
				opacity = "0.9";
				bitmap = "gui/hud_new_comp2.png";

			};

			new GuiControl(uberSensorGrp) {

				profile = "GuiDefaultProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "27 25";
				extent = "27 29";
				minExtent = "8 8";
				visible = "1";
				opacity = "1.0";
				autoCenter = "1";

				new HudPulsingBitmap(uberSensorBack) {

					profile = "GuiButtonProfile";
					horizSizing = "left";
					vertSizing = "bottom";
					position = "0 0";
					extent = "27 29";
					minExtent = "8 8";
					visible = "1";
					frameColor = "0 1 0 1";
					opacity = "0.9";
					bitmap = "gui/hud_new_ping.png";
					pulse = false;
					color = "3 255 110";
				};
			};

			new HudClock(uberClock) {

				profile = "clockProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "8 30";
				extent = "65 23";
				minExtent = "8 8";
				visible = "1";
				hideCursor = "0";
				bypassHideCursor = "0";
				helpTag = "0";
				fillColor = "0.250000 0.250000 0.250000 0.250000";
				frameColor = "0.000000 1.000000 0.000000 1.000000";
				opacity = "0.9";
				bitmap = "gui/hud_mistimer.png";
				autoCenter = "0";
				autoResize = "0";
				flipVertical = "0";
				flipHorizontal = "0";
				subRegion = "0 2 65 15";
			};
		};

		new GuiControl(uberSensorFrame) {

			profile = "GuiDefaultProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "480 55";
			extent = "40 40";
			minExtent = "8 8";
			visible = "1";
			opacity = "1.0";
			autoCenter = "1";

			new HudPulsingBitmap(uberSensor) {
				profile = "GuiDefaultProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "40 40";
				minExtent = "8 8";
				visible = "1";
				opacity = "0.9";
				bitmap = "gui/hud_radar_pulse.png";
				pulse = true;
				pulseRate = 1000;
				visible = false;

				pingColor = "255 22 22";
				jamColor = "253 255 2";
			};

			new HudBitmapCtrl(uberSensorRing) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "40 40";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 0 0 0";
				opacity = "0.9";
				bitmap = "gui/hud_radar.png";
			};
		};

		new GuiControl(uberEnergyFrame) {

			profile = "GuiDefaultProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "455 30";
			extent = "99 17";
			minExtent = "8 8";
			visible = "1";
			opacity = "1.0";

			new HudBitmapCtrl(uberEnergyBG) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "99 17";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 0 0 0";
				opacity = "0.4";
				bitmap = "gui/hud_new_en_heat_back.png";
				autoCenter = "1";
			};

			new HudEnergy(uberEnergyHud) {

				profile = "GuiDefaultProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "3 3";
				extent = "93 5";
				minExtent = "93 5";
				visible = "1";
				setFirstResponder = "0";
				modal = "1";
				helpTag = "0";
				fillColor = "0.353000 0.373000 0.933000 0.800000";
				frameColor = "0.000000 1.000000 0.000000 1.000000";
				opacity = "0.9";
				subRegion = "0 0 93 5";
				pulseRate = "500";
				pulseThreshold = "0.3";
			};

			new HudHeat(uberHeatHud) {

				profile = "GuiDefaultProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "3 9";
				extent = "93 5";
				minExtent = "93 5";
				visible = "1";
				setFirstResponder = "0";
				modal = "1";
				helpTag = "0";
				fillColor = "1.000 0.000 0.000 0.800000";
				opacity = "0.9";
				subRegion = "0 0 93 5";
				pulseRate = "500";
				pulseThreshold = "0.3";
				heatWarning = 0.7;  //When does the heat bar flash on the player?
			};

			new HudBitmapCtrl(uberEnergyBitmap) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "99 17";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 0 0 0";
				opacity = "0.9";
				bitmap = "gui/hud_new_en_heat.png";
				autoCenter = "1";
			};
		};

		new GuiControl(uberDamageFrame) {

			profile = "GuiDefaultProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "455 10";
			extent = "99 11";
			minExtent = "8 8";
			visible = "1";
			opacity = "1.0";

			new HudBitmapCtrl(uberDamageBG) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "99 11";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 0 0 0";
				opacity = "0.4";
				bitmap = "gui/hud_new_health_back.png";
				autoCenter = "1";
			};

			new HudDamage(uberDamageHud) {

				profile = "GuiDefaultProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "3 2";
				extent = "93 8";
				minExtent = "93 8";
				visible = "1";
				setFirstResponder = "0";
				modal = "1";
				helpTag = "0";
				fillColor = "0.000 1.000 0.000 0.800000";
				frameColor = "0.000000 1.000000 0.000000 0.000000";
				opacity = "0.5";
				subRegion = "0 0 93 8";
				pulseRate = "500";
				pulseThreshold = "0.3";
			};

			new HudBitmapCtrl(uberDamageBitmap) {

				profile = "GuiButtonProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "0 0";
				extent = "99 11";
				minExtent = "8 8";
				visible = "1";
				frameColor = "0 0 0 0";
				opacity = "0.9";
				bitmap = "gui/hud_new_health.png";
				autoCenter = "1";
			};
		};

		new ShellFieldCtrl(uberClockFrame)
		{
			profile = "GuiChatBackProfile";
			horizSizing = "left";
			vertSizing = "bottom";
			position = "510 55";
			extent = "43 16";
			minExtent = "8 8";
			visible = "1";

			new HudClock(uberClock2)
			{
				profile = "ClockProfile";
				horizSizing = "left";
				vertSizing = "bottom";
				position = "1 0";
				extent = "43 16";
				visible = "1";
				bitmap = "gui/hud_mistimer.png";
				subRegion = "0 2 43 15";
				text = "";
			};
		};

		uberSensorGrp.add(SensorHud);
		sensorHud.position = "0 0";
	}

	if (playGui.isMember(clockHud)) playGui.remove(clockHud);
	if (playGui.isMember(hudClusterBack)) playGui.remove(hudClusterBack);

	if (!playGui.isMember(uberClockFrame))	playGui.add(uberClockFrame);
	if (!playGui.isMember(uberSensorFrame))	playGui.add(uberSensorFrame);
	if (!playGui.isMember(uberDamageFrame))	playGui.add(uberDamageFrame);
	if (!playGui.isMember(uberEnergyFrame))	playGui.add(uberEnergyFrame);
	if (!playGui.isMember(uberCompassFrame)) playGui.add(uberCompassFrame);

	// Add to hudMover
	if(isObject(HM) && isObject(HudMover)) {
		hudmover::addhud(uberClockFrame,"Free Clock");
		hudmover::addhud(uberSensorFrame,"Free Sensor");
		hudmover::addhud(uberCompassFrame,"Free Compass");
		hudmover::addhud(uberDamageFrame,"Free HealthBar");
		hudmover::addhud(uberEnergyFrame,"Free EnergyBar");
	}
}

uberGui.activate();
