$ssScoreHudInterval = 1;
$ssScoreHudShowReturner = false;
$ssScoreFriendlySwitch = 0;
$ssScoreEnemySwitch = 0;

function ssScoreHudHandleFlag(%msgType, %msgString, %clientName, %flagTeam, %flagTeamId) {
    if ($ssScoreHudTeamId != 1 && $ssScoreHudTeamId != 2)
        return;
    %msgType = detag(%msgType);
    %clientName = detag(%clientName);
    %flagTeamId = detag(%flagTeamId);
    switch$(%msgType) {
        case "MsgCTFFlagTaken":
            if (%flagTeamId == $ssScoreHudTeamId) {
                cancel($ssScoreHudFriendlySchedule);
                SSFriendlyScoreHudText.setText("\c0\x8b\c6Taken\c0\x9b");
            } else {
                cancel($ssScoreHudEnemySchedule);
                SSEnemyScoreHudText.setText("\c0\x8b\c6Taken\c0\x9b");
            }
            commandToServer('getScores');
        case "MsgCTFFlagDropped":
            if (%flagTeamId == $ssScoreHudTeamId)
                ssScoreHudFriendlyTimer(45);
            else
                ssScoreHudEnemyTimer(45);
        case "MsgCTFFlagReturned":
            if (%flagTeamId == $ssScoreHudTeamId) {
                cancel($ssScoreHudFriendlySchedule);
                $ssScoreHudFriendlyTime = 0;
                if ($ssScoreHudShowReturner) {
                    SSFriendlyScoreHudText.setText("\c0\xab " @ %clientName);
                    SSFriendlyScoreHudText.schedule(3000, setText, "\c0\x8b\c5Home\c0\x9b");
                } else
                    SSFriendlyScoreHudText.setText("\c0\x8b\c5Home\c0\x9b");
            } else {
                cancel($ssScoreHudEnemySchedule);
                $ssScoreHudEnemyTime = 0;
                if ($ssScoreHudShowReturner) {
                    SSEnemyScoreHudText.setText("\c0\xab " @ %clientName);
                    SSEnemyScoreHudText.schedule(3000, setText, "\c0\x8b\c5Home\c0\x9b");
                } else
                    SSEnemyScoreHudText.setText("\c0\x8b\c5Home\c0\x9b");
            }
        case "MsgCTFFlagCapped":
            if (%flagTeamId == $ssScoreHudTeamId)
                SSFriendlyScoreHudText.setText("\c0\x8b\c5Home\c0\x9b");
            else
                SSEnemyScoreHudText.setText("\c0\x8b\c5Home\c0\x9b");
            commandToServer('getScores');
    }
    ssScoreHudDrawScores();
}

function ssScoreHudHandleScore(%msgType, %msgString, %teamId, %teamScore) {
    if ($ssScoreHudTeamId $= "")
        $ssScoreHudTeamId = "0";
    if (%teamId == $ssScoreHudTeamId)
        $ssScoreHudFriendlyScore = %teamScore;
    else
        $ssScoreHudEnemyScore = %teamScore;
    ssScoreHudDrawScores();
}

function ssScoreHudDrawScores() {
    SSFriendlyScoreHudScore.setText($ssScoreHudFriendlyScore);
    SSEnemyScoreHudScore.setText($ssScoreHudEnemyScore);
}

function ssScoreHudHandleJoin(%msgType, %msgString, %clientName, %clientId) {
    if (strStr(%msgString, "Welcome to Tribes") != -1) {
        SSScoreHudCarrierName.setVisible(0);
        SSScoreHudCarrierHealth.setVisible(0);
        SSFriendlyScoreHudText.setVisible(1);
        SSEnemyScoreHudText.setVisible(1);
        $ssScoreHudClientId = %clientId;
        $ssScoreHudOldTeam = $ssScoreHudTeamId = 1;
        ssScoreHudReset();
    }
}

function ssScoreHudHandleJoinTeam(%msgType, %msgString, %clientName, %teamName, %clientId, %teamId) {
    if ($ssScoreHudClientId == %clientId) {
        $ssScoreHudTeamId = %teamId != 0 ? %teamId : 1;
        if ($ssScoreHudOldTeam != $ssScoreHudTeamId && ObjectiveHud.GameType $= "CTFGame") {
            %friendlyText = SSFriendlyScoreHudText.getValue();
            SSFriendlyScoreHudText.setText(SSEnemyScoreHudText.getValue());
            SSEnemyScoreHudText.setText(%friendlyText);
            if (isEventPending($ssScoreHudFriendlySchedule)) {
                $ssScoreFriendlySwitch = $ssScoreHudFriendlyTime;
                $ssScoreHudFriendlyTime = $ssScoreEnemySwitch;
            }
            if (isEventPending($ssScoreHudEnemySchedule)) {
                $ssScoreEnemySwitch = $ssScoreHudEnemyTime;
                $ssScoreHudEnemyTime = $ssScoreFriendlySwitch;
            }
        }
        $ssScoreHudOldTeam = $ssScoreHudTeamId;
        commandToServer('getScores');
    }
}

package ssScoreHud {
    function DispatchLaunchMode() {
        parent::DispatchLaunchMode();
        ssMakeScoreHud();
    }
    
    function disconnect() {
        parent::disconnect();
        ssScoreHudReset();
    }

    function ObjectiveHud::setVisible(%this, %visible) {
        if (ObjectiveHud.GameType $= "TR2Game" || ObjectiveHud.GameType $= "CTFGame")
            parent::setVisible(%this,false);
        else
            parent::setVisible(%this,%visible);
    }
};
activatePackage(ssScoreHud);

function ssScoreHudFriendlyTimer(%time, %pass) {
    if ($ssScoreFriendlySwitch != 0 && !%pass) {
        ssScoreHudEnemyTimer($ssScoreFriendlySwitch - $ssScoreHudInterval,true);
        $ssScoreFriendlySwitch = 0;
        return;
    }
    if (%time !$= "")
        $ssScoreHudFriendlyTime = %time;
    else
        $ssScoreHudFriendlyTime -= $ssScoreHudInterval;
    %fmt = strLen(getSubStr($ssScoreHudInterval,(strStr($ssScoreHudInterval,".") == -1) ? 0 : strStr($ssScoreHudInterval,"."),1000))-1;
    SSFriendlyScoreHudText.setText("\c0\x8b\c5" @ mFormatFloat($ssScoreHudFriendlyTime,"%." @ (%fmt != -1 ? %fmt : 0) @ "f") @ "\c0\x9b");
    $ssScoreHudFriendlySchedule = schedule($ssScoreHudInterval * 1000,0,ssScoreHudFriendlyTimer);
}

function ssScoreHudEnemyTimer(%time, %pass) {
    if ($ssScoreEnemySwitch != 0 && !%pass) {
        ssScoreHudFriendlyTimer($ssScoreEnemySwitch - $ssScoreHudInterval,true);
        $ssScoreEnemySwitch = 0;
        return;
    }
    if (%time !$= "")
        $ssScoreHudEnemyTime = %time;
    else
        $ssScoreHudEnemyTime -= $ssScoreHudInterval;
    %fmt = strLen(getSubStr($ssScoreHudInterval,(strStr($ssScoreHudInterval,".") == -1) ? 0 : strStr($ssScoreHudInterval,"."),1000))-1;
    SSEnemyScoreHudText.setText("\c0\x8b\c5" @ mFormatFloat($ssScoreHudEnemyTime,"%." @ (%fmt != -1 ? %fmt : 0) @ "f") @ "\c0\x9b");
    $ssScoreHudEnemySchedule = schedule($ssScoreHudInterval * 1000,0,ssScoreHudEnemyTimer);
}

function ssScoreHudReset() {
    $ssScoreHudFriendlyTime = 0;
    $ssScoreHudEnemyTime = 0;
    SSFriendlyScoreHudText.setText("\c0\x8b\c5Home\c0\x9b");
    cancel($ssScoreHudFriendlySchedule);
    SSEnemyScoreHudText.setText("\c0\x8b\c5Home\c0\x9b");
    cancel($ssScoreHudEnemySchedule);
    SSScoreHudCarrierName.setText("Center");
}

function ssScoreHudHandleTR2HudInit(%msgType, %msgString, %team1, %team2, %score1, %score2, %flagLoc, %carrierHealth) {
    SSScoreHudCarrierName.setVisible(1);
    SSScoreHudCarrierHealth.setVisible(1);
    SSFriendlyScoreHudText.setVisible(0);
    SSEnemyScoreHudText.setVisible(0);
    $ssScoreHudFriendlyScore = ($ssScoreHudTeamId == 1) ? detag(%score1) : detag(%score2);
    $ssScoreHudEnemyScore = ($ssScoreHudTeamId == 1) ? detag(%score2) : detag(%score1);
    SSScoreHudCarrierName.setText(%flagLoc);
    SSScoreHudCarrierHealth.setValue(%carrierHealth);
    ssScoreHudDrawScores();
}

function ssScoreHudHandleTR2SetScore(%msgType, %msgString, %team, %score) {
    if ($ssScoreHudTeamId == %team)
        $ssScoreHudFriendlyScore = %score;
    else
        $ssScoreHudEnemyScore = %score;
    ssScoreHudDrawScores();
}

function ssScoreHudHandleTR2FlagStatus(%msgType, %msgString, %location) {
    SSScoreHudCarrierName.setText(detag(%location));
}

function ssScoreHudHandleTR2FlagTaken(%msgType, %msgString, %client, %team, %flagteam, %clientnamebase) {
    SSScoreHudCarrierName.setText(detag(%client));
}

function ssScoreHudHandleTR2FlagDropped(%msgType, %msgString, %client, %team, %flagteam) {
    SSScoreHudCarrierName.setText("Dropped");
}

function ssScoreHudHandleTR2CarrierHealth(%msgType, %msgString, %amt, %team) {
    if (%team == 1)
        SSScoreHudCarrierHealth.profile.fillColor = $TR2::Color::CarrierFriendly;
    else
        SSScoreHudCarrierHealth.profile.fillColor = $TR2::Color::CarrierEnemy;
    SSScoreHudCarrierHealth.setValue(%amt);
}

function ssMakeScoreHud() {
    new GuiControlProfile(SSScoreHudFriendlyTextProfile) {
        fontType = "Univers";
        fontSize = 15;
        fontColor = $PlayerNameColor;
        fontColors[5] = "0 255 0";
        fontColors[6] = "255 0 0";
        fontColors[7] = "255 0 0";
        fontColors[8] = "255 0 0";
        fontColors[9] = "255 0 0";
        justify = "center";
    };
    
    new GuiControlProfile(SSScoreHudEnemyTextProfile) {
        fontType = "Univers";
        fontSize = 15;
        fontColor = $PlayerNameColor;
        fontColors[5] = "255 0 0";
        fontColors[6] = "0 255 0";
        fontColors[7] = "0 255 0";
        fontColors[8] = "0 255 0";
        fontColors[9] = "0 255 0";
        justify = "center";
    };
    
    new GuiControlProfile(SSScoreHudCarrierNameProfile) {
        fontType = "Univers";
        fontSize = 15;
        fontColor = $PlayerNameColor;
        fontColors[6] = $PlayerNameColor;
        fontColors[7] = $TribeTagColor;
        fontColors[8] = $SmurfNameColor;
        fontColors[9] = $BotNameColor;
        justify = "left";
    };
    
    new GuiControlProfile(SSScoreHudScoreProfile) {
        fontType = "arial bold";
        fontSize = 15;
        fontColor = "0 0 0";
        justify = "center";
    };

    new GuiControl(SSFriendlyScoreHudFrame) {
        profile = "GuiDefaultProfile";
        horizSizing = "left";
        vertSizing = "bottom";
        position = "0 0";
        extent = "200 15";
        minExtent = "8 8";
        visible = "1";

        new GuiTextCtrl(SSFriendlyScoreHudText) {
            profile = "SSScoreHudFriendlyTextProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "0 0";
            extent = "70 15";
            minExtent = "8 8";
            visible = "1";
            maxLength = "255";
            text = "\c0\x8b\c5Home\c0\x9b";
        };
        new GuiTextCtrl(SSFriendlyScoreHudScore) {
            profile = "SSScoreHudScoreProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "61 0";
            extent = "30 15";
            minExtent = "8 8";
            visible = "1";
            maxLength = "255";
        };
        new GuiTextCtrl(SSScoreHudCarrierName) {
            profile = "SSScoreHudCarrierNameProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "33 0";
            extent = "150 15";
            minExtent = "8 8";
            visible = "1";
            maxLength = "255";
            text = "Center";
        };
    };

    new GuiControl(SSEnemyScoreHudFrame) {
        profile = "GuiDefaultProfile";
        horizSizing = "left";
        vertSizing = "bottom";
        position = "0 0";
        extent = "200 15";
        minExtent = "8 8";
        visible = "1";

        new GuiTextCtrl(SSEnemyScoreHudText) {
            profile = "SSScoreHudEnemyTextProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "0 0";
            extent = "70 15";
            minExtent = "8 8";
            visible = "1";
            maxLength = "255";
            text = "\c0\x8b\c5Home\c0\x9b";
        };
        new GuiTextCtrl(SSEnemyScoreHudScore) {
            profile = "SSScoreHudScoreProfile";
            horizSizing = "left";
            vertSizing = "bottom";
            position = "61 0";
            extent = "30 15";
            minExtent = "8 8";
            visible = "1";
            maxLength = "255";
        };
        new GuiProgressCtrl(SSScoreHudCarrierHealth) {
            profile = "TR2CarrierHealth";
            horizSizing = "right";
            vertSizing = "bottom";
            position = "33 3";
            extent = "93 10";
            minExtent = "8 8";
            visible = "0";
            hideCursor = "0";
            bypassHideCursor = "0";
            helpTag = "0";
        };
    };
    playGui.add(SSFriendlyScoreHudFrame);
    playGui.add(SSEnemyScoreHudFrame);
    if (isObject(HM) && isObject(HudMover)) {
        hudmover::addhud(SSFriendlyScoreHudFrame, "Friendly Score/Flag");
        hudmover::addhud(SSEnemyScoreHudFrame, "Enemy Score/Flag");
    }
    addMessageCallback('MsgCTFFlagTaken', ssScoreHudHandleFlag);
    addMessageCallback('MsgCTFFlagDropped', ssScoreHudHandleFlag);
    addMessageCallback('MsgCTFFlagReturned', ssScoreHudHandleFlag);
    addMessageCallback('MsgCTFFlagCapped', ssScoreHudHandleFlag);
    addMessageCallback('MsgTeamScore', ssScoreHudHandleScore);
    addMessageCallback('MsgGameOver', ssScoreHudReset);
    addMessageCallback('MsgClientJoin', ssScoreHudHandleJoin);
    addMessageCallback('MsgClientJoinTeam', ssScoreHudHandleJoinTeam);
    addMessageCallback('MsgTR2ObjInit', ssScoreHudHandleTR2HudInit);
    addMessageCallback('MsgTR2SetScore', ssScoreHudHandleTR2SetScore);
    addMessageCallback('MsgTR2FlagStatus', ssScoreHudHandleTR2FlagStatus);
    addMessageCallback('MsgTR2FlagTaken', ssScoreHudHandleTR2FlagTaken);
    addMessageCallback('MsgTR2FlagDropped', ssScoreHudHandleTR2FlagDropped);
    addMessageCallback('MsgTR2CarrierHealth', ssScoreHudHandleTR2CarrierHealth);
}
