// #name = TeamCountHud
// #version = 1.1
// #date = November 10th, 2001
// #author = Grinder
// #description = Shows Players per Team in a little HUD
// #email = Grinder@team-darkfire.com
// #web = http://www.planettribes.com/grinder
// #credit = {DF}Magnox, [SOO]The_Wizard, Many Public Players joining and dropping for me if they know or not :)
// #status = finished

package TeamCountHud
{

function TeamCountHudPlayerJoinTeam(%msgType, %msgString, %clientName, %teamName, %clientId, %teamId)
{
   if(%clientId $= $managerId)
      $TeamCountHud::OwnTeam = %teamId;

   if($TeamCountHud::Client[%clientId] !$= "")
       $TeamCountHud::Team[$TeamCountHud::Client[%clientId]]--;

   $TeamCountHud::Team[%teamId]++;
   $TeamCountHud::Client[%clientId] = %teamId;
   TeamCountHudUpdate();
}

function TeamCountHudUpdate()
{
    if($TeamCountHud::OwnTeam $= 1)
       %other = 2;
    else if($TeamCountHud::OwnTeam $= 2)
       %other = 1;
    else if($TeamCountHud::OwnTeam $= 0) // Cheat $TeamCountHud::OwnTeam to not hack HUD while in Observer
    {
       $TeamCountHud::OwnTeam = 1;
       %other = 2;
    }
    if($TeamCountHud::Team[1] $= "")
       $TeamCountHud::Team[1] = 0;
    if($TeamCountHud::Team[2] $= "")
       $TeamCountHud::Team[2] = 0;

    TeamCountHud.text[1].SetValue($TeamCountHud::Team[$TeamCountHud::OwnTeam]);
    TeamCountHud.text[2].SetValue($TeamCountHud::Team[%other]);
}

function TeamCountHudPlayerJoin(%msgType, %msgString, %clientName, %clientId, %targetId, %isAI, %isAdmin, %isSuperAdmin, %isSmurf, %guid) {

	if(StrStr(%msgString, "Welcome to Tribes") != -1) {
       $managerId = %clientId;
       TeamCountHudUpdate();
    }
}

function TeamCountHudPlayerDrop(%msgType, %msgString, %clientName, %clientId)
{
   if($managerId $= %clientId)
   {
       $TeamCountHud::Team[1] = "0";
       $TeamCountHud::Team[2] = "0";
   } else {
    $TeamCountHud::Team[$TeamCountHud::Client[%clientId]]--;
    $TeamCountHud::Client[%clientId] = "";
    TeamCountHudUpdate();
   }
}

function TeamCountHudToggle(%val)
{
  if(%val)
  {
    if($pref::TeamCountHudToggle)
    {
         addMessageHudLine("\c2TeamCountHUD toggled OFF.");
         $pref::TeamCountHudToggle = false;
         TeamCountHud.setVisible(false);
    } else {

         addMessageHudLine("\c2TeamCountHUD toggled ON.");
         $pref::TeamCountHudToggle = true;
         TeamCountHud.setVisible(true);
    }
  }
}

function OptionsDlg::onWake(%this)
{
	if (!$TeamCountHudKeys)
	{
		$RemapName[$RemapCount] = "Toggle TeamCountHUD";
		$RemapCmd[$RemapCount]  = "TeamCountHUDToggle";
		$RemapCount++;

		$TeamCountHudKeys = true;
	}
    parent::onWake(%this);
}

//function TeamCountHudReset()
//{
//    $TeamCountHud::Team[1] = 0;
//    $TeamCountHud::Team[2] = 0;
//}

function DispatchLaunchMode()
{
    addMessageCallback('MsgClientJoin', TeamCountHudPlayerJoin);
    addMessageCallback('MsgClientJoinTeam', TeamCountHudPlayerJoinTeam);
    addMessageCallback('MsgClientDrop', TeamCountHudPlayerDrop);
    //addMessageCallback('MsgMissionEnd', TeamCountHudReset);

    parent::DispatchLaunchMode();
}

function disconnect()
{
    $TeamCountHud::Team[1] = 0;
    $TeamCountHud::Team[2] = 0;
    deleteVariables("$TeamCountHud::Client*");

    parent::disconnect();
}

function PlayGui::onWake(%this)
{
    schedule(1000, 0, TeamCountHudCreate);
    schedule(1200, 0, TeamCountHudUpdate);
    parent::onWake(%this);
}

function TeamCountHudCreate()
{
   //if(isObject(TeamCountHud))
   //{
   //   PlayGui.remove(TeamCountHud);
   //   TeamCountHud.delete();
   //}

   if(!isObject(TeamCountHud))
   {
	   %y = getWord($pref::Video::resolution, 1)-45;
	   %x = getWord($pref::Video::resolution, 0)-36;
	   // Not working properly. is hax0red with Advanced Objective HUD :/
	   //%y = getWord(ObjectiveHud.position, 1);
	   //%x = getWord(ObjectiveHud.extent, 0)+10;

	   new ShellFieldCtrl(TeamCountHud)
	   {
	   	  profile = "GuiDefaultProfile";
	  	  horizSizing = "left";
		  vertSizing = "bottom";
		  position = "918 678";
		  extent = 18 SPC 50;
		  minExtent = "8 8";
		  visible = "1";
	   };

	   TeamCountHud.text[1] = new GuiTextCtrl()
	   {
	      profile = "HudTeamCountProfileFriend";
	      horizSizing = "right";
	      vertSizing = "bottom";
	  	  position = 0 SPC 0;
		  extent = 18 SPC 16;
	      visible = "1";
	   };

	   TeamCountHud.text[2] = new GuiTextCtrl()
	   {
	      profile = "HudTeamCountProfileEnemy";
	      horizSizing = "right";
	      vertSizing = "bottom";
	  	  position = 0 SPC 22;
		  extent = 18 SPC 16;
	      visible = "1";
	   };

	   TeamCountHud.add(TeamCountHud.text[1]);
	   TeamCountHud.add(TeamCountHud.text[2]);
	   playgui.add(TeamCountHud);

	   hudmover::addhud(TeamCountHud, TeamCountHud);
   }
}

};

activatePackage(TeamCountHud);

new GuiControlProfile ("HudTeamCountProfileFriend")
{
	fontType = "Verdana";
	fontSize = 16;
	fontColor = "23 236 67";
	justify = "Center";
};
new GuiControlProfile ("HudTeamCountProfileEnemy")
{
	fontType = "Verdana";
	fontSize = 16;
	fontColor = "255 0 0";
	justify = "Center";
};
