//-------------------------------------------------------------------
// Caerbannog Rabbit Script
//
// Release Version 3.0.0
// 7/4/2003
// ]V[ista|)eath
//-------------------------------------------------------------------
// DisplayName = Caerbannog

//--- GAME RULES BEGIN ---
//Caerbannog Version 3.0.0
//FIGHT, don't RUN!; only DIRECT HITS hurt
//Rabbit loses 1pt/15 sec; Rabbit's kills=5pts
//Hit distance/speed bonuses
//MA-Test Code from MinRabbit 1.1, tweaked by ]V[ista|)eath, seasoned with borlaK sauce
//Check yr chat HUD for more rules and features
//--- GAME RULES END ---

datablock ParticleData(MidairKillParticle)
{
    dragCoefficient = 0;
    gravityCoefficient = 0.017094;
    inheritedVelFactor = 1.7176125;
    constantAcceleration = -0.1129;
    lifetimeMS = 6000;
    lifetimeVarianceMS = 100;
    useInvAlpha = 1;
    spinRandomMin = -200;
    spinRandomMax = 200;
    textureName = "special/Smoke/smoke_001"; // special/Smoke/smoke_001
    colors[0] = "0.000000 0.000000 1.000000 1.000000";
    colors[1] = "1.000000 0.000000 1.000000 1.000000";
    colors[2] = "1.000000 0.000000 0.000000 1.000000";
    colors[3] = "1.000000 1.000000 1.000000 1.000000";

    sizes[0] = 2;
    sizes[1] = 3;
    sizes[2] = 2;
    sizes[3] = 1;

    times[0] = 0;
    times[1] = 2;
    times[2] = 4;
    times[3] = 5;
};

datablock ParticleEmitterData(MidairKillEmitter)
{
    ejectionPeriodMS = 10;
    periodVarianceMS = 0;
    ejectionVelocity = 10.25;
    velocityVariance = 0.25;
    ejectionOffset =   0;
    thetaMin = 0;
    thetaMax = 180;
    phiReferenceVel = 0;
    phiVariance = 360;
    overrideAdvances = 0;
    orientParticles= 1;
    orientToNormal = 0;
    orientOnVelocity = 1;
    lifetimeMS = 2000;
    particles = "MidairKillParticle";
};

package RabbitGame {

  function Flag::objectiveInit(%data, %flag) {
    $flagStatus = "<At Home>";
    %flag.carrier = "";
    %flag.originalPosition = %flag.getTransform();  
    %flag.isHome = true;

    setTargetSensorGroup(%flag.getTarget(), %flag.team);
    setTargetAlwaysVisMask(%flag.getTarget(), 0x7);
    setTargetRenderMask(%flag.getTarget(), getTargetRenderMask(%flag.getTarget()) | 0x2);
    %flag.scopeWhenSensorVisible(true);

    // create a waypoint to the flag's starting place
    %flagWaypoint = new WayPoint()
    {
      position = %flag.position;
      rotation = "1 0 0 0";
      name = "Flag Home";
      dataBlock = "WayPointMarker";
      team = $NonRabbitTeam;
    };

    $AIRabbitFlag = %flag;

    MissionCleanup.add(%flagWaypoint);
  }

function Armor::damageObject(%data, %targetObject, %sourceObject, %position, %amount, %damageType, %momVec, %mineSC) {
	//nerf blaster damage;
	%myamt = %amount;
	if (%damageType == 1) %myamt = %amount/3;
	if (%damageType != 16)
	{
		if (Game.testForMA(%targetObject, %sourceObject, %amount, %damageType))
		{
        
			%targetObject.incInventory(RepairKit, 1);
			%targetObject.throw(RepairKit);
			%targetObject.incInventory(RepairKit, 1);
			%targetObject.incInventory(DiscAmmo, 5);
			%targetObject.throw(DiscAmmo);
			%targetObject.incInventory(DiscAmmo, 5);
			parent::damageObject(%data, %targetObject, %sourceObject, %position, %myamt, %damageType, %momVec, %mineSC);
		        if(%targetObject.getState() $= "Dead")
        		{
//				%targetObject.setMomentumVector(%momVec);
//				%targetObject.blowup();
				// MA effect
				%newEmitter = new ParticleEmissionDummy(MidairKillEffect)
				{
    					position = %targetObject.getTransform();
	    				rotation = "1 0 0 0";
    					scale = "1 1 1";
    					dataBlock = "defaultEmissionDummy";
    					emitter = "MidairKillEmitter";
    					velocity = "2";
    	   			};
           			%newEmitter.schedule(%newEmitter.emitter.lifetimeMS, "delete");
        		} // DEAD
        		return;
		} // MA
		if (%damageType != 11) 
		{
			parent::damageObject(%data, %targetObject, %sourceObject, %position, %myamt, %damageType, %momVec, %mineSC);
		} // DAMAGETYPE != 11
	} // DAMAGETYPE != 16
} // ARMOR::DAMAGEOBJECT()


function MineDeployed::damageObject(%data, %targetObject, %sourceObject, %position, %amount, %damageType)
{
// NO NIFTY NADE/MINE SCRIPTS 
	if (%damageType != 5) parent::damageObject(%data, %targetObject, %sourceObject, %position, %amount, %damageType);
}

function deployMineCheck(%mineObj, %player)
{
	// explode it vgc
	schedule(2000, %mineObj, "explodeMine", %mineObj, true);
}

function PlayingPlayers()
{
	%players = 0;
	for (%i = 0; %i < ClientGroup.getCount(); %i++)
	{
		%cl = ClientGroup.getObject(%i);
		if(isObject(%cl.player) && %cl.player.team > 0)
			%players++;
	}
	return %players;
}	

};

//exec the AI scripts
exec("scripts/aiRabbit.cs");

//exec the records script
if (isFile("prefs/RabbitRecords.cs"))
   exec("prefs/RabbitRecords.cs");


function RabbitGame::init(%game) {

// SAVE SETTINGS WE'RE TWEAKING
// Disc Ammo
$LMHMaxDiscAmmo=LightMaleHumanArmor.max[DiscAmmo];
$LFHMaxDiscAmmo=LightFemaleHumanArmor.max[DiscAmmo];
$LMBMaxDiscAmmo=LightMaleBiodermArmor.max[DiscAmmo];

// Mines
$LMHMaxMine=LightMaleHumanArmor.max[Mine];
$LFHMaxMine=LightFemaleHumanArmor.max[Mine];
$LMBMaxMine=LightMaleBiodermArmor.max[Mine];

// Blaster
$MMBMaxBlaster=MediumMaleBiodermArmor.max[Blaster];
$MMHMaxBlaster=MediumMaleHumanArmor.max[Blaster];
$MFHMaxBlaster=MediumFemaleHumanArmor.max[Blaster];
$HMBMaxBlaster=HeavyMaleBiodermArmor.max[Blaster];
$HMHMaxBlaster=HeavyMaleHumanArmor.max[Blaster];
$HFHMaxBlaster=HeavyFemaleHumanArmor.max[Blaster];

// Weapon Attributes
$DiscDD=DiscProjectile.directDamage;
$DiscDDT=DiscProjectile.directDamageType;
$DiscID=DiscProjectile.indirectDamage;
$DiscRDT=DiscProjectile.radiusDamageType;
$PlasmaDD=PlasmaBolt.directDamage;
$PlasmaDDT=PlasmaBolt.directDamageType;
$PlasmaID=PlasmaBolt.indirectDamage;
$NadeID=BasicGrenade.indirectDamage;
$NadeDR=BasicGrenade.damageRadius;
$HandNadeID=GrenadeThrown.indirectDamage;
$HandNadeDR=GrenadeThrown.damageRadius;
$BlasterMinNRG=BlasterImage.minEnergy;
$BlasterFireNRG=BlasterImage.fireEnergy;

//Ban weapons
$IBLTOD=$InvBanList[Rabbit, "TurretOutdoorDeployable"];
$IBLTID=$InvBanList[Rabbit, "TurretIndoorDeployable"];
$IBLEBP=$InvBanList[Rabbit, "ElfBarrelPack"];
$IBLMBP=$InvBanList[Rabbit, "MortarBarrelPack"];
$IBLPBP=$InvBanList[Rabbit, "PlasmaBarrelPack"];
$IBLABP=$InvBanList[Rabbit, "AABarrelPack"] = 1;
$IBLMiBP=$InvBanList[Rabbit, "MissileBarrelPack"];
$IBLML=$InvBanList[Rabbit, "MissileLauncher"];
$IBLMo=$InvBanList[Rabbit, "Mortar"];
$IBLLR=$InvBanList[Rabbit, "SniperRifle"];
$IBLConc=$InvBanList[Rabbit, "ConcussionGrenade"];
$IBLFlash=$InvBanList[Rabbit, "FlashGrenade"];
//$IBLMine=$InvBanList[Rabbit, "Mine"];
$IBLELF=$InvBanList[Rabbit, "ELFGun"];
$IBLCG=$InvBanList[Rabbit, "Chaingun"];
$IBLSatch=$InvBanList[Rabbit, "SatchelCharge"];

// TWEAK SETTINGS

//Up Disc Ammo
LightMaleHumanArmor.max[DiscAmmo]=25;
LightFemaleHumanArmor.max[DiscAmmo]=25;
LightMaleBiodermArmor.max[DiscAmmo]=25;

//Up Mines
LightMaleHumanArmor.max[Mine]=5;
LightFemaleHumanArmor.max[Mine]=5;
LightMaleBiodermArmor.max[Mine]=5;

// Blasters for Lights only so extra energy 
// of heavier armors doesn't increase the 
// spam potential.
MediumMaleBiodermArmor.max[Blaster]=0;
MediumMaleHumanArmor.max[Blaster]=0;
MediumFemaleHumanArmor.max[Blaster]=0;
HeavyMaleBiodermArmor.max[Blaster]=0;
HeavyMaleHumanArmor.max[Blaster]=0;
HeavyFemaleHumanArmor.max[Blaster]=0;

// Make splash weapons direct hit only.
// Reduce nade splash radius to require more precision.
DiscProjectile.directDamage=0.50;
DiscProjectile.directDamageType=$DamageType::Disc;
DiscProjectile.radiusDamageType=$DamageType::PlasmaTurret;
DiscProjectile.indirectDamage=0.50;
PlasmaBolt.directDamage=0.45;
PlasmaBolt.directDamageType=$DamageType::Plasma;
PlasmaBolt.indirectDamage=0.0;
BasicGrenade.indirectDamage=0.40;
BasicGrenade.damageRadius=4.0;
GrenadeThrown.indirectDamage=0.40;
GrenadeThrown.damageRadius=5.0;
//BlasterImage.minEnergy=10;
//BlasterImage.fireEnergy=10;

//Ban weapons
$InvBanList[Rabbit, "TurretOutdoorDeployable"] = 1;
$InvBanList[Rabbit, "TurretIndoorDeployable"] = 1;
$InvBanList[Rabbit, "ElfBarrelPack"] = 1;
$InvBanList[Rabbit, "MortarBarrelPack"] = 1;
$InvBanList[Rabbit, "PlasmaBarrelPack"] = 1;
$InvBanList[Rabbit, "AABarrelPack"] = 1;
$InvBanList[Rabbit, "MissileBarrelPack"] = 1;
$InvBanList[Rabbit, "MissileLauncher"] = 1;
$InvBanList[Rabbit, "Mortar"] = 1;
$InvBanList[Rabbit, "SniperRifle"] = 1;
$InvBanList[Rabbit, "ConcussionGrenade"] = 1;
$InvBanList[Rabbit, "FlashGrenade"] = 1;
$InvBanList[Rabbit, "Mine"] = 0;
$InvBanList[Rabbit, "ELFGun"] = 1;
$InvBanList[Rabbit, "Chaingun"] = 1;
$InvBanList[Rabbit, "SatchelCharge"] = 1;

//New Explosions
LightMaleHumanArmor.explosion = TurretExplosion;
LightMaleHumanArmor.expDmgRadius = 0.0;
LightMaleHumanArmor.expDamage = 0.0;
LightMaleHumanArmor.expImpulse = 2000.0;

  // temp
  %game.soundsOn = 1;
  %game.alertMAClients = 1;

  // minimums
  %game.minMAHeight = 3;
  %game.minFlagHeight = 5;
  %game.minDiscDamage = 0.49;
  %game.minPlasmaDamage = 0.449;
  %game.minSLDamage = 0.449;
  %game.minSLBackDamage = 1.349;
  %game.minGrenadeDamage = 0.04;
  %game.minBlasterDamage = 0.149;
  %game.minMineDamage = 0.29;

  // rabbit modifier
  %game.rabbitMod = 2;

  // base points
  %game.pDisc = 2;
  %game.pPlasma = 1;
  %game.pSL = 3;
  %game.pSLBack = 4;
  %game.pGrenade = 5;
  %game.pBlaster = 1;
  %game.pMine = 6;

  // points per meter
  %game.ppmDisc = 0.1;
  %game.ppmPlasma = 0.12;
  %game.ppmSL = 0.15;
  %game.ppmSLBack = 0.25;
  %game.ppmGrenade = 0.11;
  %game.ppmBlaster = 0.05;
  %game.ppmMine = 0.12;

  // game scoped records
  %game.MANamedisc = "";
  %game.MADistancedisc = "";
  %game.MANameplasma = "";
  %game.MADistanceplasma = "";
  %game.MANamegrenade = "";
  %game.MADistancegrenade = "";
  %game.MANameblaster = "";
  %game.MADistanceblaster = "";
  %game.MANameshocklance = "";
  %game.MADistanceshocklance = "";
  %game.MANamebacklance = "";
  %game.MADistancebacklance = "";
  %game.MANamemine = "";
  %game.MADistancemine = "";
}

function RabbitGame::setUpTeams(%game)
{
   // Force the numTeams variable to one:
   DefaultGame::setUpTeams(%game);
   %game.numTeams = 1;
   setSensorGroupCount(3);

   //team damage should always be off for Rabbit
   $teamDamage = 0;

   //make all the sensor groups visible at all times
   if (!Game.teamMode)
   {
      setSensorGroupAlwaysVisMask($NonRabbitTeam, 0xffffffff);
      setSensorGroupAlwaysVisMask($RabbitTeam, 0xffffffff);

      // non-rabbits can listen to the rabbit: all others can only listen to self
      setSensorGroupListenMask($NonRabbitTeam, (1 << $RabbitTeam) | (1 << $NonRabbitTeam));
   }
}

function RabbitGame::initGameVars(%game)
{
   %game.init();
   %game.playerBonusValue = 1;
   %game.playerBonusTime = 3 * 1000; //3 seconds

   %game.teamBonusValue = 1;
   %game.teamBonusTime = 15 * 1000; //15 seconds
   %game.flagReturnTime = 45 * 1000;  //45 seconds 

   %game.waypointFrequency = 25000;
   %game.waypointDuration = 5000;
}

$RabbitTeam = 2;
$NonRabbitTeam = 1;

// ----- These functions supercede those in DefaultGame.cs

function RabbitGame::allowsProtectedStatics(%game)
{
   return true;
}

function RabbitGame::clientMissionDropReady(%game, %client)
{
   %game.resetScore(%game, %client);
   messageClient(%client, 'MsgClientReady', "", %game.class);
   messageClient(%client, 'MsgYourScoreIs', "", 0);
   //messageClient(%client, 'MsgYourRankIs', "", -1);
   messageClient(%client, 'MsgRabbitFlagStatus', "", $flagStatus);
   
   messageClient(%client, 'MsgMissionDropInfo', '\c0You are in mission %1 (%2) on %3.', $MissionDisplayName, $MissionTypeDisplayName, $ServerName ); 
   messageClient(%client, 'RabbitProps', 'CURRENT CHANGES/ADDITIONS:');
   messageClient(%client, 'RabbitProps', '     DIRECT HITS ONLY!!!');
   messageClient(%client, 'RabbitProps', '     Rabbit -1/15sec');
   messageClient(%client, 'RabbitProps', ""@"     Rabbit's kills = 5");
   messageClient(%client, 'RabbitProps', '     Hit distance/speed bonuses');
   messageClient(%client, 'RabbitProps', '     MA grab bonus');
   messageClient(%client, 'RabbitProps', '     Nade radius = 4m; blaster damage nerfed');
   messageClient(%client, 'RabbitProps', '     MA Mine-Disc bonus');
   messageClient(%client, 'RabbitProps', '     Record keeping');
   messageClient(%client, 'RabbitProps', '     thx and <3 --> TruSoulja, borlaK');
   messageClient(%client, 'RabbitProps', "" @ "~wvoice/Training/Any/ANY.hunting.WAV");

   DefaultGame::clientMissionDropReady(%game,%client);
}

function RabbitGame::AIHasJoined(%game, %client)
{
   //let everyone know the player has joined the game
   //messageAllExcept(%client, -1, 'MsgClientJoinTeam', '%1 needs the flag...', %client.name, "", %client, $NonRabbitTeam);
}

function RabbitGame::clientJoinTeam( %game, %client, %team, %respawn )
{
   %game.assignClientTeam( %client );
   
   // Spawn the player:
   %game.spawnPlayer( %client, %respawn );
}


function RabbitGame::assignClientTeam(%game, %client)
{
   // all players start on team 1
   %client.team = $NonRabbitTeam;

   // set player's skin pref here
   setTargetSkin(%client.target, %client.skin);

   // Let everybody know you are no longer an observer:
   messageAll( 'MsgClientJoinTeam', '\c1%1 wants to kill the bunny...', %client.name, "", %client, %client.team );
   updateCanListenState( %client );
}


// modified to spawn you near rabbit or flag
function RabbitGame::pickTeamSpawn(%game, %team) 
{
	//find the rabbit
	%spawnNear = -1;
	for (%i = 0; %i < ClientGroup.getCount(); %i++)
	{
		%cl = ClientGroup.getObject(%i);
		if (isObject(%cl.player) && isObject(%cl.player.holdingFlag))
		{
			%spawnNear = %cl.player;
			break;
		}
	}
   
	if(!isObject(%spawnNear))
	{
		for (%i = 0; %i < Team0.getCount(); %i++)
		{
			%obj = Team0.getObject(%i);
			
			if(%obj.dataBlock $= Flag)
			{
				%spawnNear = %obj;
				if(!%obj.isHome)
					break;
			}
		}
	}

	for(%i = 0; %i < 25; %i++)
	{
		%pos = %spawnNear.getWorldBoxCenter();
		%randx = getWord(%pos,0)+getRandom(-150,150);
		%randy = getWord(%pos,1)+getRandom(-150,150);
		%mask = $TypeMasks::StaticShapeObjectType | $TypeMasks::InteriorObjectType | $TypeMasks::TerrainObjectType; 
		%rayStart = %randx SPC %randy SPC "5000";
		%rayEnd = %randx SPC %randy SPC "-5000";
		%ground = ContainerRayCast(%rayStart, %rayEnd, %mask, 0);
		if(%ground)
			break;
	}
	if(%ground)
	{
		%loc = getWord(%ground,1) SPC getWord(%ground,2) SPC getWord(%ground,3);
		return %loc;
	}
	return "0 0 100";
}            


function RabbitGame::pickPlayerSpawn(%game, %client, %respawn)
{
   // all spawns come from team 1
   return %game.pickTeamSpawn($NonRabbitTeam);
}




function RabbitGame::playerSpawned(%game, %player)
{
   //call the default stuff first...
   DefaultGame::playerSpawned(%game, %player);

   //find the rabbit
   %clRabbit = -1;
   for (%i = 0; %i < ClientGroup.getCount(); %i++)
   {
      %cl = ClientGroup.getObject(%i);
      if (isObject(%cl.player) && isObject(%cl.player.holdingFlag))
      {
         %clRabbit = %cl;
         break;
      }
   }

   //now set a waypoint just for that client...
   cancel(%player.client.waypointSchedule);
   if (isObject(%clRabbit) && !%player.client.isAIControlled())
     %player.client.waypointSchedule = %game.showRabbitWaypointClient(%clRabbit, %player.client);

   buyFavorites(%player.client);
   %game.fixFavorites(%player);
   %player.schedule(250,"selectWeaponSlot", 0);
   %player.setEnergyLevel(%player.getDatablock().maxEnergy);
}

function RabbitGame::pickPlayerSpawn(%game, %client, %respawn)
{
   // all spawns come from team 1
   return %game.pickTeamSpawn($NonRabbitTeam);
}

function RabbitGame::createPlayer(%game, %client, %spawnLoc, %respawn)
{
   %client.team = $NonRabbitTeam;
   DefaultGame::createPlayer(%game, %client, %spawnLoc, %respawn);
}

function RabbitGame::recalcScore(%game, %client)
{
   //score is (grabs + kills + rabbitkills bonus[-4*teamkills]) - (totalTime / 60 seconds + Suicides + TurretKills);
   %timeHoldingFlagMS = %client.flagTimeMS;
   if (isObject(%client.player.holdingFlag))
      %timeHoldingFlagMS += getSimTime() - %client.startTime;
   %client.score = (%client.flagGrabs + %client.kills + (-4 * %client.teamkills) + (-1 * %client.suicides) + (-1 * %client.turretkills)) - mFloor(%timeHoldingFlagMS / 15000) + %client.mrStyle;
   messageClient(%client, 'MsgYourScoreIs', "", %client.score);
   %game.recalcTeamRanks(%client);
   %game.checkScoreLimit(%client);
}

function RabbitGame::onClientDamaged(%game, %clVictim, %clAttacker, %damageType, %sourceObject)
{
   //if the victim is the rabbit, and the attacker is not the rabbit, set the damage time...
   if (isObject(%clAttacker) && %clAttacker != %clVictim)
   {
      if (%clVictim.team == $RabbitTeam)
         %game.rabbitDamageTime = getSimTime();
   }

   //call the default
   DefaultGame::onClientDamaged(%game, %clVictim, %clAttacker, %damageType, %sourceObject);
}

function RabbitGame::onClientKilled(%game, %clVictim, %clKiller, %damageType, %implement, %damageLoc)
{
   //see if the killer was the rabbit and the victim was someone else...
   // If so then add the bonus to the rabbit and subtract a point from the victim
   if (isObject(%clKiller) && (%clKiller != %clVictim) && (%clKiller.team == $RabbitTeam))
   {
      %clKiller.teamkills--;
      %clvictim.turretkills++;
      %game.recalcScore(%clKiller);
      %game.recalcScore(%clvictim);
   }

   //Penalty for suicides (1 point)
   if (isObject(%clKiller) && (%clKiller == %clVictim))
   {
      %game.recalcScore(%clkiller);
   }

   DefaultGame::onClientKilled(%game, %clVictim, %clKiller, %damageType, %implement, %damageLoc);
}

function RabbitGame::playerDroppedFlag(%game, %player)
{
   //set the flag status
   %flag = %player.holdingFlag;
   %player.holdingFlag = "";
   %flag.carrier = "";

   %player.unmountImage($FlagSlot);
   %flag.hide(false);

   //hide the rabbit waypoint
   cancel(%game.waypointSchedule);
   %game.hideRabbitWaypoint(%player.client);

   //set the client status
   %player.client.flagTimeMS += getSimTime() - %player.client.startTime;
   %player.client.team = $NonRabbitTeam;
   %player.client.setSensorGroup($NonRabbitTeam);
   setTargetSensorGroup(%player.getTarget(), $NonRabbitTeam);

   messageAllExcept(%player.client, -1, 'MsgRabbitFlagDropped', '\c2%1 dropped the flag!~wfx/misc/flag_drop.wav', %player.client.name);
   // if the player left the mission area, he's already been notified
   if(!%player.outArea)
      messageClient(%player.client, 'MsgRabbitFlagDropped', '\c2You dropped the flag!~wfx/misc/flag_drop.wav');
   logEcho(%player.client.nameBase@" (pl "@%player@"/cl "@%player.client@") dropped flag");
   $flagStatus = "<In the field>";
   %flag.returnThread = %game.schedule(%game.flagReturnTime, "returnFlag", %flag);
}

function RabbitGame::playerTouchFlag(%game, %player, %flag)
{
   if ((%flag.carrier $= "") && (%player.getState() !$= "Dead"))
   {
	   if(PlayingPlayers() < 2)
	   {
		messageClient(%player.client, 'msgNoFlagWarning', "\c2You can't pick up the flag until another person joins." );
		return;
	   }

	   // check if someone already has other flag.. only one flag can be in play.. also make sure you can only pick up flag that IS in play
           %flagInPlay = 0;
	   for (%i = 0; %i < Team0.getCount(); %i++)
	   {
		   %obj = Team0.getObject(%i);
			
		   if(%obj.dataBlock $= Flag)
		   {
			   if(!%obj.isHome)
				   %flagInPlay = %obj;
				
			   if(!%obj.isHome && %obj.carrier)
			   {
				   messageClient(%player.client, 'msgNoFlagWarning', "\c2Only one flag may be in play.");
				   return;
			   }
		   }
	   }

	   if(%flagInPlay && %flag != %flagInPlay)
	   {
		   messageClient(%player.client, 'msgNoFlagWarning', "\c2You can only pick up the flag in play.");
		   return;
	   }
      	   %player.client.startTime = getSimTime();
	   %player.holdingFlag = %flag;
      	   %flag.carrier = %player;       
      	   %player.mountImage(FlagImage, $FlagSlot, true); //, $teamSkin[$RabbitTeam]);
      	   cancel(%flag.returnThread);
      	   %flag.hide(true);
      	   %flag.isHome = false;
      	   $flagStatus = %client.name;

      %palt = mfloor(%game.getObjectHeight(%player));
      %falt = mfloor(%game.getObjectHeight(%flag));
      %pvel = mfloor((VectorLen(%player.getVelocity())*3.6));
      %fvel = mfloor((VectorLen(%flag.getVelocity())*3.6));
      
      %MAgrabtext = "";
      %MAgrabtext2 = "";
      %MAgrabsound = "";
      if (%pvel >= 35) {
        %MAgrabsound = "~wfx/Bonuses/Nouns/puppy.wav";
      }
      if (%pvel >= 50) {
        %MAgrabsound = "~wfx/Bonuses/Nouns/dog.wav";
      }
      if (%pvel >= 75) {
        %MAgrabsound = "~wfx/Bonuses/horz_straipass1_bullet.wav";
      }
      if (%pvel >= 100) {
        %MAgrabsound = "~wfx/Bonuses/high-level4-blazing.wav";
      }
      if (%pvel >= 125) {
        %MAgrabsound = "~wfx/Bonuses/horz_straipass2_heist.wav";
      }

      if (%palt > 3 && %pvel > 1 && %falt > 3 && %fvel > 1) {
        %MAgrabbonus = 1;
        %MAgrabbonus += mfloor((%pvel * 0.05) + (%falt * 0.1) + 0.5);
        %MAgrabsound = "~wfx/Bonuses/Nouns/goldfinch.wav";
        if (%falt >= 5) {
          %MAgrabsound = "~wfx/Bonuses/Nouns/owl.wav";
        }
        if (%falt >= 10) {
          %MAgrabsound = "~wfx/Bonuses/Nouns/crow.wav";
        }
        if (%falt >= 20) {
          %MAgrabsound = "~wfx/Bonuses/Nouns/condor.wav";
        }
        if (%falt >= 25) {
          %MAgrabsound = "~wfx/Bonuses/Nouns/helicopter.wav";
        }
        if (%falt >= 30) {
          %MAgrabsound = "~wfx/Bonuses/down_passback1_prayer.wav";
        }
        if (%falt >= 50) {
          %MAgrabsound = "~wfx/misc/Cheer.wav";
        }
        %player.client.mrStyle += %MAgrabbonus;
        %MAgrabtext = " Midair";
        %MAgrabtext2 = " +" @ %MAgrabbonus;
      }

      messageAll('MsgRabbitFlagTaken', '\c2%1 has taken the flag%2 (%3M/%4kph)%5~wfx/misc/flag_snatch.wav', %player.client.name, %MAgrabtext, %falt, %pvel, %MAgrabtext2);
      if (%MAgrabsound !$= "") {
        messageAll('MsgRabbitFlagTakenSound', "" @ %MAgrabsound);
        if (%pvel >= 125) {
          messageAll('MsgRabbitFlagTakenSound', "" @ "~wfx/bonuses/Cheer.wav");
        }
      }
//DEBUG:
//      messageAll('MsgRabbitFlagTaken', "FVel="@%fvel);
//      messageAll('MsgRabbitFlagTaken', "FAlt="@%falt);
//      messageAll('MsgRabbitFlagTaken', "PVel="@%pvel);
//      messageAll('MsgRabbitFlagTaken', "PAlt="@%palt);
      logEcho(%player.client.nameBase@" (pl "@%player@"/cl "@%player.client@") took flag");
      %player.client.team = $RabbitTeam;
      %player.client.setSensorGroup($RabbitTeam);
      setTargetSensorGroup(%player.getTarget(), $RabbitTeam);

      //increase the score
      %player.client.flagGrabs++;
      %game.recalcScore(%player.client);
      %game.schedule(5000, "RabbitFlagCheck", %player);

      //show the rabbit waypoint
      %game.rabbitDamageTime = 0;
      cancel(%game.waypointSchedule);
      %game.showRabbitWaypoint(%player.client);
   }
}

function RabbitGame::rabbitFlagCheck(%game, %player)
{
   // this function calculates the score for the rabbit. It must be done periodically
   // since the rabbit's score is based on how long the flag has been in possession.
   if((%player.holdingFlag != 0) && (%player.getState() !$= "Dead"))
   {
      %game.recalcScore(%player.client);
      //reschedule this flagcheck for 5 seconds
      %game.schedule(5000, "RabbitFlagCheck", %player);
   }
}

function RabbitGame::returnFlag(%game, %flag)
{
   messageAll('MsgRabbitFlagReturned', '\c2The flag is HOME.~wfx/misc/flag_return.wav');
   logEcho("flag return (timeout)");
   %game.resetFlag(%flag);
}

function RabbitGame::resetFlag(%game, %flag)
{
   %flag.setVelocity("0 0 0");
   %flag.setTransform(%flag.originalPosition);
   %flag.isHome = true;
   %flag.carrier = "";
   $flagStatus = "<At Home>";
   %flag.hide(false);
}

// ----- These functions are native to Rabbit

function RabbitGame::timeLimitReached(%game)
{
   logEcho("game over (timelimit)");
   %game.gameOver();
   cycleMissions();
}

function RabbitGame::scoreLimitReached(%game)
{
   logEcho("game over (scorelimit)");
   %game.gameOver();
   cycleMissions();
}

function RabbitGame::checkScoreLimit(%game, %client)
{
   %scoreLimit = MissionGroup.Rabbit_scoreLimit;
   // default of 1200 if scoreLimit not defined  (that's 1200 seconds worth - 20 minutes)
   if(%scoreLimit $= "")
      %scoreLimit = 1200;
   if(%client.score >= %scoreLimit) 
      %game.scoreLimitReached();
}

function RabbitGame::gameOver(%game)
{
   //call the default
   DefaultGame::gameOver(%game);

   //send the message
   messageAll('MsgGameOver', "Match has ended.~wvoice/announcer/ann.gameover.wav" );

   cancel(%game.rabbitWaypointThread);
   messageAll('MsgClearObjHud', "");
   for(%i = 0; %i < ClientGroup.getCount(); %i++)
   {
      %client = ClientGroup.getObject(%i);
      %game.resetScore(%client);
      cancel(%client.waypointSchedule);
   }

   cancel(%game.waypointSchedule);

// UN-TWEAK SETTINGS
// Disc Ammo Reset
LightMaleHumanArmor.max[DiscAmmo]=$LMHMaxDiscAmmo;
LightFemaleHumanArmor.max[DiscAmmo]=$LFHMaxDiscAmmo;
LightMaleBiodermArmor.max[DiscAmmo]=$LMBMaxDiscAmmo;

// Mine Reset
LightMaleHumanArmor.max[Mine]=$LMHMaxMine;
LightFemaleHumanArmor.max[Mine]=$LFHMaxMine;
LightMaleBiodermArmor.max[Mine]=$LMBMaxMine;

//Blaster Reset
MediumMaleBiodermArmor.max[Blaster]=$MMBMaxBlaster;
MediumMaleHumanArmor.max[Blaster]=$MMHMaxBlaster;
MediumFemaleHumanArmor.max[Blaster]=$MFHMaxBlaster;
HeavyMaleBiodermArmor.max[Blaster]=$HMBMaxBlaster;
HeavyMaleHumanArmor.max[Blaster]=$HMHMaxBlaster;
HeavyFemaleHumanArmor.max[Blaster]=$HFHMaxBlaster;

// Weapon Attributes Reset
DiscProjectile.directDamage=$DiscDD;
DiscProjectile.directDamageType=$DiscDDT;
DiscProjectile.indirectDamage=$DiscID;
DiscProjectile.radiusDamageType=$DiscIDT;
PlasmaBolt.directDamage=$PlasmaDD;
PlasmaBolt.directDamageType=$PlasmaDDT;
PlasmaBolt.indirectDamage=$PlasmaID;
BasicGrenade.indirectDamage=$NadeID;
BasicGrenade.damageRadius=$NadeDR;
GrenadeThrown.indirectDamage=$HandNadeID;
GrenadeThrown.damageRadius=$HandNadeDR;
BlasterImage.minEnergy=$BlasterMinNRG;
BlasterImage.fireEnergy=$BlasterFireNRG;

// Ban List Reset
$InvBanList[Rabbit, "TurretOutdoorDeployable"] = $IBLTOD;
$InvBanList[Rabbit, "TurretIndoorDeployable"] = $IBLTID;
$InvBanList[Rabbit, "ElfBarrelPack"] = $IBLEBP;
$InvBanList[Rabbit, "MortarBarrelPack"] = $IBLMBP;
$InvBanList[Rabbit, "PlasmaBarrelPack"] = $IBLPBP;
$InvBanList[Rabbit, "AABarrelPack"] = $IBLABP;
$InvBanList[Rabbit, "MissileBarrelPack"] = $IBLMiBP;
$InvBanList[Rabbit, "MissileLauncher"] = $IBLML;
$InvBanList[Rabbit, "Mortar"] = $IBLMo;
$InvBanList[Rabbit, "SniperRifle"] = $IBLLR;
$InvBanList[Rabbit, "ConcussionGrenade"] = $IBLConc;
$InvBanList[Rabbit, "FlashGrenade"] = $IBLFlash;
$InvBanList[Rabbit, "Mine"] = $IBLMine;
$InvBanList[Rabbit, "ELFGun"] = $IBLELF;
$InvBanList[Rabbit, "Chaingun"] = $IBLCG;
$InvBanList[Rabbit, "SatchelCharge"] = $IBLSatch;

// Explosion Reset
LightMaleHumanArmor.explosion = "";
}

function RabbitGame::resetScore(%game, %client)
{
   %client.score = 0;
   %client.mrStyle = 0;
   %client.kills = 0;
   %client.deaths = 0;
   %client.suicides = "";
   %client.flagGrabs = 0;
   %client.flagTimeMS = 0;
   %client.teamkills = "";
   %client.turretkills = 0;
   %client.flagCaps = 0;
   %client.DiscMAs = 0;
   %client.DiscMADist = 0;
   %client.LanceMAs = 0;
   %client.LanceMADist = 0;
   %client.GrenadeMAs = 0;
   %client.GrenadeMADist = 0;
   %client.PlasmaMAs = 0;
   %client.PlasmaMADist = 0;
   %client.BlasterMAs = 0;
   %client.BlasterMADist = 0;
   %client.MineMAs = 0;
   %client.MineMADist = 0;
   
}

function RabbitGame::enterMissionArea(%game, %playerData, %player)
{
   %player.client.outOfBounds = false; 
   messageClient(%player.client, 'EnterMissionArea', '\c1You are back in the mission area.');
   logEcho(%player.client.nameBase@" (pl "@%player@"/cl "@%player.client@") entered mission area");
   cancel(%player.alertThread);
}

function RabbitGame::leaveMissionArea(%game, %playerData, %player)
{
   if(%player.getState() $= "Dead")
      return;
   
   %player.client.outOfBounds = true;
   if (%player.client.team == $RabbitTeam)
      messageClient(%player.client, 'LeaveMissionArea', '\c1You have left the mission area. Return or take damage.~wfx/misc/warning_beep.wav');
   else
      messageClient(%player.client, 'LeaveMissionArea', '\c1You have left the mission area.~wfx/misc/warning_beep.wav');
   logEcho(%player.client.nameBase@" (pl "@%player@"/cl "@%player.client@") left mission area");
   %player.alertThread = %game.schedule(1000, "AlertPlayer", 3, %player);
}

function RabbitGame::AlertPlayer(%game, %count, %player)
{
   if (%player.client.team == $RabbitTeam)
   {
      if(%count > 1)
         %player.alertThread = %game.schedule(1000, "AlertPlayer", %count - 1, %player);
      else 
         %player.alertThread = %game.schedule(1000, "MissionAreaDamage", %player);
   }

   //keep the thread going for non rabbits, but give the new rabbit time to return to the mission area...
   else
      %player.alertThread = %game.schedule(1000, "AlertPlayer", 3, %player);
}

function RabbitGame::MissionAreaDamage(%game, %player)
{
   if(%player.getState() !$= "Dead") {                                   
      %player.setDamageFlash(0.1);
		%damageRate = 0.05;
		%pack = %player.getMountedImage($BackpackSlot);
		if(%pack.getName() $= "RepairPackImage")
			if(%player.getMountedImage($WeaponSlot).getName() $= "RepairGunImage")
				%damageRate = 0.15;
      %prevHurt = %player.getDamageLevel();
      %player.setDamageLevel(%prevHurt + %damageRate);
      // a little redundancy to see if the lastest damage killed the player
      if(%player.getState() $= "Dead")
         %game.onClientKilled(%player.client, 0, $DamageType::OutOfBounds);
      else
         %player.alertThread = %game.schedule(1000, "MissionAreaDamage", %player);
   }
   else  
   {
      %game.onClientKilled(%player.client, 0, $DamageType::OutOfBounds);
   }  
}

function RabbitGame::dropFlag(%game, %player)
{
   //you can no longer throw the flag in Rabbit...
}

function RabbitGame::updateScoreHud(%game, %client, %tag)
{
   //tricky stuff here...  use two columns if we have more than 15 clients...
   %numClients = $TeamRank[0, count];
   if ( %numClients > $ScoreHudMaxVisible )
      %numColumns = 2;

   // Clear the header:
   messageClient( %client, 'SetScoreHudHeader', "", "" );

   // Send subheader:
   if (%numColumns == 2)
      messageClient(%client, 'SetScoreHudSubheader', "", '<tab:5,155,225,305,455,525>\tPLAYER\tSCORE\tTIME\tPLAYER\tSCORE\tTIME');
   else
      messageClient(%client, 'SetScoreHudSubheader', "", '<tab:5,125,215,255,385,500><spush><font:Univers Condensed:12>\tPlayer\tScore\tTime\tKills(Holding)\tGrabs\tDeaths(R/C/S)<spop>');
//OLD      messageClient(%client, 'SetScoreHudSubheader', "", '<tab:15,235,335>\tPLAYER\tSCORE\tTIME');

       messageClient( %client, 'SetLineHud', "", %tag, 0, '<tab:5,125,190,255,335,415,495><spush><color:8080dc><font:Univers Condensed:12>\tMAs(Count/Avg)\tDisc\tMine\tLance\tGrenade\tPlasma\tBlaster<spop>');
   //recalc the score for whoever is holding the flag
   if (isObject($AIRabbitFlag.carrier))
      %game.recalcScore($AIRabbitFlag.carrier.client);

   %countMax = %numClients;
   if ( %countMax > ( 2 * $ScoreHudMaxVisible ) )
   {
      if ( %countMax & 1 )
         %countMax++;
      %countMax = %countMax / 2;
   }
   else if ( %countMax > $ScoreHudMaxVisible )
      %countMax = $ScoreHudMaxVisible;

   for (%index = 1; %index <= (2 * %countMax); %index++)
   {
      //get the client info
      %col1Client = $TeamRank[0, ((%index-1)/2)];
      %col1ClientScore = %col1Client.score $= "" ? 0 : %col1Client.score;
      %col1Style = "";
      %MADiscLine = %col1Client.DiscMAs @ "/" @ (%col1Client.DiscMAs == 0 || %col1Client.DiscMAs $= "") ? 0 : mFloor(((%col1Client.DiscMADist)/%col1Client.DiscMAs)) @ "m";
      %MABlasterLine = %col1Client.BlasterMAs @ "/" @ (%col1Client.BlasterMAs == 0 || %col1Client.BlasterMAs $= "") ? 0 : mFloor(((%col1Client.BlasterMADist)/%col1Client.BlasterMAs)) @ "m";
      %MALanceLine = %col1Client.LanceMAs @ "/" @ (%col1Client.LanceMAs == 0 || %col1Client.LanceMAs $= "") ? 0 : mFloor(((%col1Client.LanceMADist)/%col1Client.LanceMAs)) @ "m";
      %MAPlasmaLine = %col1Client.PlasmaMAs @ "/" @ (%col1Client.PlasmaMAs == 0 || %col1Client.PlasmaMAs $= "") ? 0 : mFloor(((%col1Client.PlasmaMADist)/%col1Client.PlasmaMAs)) @ "m";
      %MAGrenadeLine = %col1Client.GrenadeMAs @ "/" @ (%col1Client.GrenadeMAs == 0 || %col1Client.GrenadeMAs $= "") ? 0 : mFloor(((%col1Client.GrenadeMADist)/%col1Client.GrenadeMAs)) @ "m";
      %MAMineLine = %col1Client.MineMAs @ "/" @ (%col1Client.MineMAs == 0 || %col1Client.MineMAs $= "") ? 0 : mFloor(((%col1Client.MineMADist)/%col1Client.MineMAs)) @ "m";
      if (isObject(%col1Client.player.holdingFlag))
      {
         %col1ClientTimeMS = %col1Client.flagTimeMS + getSimTime() - %col1Client.startTime;
         %col1Style = "<color:00dc00>";
      }
      else
      {
         %col1ClientTimeMS = %col1Client.flagTimeMS;
         if ( %col1Client == %client )
            %col1Style = "<color:dcdcdc>";
      }

      if (%col1ClientTimeMS <= 0)
         %col1ClientTime = "";
      else
      {
         %minutes = mFloor(%col1ClientTimeMS / (60 * 1000));
	         if (%minutes <= 0)
            %minutes = "0";
         %seconds = mFloor(%col1ClientTimeMS / 1000) % 60;
         if (%seconds < 10)
            %seconds = "0" @ %seconds;

         %col1ClientTime = %minutes @ ":" @ %seconds;
      }
      %col1ClientKills = (%col1Client.kills $= "" ? 0 : %col1Client.kills) @ " (" @ ((%col1Client.teamkills) $= "" ? 0 : (-1 * %col1Client.teamkills)) @ ")";
      %col1ClientDeaths = ((%col1Client.deaths + %col1client.suicides) $= "" ? 0 : (%col1Client.deaths + %col1client.suicides)) @ " (" @ (%col1Client.turretkills $= "" ? 0 : %col1Client.turretkills) @ "/" @ ((%col1Client.deaths - (%col1Client.turretkills)) $= "" ? 0 : (%col1Client.deaths - (%col1Client.turretkills))) @ "/" @ (%col1Client.suicides $= "" ? 0 : %col1Client.suicides) @ ")";
      %col1ClientGrabs = %col1Client.flaggrabs $= "" ? 0 : %col1Client.flaggrabs;
      %col1ClientSuicides = %col1Client.suicides $= "" ? 0 : %col1Client.suicides;

      //see if we have two columns
      if (%numColumns == 2)
      {
         %col2Client = "";
         %col2ClientScore = "";
         %col2ClientTime = "";
         %col2Style = "";

         //get the column 2 client info
         %col2Index = %index + %countMax;
         if (%col2Index < %numClients)
         {
            %col2Client = $TeamRank[0, %col2Index];
            %col2ClientScore = %col2Client.score $= "" ? 0 : %col2Client.score;

            if (isObject(%col2Client.player.holdingFlag))
            {
               %col2ClientTimeMS = %col2Client.flagTimeMS + getSimTime() - %col2Client.startTime;
               %col2Style = "<color:00dc00>";
            }
            else
            {
               %col2ClientTimeMS = %col2Client.flagTimeMS;
               if ( %col2Client == %client )
                  %col2Style = "<color:dcdcdc>";
            }

            if (%col2ClientTimeMS <= 0)
               %col2ClientTime = "";
            else
            {
               %minutes = mFloor(%col2ClientTimeMS / (60 * 1000));
               if (%minutes <= 0)
                  %minutes = "0";
               %seconds = mFloor(%col2ClientTimeMS / 1000) % 60;
               if (%seconds < 10)
                  %seconds = "0" @ %seconds;

               %col2ClientTime = %minutes @ ":" @ %seconds;
            }
         }
      }

      //if the client is not an observer, send the message
      if (%client.team != 0)
      {
         if ( %numColumns == 2 )
            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:10><spush>%7\t<clip:120>%1</clip><rmargin:205><just:right>%2<rmargin:270><just:right>%3<spop><rmargin:505><lmargin:310>%8<just:left>%4<rmargin:505><just:right>%5<rmargin:570><just:right>%6', 
                  %col1Client.name, %col1ClientScore, %col1ClientTime, %col2Client.name, %col2ClientScore, %col2ClientTime, %col1Style, %col2Style );
         else
            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:10><spush><font:Univers Condensed:12>%7\t<clip:120>%1</clip><rmargin:145><just:right>%2<rmargin:230><just:right>%3<rmargin:305><just:right>%4<rmargin:405><just:right>%6<rmargin:555><just:right>%5<spop>', 
                  %col1Client.name, %col1ClientScore, %col1ClientTime, %col1ClientKills, %col1ClientDeaths, %col1ClientGrabs, %col1Style, %col1ClientSuicides );
            %index++;
            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:5,125,190,255,335,415,495><spush><font:Univers Condensed:12><color:8080dc>\t\t%1\t%6\t%2\t%3\t%4\t%5<spop>', %MADiscLine, %MALanceLine, %MAGrenadeLine, %MAPlasmaLine, %MABlasterLine, %MAMineLine);
//OLD            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:20>%4\t<clip:200>%1</clip><rmargin:280><just:right>%2<rmargin:375><just:right>%3', 
//OLD                  %col1Client.name, %col1ClientScore, %col1ClientTime, %col1Style );
      }
      //else for observers, create an anchor around the player name so they can be observed
      else
      {
         if ( %numColumns == 2 )
         {
            //this is really crappy, but I need to save 1 tag - can only pass in up to %9, %10 doesn't work...
            if (%col2Style $= "<color:00dc00>")
            {
               messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:10><spush><font:Univers Condensed:12>%7\t<clip:150><a:gamelink\t%8>%1</a></clip><rmargin:205><just:right>%2<rmargin:270><just:right>%3<rmargin:505><lmargin:310><color:00dc00><just:left><clip:150><a:gamelink\t%9>%4</a></clip><rmargin:505><just:right>%5<rmargin:570><just:right>%6<spop>', 
                              %col1Client.name, %col1ClientScore, %col1ClientTime,
                              %col2Client.name, %col2ClientScore, %col2ClientTime,
                              %col1Style, %col1Client, %col2Client );
            }
            else if (%col2Style $= "<color:dcdcdc>")
            {
               messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:10><spush><font:Univers Condensed:12>%7\t<clip:150><a:gamelink\t%8>%1</a></clip><rmargin:205><just:right>%2<rmargin:270><just:right>%3<rmargin:505><lmargin:310><color:dcdcdc><just:left><clip:150><a:gamelink\t%9>%4</a></clip><rmargin:505><just:right>%5<rmargin:570><just:right>%6<spop>', 
                              %col1Client.name, %col1ClientScore, %col1ClientTime,
                              %col2Client.name, %col2ClientScore, %col2ClientTime,
                              %col1Style, %col1Client, %col2Client );
            }
            else
            {
               messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:10><spush><font:Univers Condensed:12>%7\t<clip:150><a:gamelink\t%8>%1</a></clip><rmargin:205><just:right>%2<rmargin:270><just:right>%3<rmargin:505><lmargin:310><just:left><clip:150><a:gamelink\t%9>%4</a></clip><rmargin:505><just:right>%5<rmargin:570><just:right>%6<spop>', 
                              %col1Client.name, %col1ClientScore, %col1ClientTime,
                              %col2Client.name, %col2ClientScore, %col2ClientTime,
                              %col1Style, %col1Client, %col2Client );
            }
         }
         else
            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:10><spush><font:Univers Condensed:12>%7\t<clip:120><a:gamelink\t%9>%1</a></clip><rmargin:145><just:right>%2<rmargin:230><just:right>%3<rmargin:305><just:right>%4<rmargin:405><just:right>%6<rmargin:555><just:right>%5<spop>', 
                  %col1Client.name, %col1ClientScore, %col1ClientTime, %col1ClientKills, %col1ClientDeaths, %col1ClientGrabs, %col1Style, %col1ClientSuicides, %col1Client );
            %index++;
            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:5,125,190,255,335,415,495><spush><font:Univers Condensed:12><color:8080dc>\t\t%1\t%6\t%2\t%3\t%4\t%5<spop>', %MADiscLine, %MALanceLine, %MAGrenadeLine, %MAPlasmaLine, %MABlasterLine, %MAMineLine);
//OLD            messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:20>%4\t<clip:200><a:gamelink\t%5>%1</a></clip><rmargin:280><just:right>%2<rmargin:375><just:right>%3', 
//OLD                  %col1Client.name, %col1ClientScore, %col1ClientTime, %col1Style, %col1Client );
      }
   }

   // Tack on the list of observers:
   %observerCount = 0;
   for (%i = 0; %i < ClientGroup.getCount(); %i++)
   {
      %cl = ClientGroup.getObject(%i);
      if (%cl.team == 0)
         %observerCount++;
   }

   if (%observerCount > 0)
   {
	   messageClient( %client, 'SetLineHud', "", %tag, %index, "");
      %index++;
		messageClient(%client, 'SetLineHud', "", %tag, %index, '<tab:10, 310><spush><font:Univers Condensed:12>\tOBSERVERS (%1)<rmargin:260><just:right>TIME<spop>', %observerCount);
      %index++;
      for (%i = 0; %i < ClientGroup.getCount(); %i++)
      {
         %cl = ClientGroup.getObject(%i);
         //if this is an observer
         if (%cl.team == 0)
         {
            %obsTime = getSimTime() - %cl.observerStartTime;
            %obsTimeStr = %game.formatTime(%obsTime, false);
		      messageClient( %client, 'SetLineHud', "", %tag, %index, '<tab:20, 310>\t<clip:150>%1</clip><rmargin:260><just:right>%2',
		                     %cl.name, %obsTimeStr );
            %index++;
         }
      }
   }

   //clear the rest of Hud so we don't get old lines hanging around...
   messageClient( %client, 'ClearHud', "", %tag, %index );
}

function RabbitGame::showRabbitWaypointClient(%game, %clRabbit, %client)
{
   //make sure we have a rabbit
   if (!isObject(%clRabbit) || !isObject(%clRabbit.player) || !isObject(%clRabbit.player.holdingFlag))
      return;

   //no waypoints for bots
   if (%client.isAIControlled())
      return;

   //scope the client, then set the always vis mask...
   %clRabbit.player.scopeToClient(%client);
   %visMask = getSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup());
   %visMask |= (1 << %client.getSensorGroup());
   setSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup(), %visMask);

   //now issue a command to kill the target
   %client.setTargetId(%clRabbit.target);
   commandToClient(%client, 'TaskInfo', %client, -1, false, "Pet the Bunny!");
   %client.sendTargetTo(%client, true);

   //send the "waypoint is here sound"
   messageClient(%client, 'MsgRabbitWaypoint', '~wfx/misc/target_waypoint.');

   //and hide the waypoint
   %client.waypointSchedule = %game.schedule(%game.waypointDuration, "hideRabbitWaypointClient", %clRabbit, %client);
}

function RabbitGame::hideRabbitWaypointClient(%game, %clRabbit, %client)
{
   //no waypoints for bots
   if (%client.isAIControlled())
      return;

   //unset the always vis mask...
   %visMask = getSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup());
   %visMask &= ~(1 << %client.getSensorGroup());
   setSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup(), %visMask);

   //kill the actually task...
   removeClientTargetType(%client, "AssignedTask");
}

function RabbitGame::showRabbitWaypoint(%game, %clRabbit)
{
   //make sure we have a rabbit
   if (!isObject(%clRabbit) || !isObject(%clRabbit.player) || !isObject(%clRabbit.player.holdingFlag))
      return;

   //only show the rabbit waypoint if the rabbit hasn't been damaged within the frequency period
   if (getSimTime() - %game.rabbitDamageTime < %game.waypointFrequency)
   {
      %game.waypointSchedule = %game.schedule(%game.waypointFrequency, "showRabbitWaypoint", %clRabbit);
      return;
   }

   //loop through all the clients and flash a waypoint at the rabbits position
   for (%i = 0; %i < ClientGroup.getCount(); %i++)
   {
      %cl = ClientGroup.getObject(%i);
      if (%cl.isAIControlled() || %cl == %clRabbit)
         continue;

      //scope the client, then set the always vis mask...
      %clRabbit.player.scopeToClient(%cl);
      %visMask = getSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup());
      %visMask |= (1 << %cl.getSensorGroup());
      setSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup(), %visMask);

      //now issue a command to kill the target
      %cl.setTargetId(%clRabbit.target);
      commandToClient(%cl, 'TaskInfo', %cl, -1, false, "Pet the Bunny!");
      %cl.sendTargetTo(%cl, true);

      //send the "waypoint is here sound"
      messageClient(%cl, 'MsgRabbitWaypoint', '~wfx/misc/target_waypoint.wav');
   }

   //schedule the time to hide the waypoint
   %game.waypointSchedule = %game.schedule(%game.waypointDuration, "hideRabbitWaypoint", %clRabbit);
}

function RabbitGame::hideRabbitWaypoint(%game, %clRabbit)
{
   //make sure we have a valid client
   if (!isObject(%clRabbit))
      return;

   //loop through all the clients and hide the waypoint
   for (%i = 0; %i < ClientGroup.getCount(); %i++)
   {
      %cl = ClientGroup.getObject(%i);
      if (%cl.isAIControlled())
         continue;

      //unset the always vis mask...
      %visMask = getSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup());
      %visMask &= ~(1 << %cl.getSensorGroup());
      setSensorGroupAlwaysVisMask(%clRabbit.getSensorGroup(), %visMask);

      //kill the actually task...
      removeClientTargetType(%cl, "AssignedTask");
   }

   //make sure we have a rabbit before scheduling the next showRabbitWaypoint...
   if (isObject(%clRabbit.player) && isObject(%clRabbit.player.holdingFlag))
      %game.waypointSchedule = %game.schedule(%game.waypointFrequency, "showRabbitWaypoint", %clRabbit);
}

function RabbitGame::updateKillScores(%game, %clVictim, %clKiller, %damageType, %implement)
{
   if(%game.testTurretKill(%implement))   //check for turretkill before awarded a non client points for a kill
        %game.awardScoreTurretKill(%clVictim, %implement);  
   else if (%game.testKill(%clVictim, %clKiller)) //verify victim was an enemy
   {
     %game.awardScoreKill(%clKiller);
     %game.awardScoreDeath(%clVictim);          
   }
   else
   {        
     if (%game.testSuicide(%clVictim, %clKiller, %damageType))  //otherwise test for suicide
     {
       %game.awardScoreSuicide(%clVictim);
     }
     else
     {
        if (%game.testTeamKill(%clVictim, %clKiller)) //otherwise test for a teamkill
              %game.awardScoreTeamKill(%clVictim, %clKiller);
     }
   }        
}

function RabbitGame::applyConcussion(%game, %player)
{
   // MES -- this won't do anything, the function RabbitGame::dropFlag is empty
   %game.dropFlag( %player );
}

//function RabbitGame::equip(%game, %player)
//{
//  for(%i =0; %i<$InventoryHudCount; %i++)
//   %player.client.setInventoryHudItem($InventoryHudData[%i, itemDataName], 0, 1);
//   %player.client.clearBackpackIcon();

//%player.setArmor("Light");
//   %player.setInventory(RepairKit,1);
//   %player.setInventory(Grenade,6);
//   %player.setInventory(Disc,1);
//   %player.setInventory(DiscAmmo, 20);
//   %player.setInventory(GrenadeLauncher,1);
//   %player.setInventory(GrenadeLauncherAmmo, 15);
//   %player.setInventory(ShockLance,1);
//   %player.setInventory(EnergyPack,1);
//   %player.setInventory(TargetingLaser, 1);
//   %player.weaponCount = 3;
//   %player.use("Disc");
//}                  




// ------------ misc functions

function RabbitGame::getObjectDistance(%game, %obj1, %obj2) {
  return VectorDist(%obj1.getTransform(), %obj2.getTransform());
}

function RabbitGame::calcMAScore(%game, %player, %damageType, %maDistance, %amount, %speedmod) {
  %mod = 1;
  if (isObject(%player.holdingFlag))
    %mod = %game.rabbitMod;

  switch (%damageType) {
    case 1:
      return mfloor(%mod * %speedmod * (%game.pBlaster + mfloor(%game.ppmBlaster * %maDistance + 0.5)));
    case 2:
      return mfloor(%mod * %speedmod * (%game.pPlasma + mfloor(%game.ppmPlasma * %maDistance + 0.5)));
    case 4:
      return mfloor(%mod * %speedmod * (%game.pDisc + mfloor(%game.ppmDisc * %maDistance + 0.5)));
    case 5:
      return mfloor(%mod * %speedmod * (%game.pGrenade + mfloor(%game.ppmGrenade * %maDistance + 0.5)));
    case 10:
      if (%amount > 0.5)
        return mfloor(%mod * %speedmod * (%game.pSLBack + mfloor(%game.ppmSLBack * %maDistance + 0.5)));
      else
        return mfloor(%mod * %speedmod * (%game.pSL + mfloor(%game.ppmSL * %maDistance + 0.5)));
    case 11:
      return mfloor(%mod * %speedmod * (%game.pMine + mfloor(%game.ppmMine * %maDistance + 0.5)));
    default:
      error("Unknown damage type in calcMAScore().");
      return 0;
  }
}

function RabbitGame::areEnemies(%game, %team1, %team2) {
  if (%team1 == "1" && %team2 == "2")
    return true;
  else if (%team1 == "2" && %team2 == "1")
    return true;

  return false;
}

function RabbitGame::getObjectHeight(%game, %object) {
  %x = getWord(%object.getTransform(), 0);
  %y = getWord(%object.getTransform(), 1);
  %z = getWord(%object.getTransform(), 2) + 10;
  %posFrom = %x SPC %y SPC %z;
  return %game.getPositionHeight(%posFrom) - 10;
}

function RabbitGame::getPositionHeight(%game, %pos) {
  %posTo = VectorAdd(%pos, "0 0 -10000");
//  %hit1 = getWords(containerRayCast(%pos, %posTo, $TypeMasks::TerrainObjectType, 0), 1, 3);
  %hit1 = getWords(containerRayCast(%pos, %posTo, $TypeMasks::StaticShapeObjectType | $TypeMasks::InteriorObjectType | $TypeMasks::TerrainObjectType, 0), 1, 3);
  return VectorDist(%pos, %hit1);
}

function RabbitGame::testForMA(%game, %targetObject, %sourceObject, %amount, %damageType) {
  if (!%game.areEnemies(%targetObject.client.team, %sourceObject.client.team))
    return false;

  if (%game.isMidair(%game.getObjectHeight(%targetObject), %amount, %damageType)) {
    %maDistance = %game.getObjectDistance(%targetObject, %sourceObject);
    // round to two spots
    %maDistance = %maDistance * 10.0;
    %maDistance = mfloor(%maDistance);
    %maDistance = %maDistance / 10.0;
    if (%sourceObject.client.DiscMAs $= "") %sourceObject.client.DiscMAs = 0;
    if (%sourceObject.client.DiscMADist $= "") %sourceObject.client.DiscMADist = 0;
    if (%sourceObject.client.LanceMAs $= "") %sourceObject.client.LanceMAs = 0;
    if (%sourceObject.client.LanceMADist $= "") %sourceObject.client.LanceMADist = 0;
    if (%sourceObject.client.GrenadeMAs $= "") %sourceObject.client.GrenadeMAs = 0;
    if (%sourceObject.client.GrenadeMADist $= "") %sourceObject.client.GrenadeMADist = 0;
    if (%sourceObject.client.PlasmaMAs $= "") %sourceObject.client.PlasmaMAs = 0;
    if (%sourceObject.client.PlasmaMADist $= "") %sourceObject.client.PlasmaMADist = 0;
    if (%sourceObject.client.BlasterMAs $= "") %sourceObject.client.BlasterMAs = 0;
    if (%sourceObject.client.BlasterMADist $= "") %sourceObject.client.BlasterMADist = 0;
    if (%sourceObject.client.MineMAs $= "") %sourceObject.client.MineMAs = 0;
    if (%sourceObject.client.MineMADist $= "") %sourceObject.client.MineMADist = 0;
    switch (%damageType) {
      case 1:
        %sourceObject.client.BlasterMAs += 1;
        %sourceObject.client.BlasterMADist += %maDistance;
        %damageText = "blaster";
      case 2:
        %sourceObject.client.PlasmaMAs += 1;
        %sourceObject.client.PlasmaMADist += %maDistance;
        %damageText = "plasma";
      case 4:
        %sourceObject.client.DiscMAs += 1;
        %sourceObject.client.DiscMADist += %maDistance;
        %damageText = "disc";
      case 5:
        %sourceObject.client.GrenadeMAs += 1;
        %sourceObject.client.GrenadeMADist += %maDistance;
        %damageText = "grenade";
      case 10:
        %sourceObject.client.LanceMAs += 1; 
        %sourceObject.client.LanceMADist += %maDistance;
        if (%amount > 0.5)
          %damageText = "backlance";
        else
          %damageText = "shocklance";
      case 11:
        %sourceObject.client.MineMAs += 1;
        %sourceObject.client.MineMADist += %maDistance;
        %damageText = "mine";
      default:
        error("Unknown damage type in RabbitGame::testForMA(" @ %damageType @ ")");
        %damageText = "unknown";
    }
// MISTA - 10/4/2002
    %velmult = 1;
    %velsound="";
    %targetvel = mfloor((VectorLen(%targetObject.getVelocity())*3.6));
    %veltext = %targetvel@"kph";
    if (%targetvel < 50) {
      %velmult = 1;
      %veltext2 = %veltext @ " no target speed multiplier";
      %velsound="";
    }
    if (%targetvel >= 50 && %targetvel < 70) {
      %velmult = 1.25;
      %veltext2 = %veltext @ " 1.25x target speed multiplier";
      %velsound="~wfx/Bonuses/Nouns/llama.wav";
    }
    if (%targetvel >= 70 && %targetvel < 90) {
      %velmult = 1.5;
      %veltext2 = %veltext @ " 1.5x target speed multiplier!";
      %velsound="~wfx/Bonuses/Nouns/cat.wav";
    }
    if (%targetvel >= 90 && %targetvel < 100) {
      %velmult = 1.75;
      %veltext2 = %veltext @ " 1.75x target speed multiplier!";
      %velsound="~wfx/Bonuses/Nouns/cheetah.wav";
    }
    if (%targetvel >= 100 && %targetvel < 125) {
      %velmult = 2;
      %veltext2 = %veltext @ " 2x target speed multiplier!";
      %velsound="~wfx/Bonuses/Nouns/tiger.wav";
    }
    if (%targetvel >= 125 && %targetvel < 160) {
      %velmult = 2.5;
      %veltext2 = %veltext @ " 2.5x target speed multiplier!";
      %velsound="~wfx/Bonuses/down_perppass3_bunnybump.wav";
    }
    if (%targetvel >= 160) {
      %velmult = 3;
      %veltext2 = %veltext @ " 3X TARGET SPEED MULTIPLIER!!!";
      %velsound="~wfx/misc/MA3.wav";
    }
// END MISTA - 10/4/2002
    %points = %game.calcMAScore(%sourceObject, %damageType, %maDistance, %amount, %velmult);
    %sourceObject.client.mrStyle += %points;
    %game.recalcScore(%sourceObject.client);



    %clientMsg = "";
    %othersMsg = "";
    %clientRecMsg = "";
    %othersRecMsg = "";
    if (%game.alertMAClients) {
      %clientMsg = "\c5You scored +" @ %points @ " (" @ %maDistance @ "m MA " @ %damageText @ " on " @ %targetObject.client.nameBase @ ") - "@%veltext2;
      %othersMsg = "\c5" @ %sourceObject.client.nameBase @ "\c2--> +" @ %points @ " (" @ %maDistance @ "m MA " @ %damageText @ " on \c5" @ %targetObject.client.nameBase @ "\c2) - "@%veltext2;
      %clientRecMsg = "\c5YOU NOW HOLD THE MA" @ %damageText @ " DISTANCE RECORD AT " @ %maDistance @ "m!";
      %othersRecMsg = "\c5" @ %sourceObject.client.nameBase @ "\c2 NOW HOLDS THE MA " @ %damageText @ " DISTANCE RECORD AT: " @ %maDistance @ "m!";
    }

    %clientSound = "";
    %othersSound = "";
    %clientRecSound = "";
    %othersRecSound = "";
    if (%game.soundsOn) {
      %clientSound = "~wfx/misc/bounty_bonus.wav";
      %othersSound = "~wfx/misc/gridjump.wav";
      %clientRecSound = "~wfx/misc/Cheer.wav";
      %othersRecSound = "~wfx/misc/Cheer.wav";
    }

    if (%game.soundsOn || %game.alertMAClients) {
      messageClient(%sourceObject.client, 'RabbitMA', %clientMsg @ %clientSound);
      messageAllExcept(%sourceObject.client, -1, 'RabbitMADet', %othersMsg @ %othersSound);
      if (!(%velsound $= "")) {
        messageClient(%sourceObject.client, 'RabbitMASpeed', "" @ %velsound);
        messageAllExcept(%sourceObject.client, -1, 'RabbitMADetSpeed', "" @ %velsound);
        if (%targetvel >= 160 && %damagetype = 10) {
          messageAll('RabbitMASpeed', "" @ "~wfx/misc/missed.wav");
        }
      }

      if (IsMARecord(%maDistance, %damageText, %sourceObject.client.nameBase)) {
        messageClient(%sourceObject.client, 'RabbitMARecord', %clientRecMsg @ %clientRecSound);
        messageAllExcept(%sourceObject.client, -1, 'RabbitMARecordDet', %othersRecMsg @ %othersRecSound);
        messageAll('RabbitMARecordLaugh', "" @ "~wfx/Bonuses/evillaugh.wav");
      }

      if (IsGameMARecord(%game, %maDistance, %damageText, %sourceObject.client.nameBase)) {
//        messageClient(%sourceObject.client, 'RabbitMARecord', %clientRecMsg @ %clientRecSound);
//        messageAllExcept(%sourceObject.client, -1, 'RabbitMARecordDet', %othersRecMsg @ %othersRecSound);
//        messageAll('RabbitGameMARecord', "" @ "~wfx/Bonuses/evillaugh.wav");
        messageAll('RabbitGameMARecord', "" @ "~wfx/misc/crowd2.wav");
      }

    }

    return true;
  } else { // GROUND SHOT
  if (%damagetype != 11) {
    %maDistance = %game.getObjectDistance(%targetObject, %sourceObject);
    // round to two spots
    %maDistance = %maDistance * 10.0;
    %maDistance = mfloor(%maDistance);
    %maDistance = %maDistance / 10.0;
    switch (%damageType) {
      case 1:
        %damageText = "blaster";
      case 2:
        %damageText = "plasma";
      case 4:
        %damageText = "disc";
      case 5:
        %damageText = "grenade";
      case 10:
        if (%amount > 0.5)
          %damageText = "backlance";
        else
          %damageText = "shocklance";
//      case 11:
//        %sourceObject.client.MineMAs += 1;
//        %sourceObject.client.MineMADist += %maDistance;
//        %damageText = "mine";
      default:
        error("Unknown damage type in RabbitGame::testForMA(" @ %damageType @ ")");
        %damageText = "unknown";
    }
// MISTA - 10/4/2002
    %velmult = 1;
    %velsound="";
    %targetvel = mfloor((VectorLen(%targetObject.getVelocity())*3.6));
    %veltext = %targetvel@"kph";
    if (%targetvel < 50) {
      %velmult = 1;
      %veltext2 = %veltext @ " no target speed multiplier";
      %velsound="";
    }
    if (%targetvel >= 50 && %targetvel < 70) {
      %velmult = 1.25;
      %veltext2 = %veltext @ " 1.25x target speed multiplier";
      %velsound="~wfx/Bonuses/Nouns/llama.wav";
    }
    if (%targetvel >= 70 && %targetvel < 90) {
      %velmult = 1.5;
      %veltext2 = %veltext @ " 1.5x target speed multiplier!";
      %velsound="~wfx/Bonuses/Nouns/cat.wav";
    }
    if (%targetvel >= 90 && %targetvel < 100) {
      %velmult = 1.75;
      %veltext2 = %veltext @ " 1.75x target speed multiplier!";
      %velsound="~wfx/Bonuses/Nouns/cheetah.wav";
    }
    if (%targetvel >= 100 && %targetvel < 125) {
      %velmult = 2;
      %veltext2 = %veltext @ " 2x target speed multiplier!";
      %velsound="~wfx/Bonuses/Nouns/tiger.wav";
    }
    if (%targetvel >= 125 && %targetvel < 160) {
      %velmult = 2.5;
      %veltext2 = %veltext @ " 2.5x target speed multiplier!";
      %velsound="~wfx/Bonuses/down_perppass3_bunnybump.wav";
    }
    if (%targetvel >= 160) {
      %velmult = 3;
      %veltext2 = %veltext @ " 3X TARGET SPEED MULTIPLIER!!!";
      %velsound="~wfx/explosions/deployables_explosion.WAV";
    }
// END MISTA - 10/4/2002
    %points = mfloor(0.75 * (%game.calcMAScore(%sourceObject, %damageType, %maDistance, %amount, %velmult)));
    if (%damagetype == 5) %points = mfloor(0.33 * %points);
    %sourceObject.client.mrStyle += %points;
    %game.recalcScore(%sourceObject.client);
    %clientMsg = "";
    %othersMsg = "";
    if (%game.alertMAClients) {
      %clientMsg = "\c5You scored +" @ %points @ " (" @ %maDistance @ "m Grounder " @ %damageText @ " on " @ %targetObject.client.nameBase @ ") - "@%veltext2;
      %othersMsg = "\c5" @ %sourceObject.client.nameBase @ "\c2--> +" @ %points @ " (" @ %maDistance @ "m Grounder " @ %damageText @ " on \c5" @ %targetObject.client.nameBase @ "\c2) - "@%veltext2;
    }

    %clientSound = "";
    %othersSound = "";
    if (%game.soundsOn) {
      %clientSound = "~wfx/weapons/cg_hard4.wav";
      %othersSound = "~wfx/weapons/mine_switch.wav";

    }

    if (%game.soundsOn || %game.alertMAClients) {
      messageClient(%sourceObject.client, 'RabbitMA', %clientMsg @ %clientSound);
      messageAllExcept(%sourceObject.client, -1, 'RabbitMADet', %othersMsg @ %othersSound);
//      if (!(%velsound $= "")) {
//        messageClient(%sourceObject.client, 'RabbitMASpeed', "" @ %velsound);
//        messageAllExcept(%sourceObject.client, -1, 'RabbitMADetSpeed', "" @ %velsound);
//        if (%targetvel >= 160 && %damagetype = 10) {
//          messageAll('RabbitMASpeed', "" @ "~wvoice/Training/Mission1/T1.tip.skiing03.WAV");
//        }
//      }

    }
    return false;
  } // NOT 11 (MINE)
  } // GROUND SHOT
  return false;
}

function RabbitGame::isMidair(%game, %objHeight, %amount, %damageType) {
  if (%objHeight < %game.minMAHeight)
    return false;

  switch (%damageType) {
    case 1:
      return true;
    case 2:
      if (%amount >= %game.minPlasmaDamage)
        return true;
    case 4:
      if (%amount >= %game.minDiscDamage)
        return true;
    case 5:
      if (%amount >= %game.minGrenadeDamage)
        return true;
    case 10:
      if (%amount >= %game.minSLDamage)
        return true;
    case 11:
      if (%amount >= %game.minMineDamage)
        return true;
  }

  return false;
}


function IsMARecord(%maDistance, %damageText, %PlayerName) {

  if (%maDistance > $Host::RabbitRecords::MARecords::Distance[%damageText]) {
    //update the variable
    $Host::RabbitRecords::MARecords::Distance[%damageText] = %maDistance;
    $Host::RabbitRecords::MARecords::Name[%damageText] = %PlayerName;
    //update the records file...
    export( "$Host::RabbitRecords::*", "prefs/RabbitRecords.cs", false );
    return true;
  } else {
    return false;
  }
} // IsMARecord

function IsGameMARecord(%game, %maDistance, %damageText, %PlayerName) {

  if (%maDistance > %game.MADistance[%damageText]) {
    //update the variable
    %game.MADistance[%damageText] = %maDistance;
    %game.MAName[%damageText] = %PlayerName;
    return true;
  } else {
    return false;
  }
} // IsGameMARecord

function RabbitGame::getObjectByName(%game, %group, %name) {
  %count = %group.getCount();
  for (%i = 0; %i < %count; %i++) {
    %groupObject = %group.getObject(%i);
    %groupName = strlwr(%groupObject.getName());
    if (%groupName $= strLwr(%name))
      return %groupObject;
  }
  return "";
}

function RabbitGame::fixFavorites(%game, %player) {
  %player.setInventory("TurretOutdoorDeployable", 0);
  %player.setInventory("TurretIndoorDeployable", 0);
  %player.setInventory("ElfBarrelPack", 0);
  %player.setInventory("MortarBarrelPack", 0);
  %player.setInventory("PlasmaBarrelPack", 0);
  %player.setInventory("AABarrelPack", 0);
  %player.setInventory("MissileBarrelPack", 0);
  %player.setInventory("MissileLauncher", 0);
  %player.setInventory("Mortar", 0);
  %player.setInventory("Chaingun", 0);
  %player.setInventory("SniperRifle", 0);
  %player.setInventory("ELFGun", 0);
  %player.setInventory("FlashGrenade", 0);
  %player.setInventory("ConcussionGrenade", 0);
//  %player.setInventory("Mine", 0);
}


function RabbitGame::sendDebriefing( %game, %client )
{
   // Mission result:
   if ( $TeamRank[0, 0].score > 0 )
      messageClient( %client, 'MsgDebriefResult', "", '<just:center>%1 wins with a score of %2!', $TeamRank[0, 0].name, $TeamRank[0, 0].score );
   else
      messageClient( %client, 'MsgDebriefResult', "", '<just:center>Nobody wins!' );

   // All Time Records:
   messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:00dc00><font:univers condensed:12>All Time Record<lmargin%%:33>Player<lmargin%%:75>Value<spop>' );
   if ( $Host::RabbitRecords::MARecords::Distanceplasma !$= "" && $Host::RabbitRecords::MARecords::Nameplasma !$= "" ) {
     %strHeader = "Plasma MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Nameplasma;
     %strDistance = $Host::RabbitRecords::MARecords::Distanceplasma @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( $Host::RabbitRecords::MARecords::Distanceblaster !$= "" && $Host::RabbitRecords::MARecords::Nameblaster !$= "" ) {
     %strHeader = "Blaster MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Nameblaster;
     %strDistance = $Host::RabbitRecords::MARecords::Distanceblaster @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( $Host::RabbitRecords::MARecords::Distancedisc !$= "" && $Host::RabbitRecords::MARecords::Namedisc !$= "" ) {
     %strHeader = "Disc MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Namedisc;
     %strDistance = $Host::RabbitRecords::MARecords::Distancedisc @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( $Host::RabbitRecords::MARecords::Distancegrenade !$= "" && $Host::RabbitRecords::MARecords::Namegrenade !$= "" ) {
     %strHeader = "Grenade MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Namegrenade;
     %strDistance = $Host::RabbitRecords::MARecords::Distancegrenade @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( $Host::RabbitRecords::MARecords::Distanceshocklance !$= "" && $Host::RabbitRecords::MARecords::Nameshocklance !$= "" ) {
     %strHeader = "ShockLance MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Nameshocklance;
     %strDistance = $Host::RabbitRecords::MARecords::Distanceshocklance @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( $Host::RabbitRecords::MARecords::Distancebacklance !$= "" && $Host::RabbitRecords::MARecords::Namebacklance !$= "" ) {
     %strHeader = "BackLance MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Namebacklance;
     %strDistance = $Host::RabbitRecords::MARecords::Distancebacklance @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( $Host::RabbitRecords::MARecords::Distancemine !$= "" && $Host::RabbitRecords::MARecords::Namemine !$= "" ) {
     %strHeader = "Mine MA Distance";
     %strName = $Host::RabbitRecords::MARecords::Namemine;
     %strDistance = $Host::RabbitRecords::MARecords::Distancemine @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:dcdc00><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }

   // Game Records:
   messageClient( %client, 'MsgDebriefAddLine', "", '\n<lmargin:0><spush><color:00dc00><font:univers condensed:12>Records This Game<lmargin%%:33>Player<lmargin%%:75>Value<spop>' );
   if ( %game.MANameplasma !$= "" && %game.MADistanceplasma !$= "" ) {
     %strHeader = "Plasma MA Distance";
     %strName = %game.MANameplasma;
     %strDistance = %game.MADistanceplasma @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( %game.MANameblaster !$= "" && %game.MADistanceblaster !$= "" ) {
     %strHeader = "Blaster MA Distance";
     %strName = %game.MANameblaster;
     %strDistance = %game.MADistanceblaster @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( %game.MANamedisc !$= "" && %game.MADistancedisc !$= "" ) {
     %strHeader = "Disc MA Distance";
     %strName = %game.MANamedisc;
     %strDistance = %game.MADistancedisc @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( %game.MANamegrenade !$= "" && %game.MADistancegrenade !$= "" ) {
     %strHeader = "Grenade MA Distance";
     %strName = %game.MANamegrenade;
     %strDistance = %game.MADistancegrenade @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( %game.MANameshocklance !$= "" && %game.MADistanceshocklance !$= "" ) {
     %strHeader = "ShockLance MA Distance";
     %strName = %game.MANameshocklance;
     %strDistance = %game.MADistanceshocklance @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( %game.MANamebacklance !$= "" && %game.MADistancebacklance !$= "" ) {
     %strHeader = "BackLance MA Distance";
     %strName = %game.MANamebacklance;
     %strDistance = %game.MADistancebacklance @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }
   if ( %game.MANamemine !$= "" && %game.MADistancemine !$= "" ) {
     %strHeader = "Mine MA Distance";
     %strName = %game.MANamemine;
     %strDistance = %game.MADistancemine @ "m";
     messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><spush><color:ffffff><font:univers condensed:12><clip%%:40>%1</clip><lmargin%%:33><clip%%:20>%2</clip><lmargin%%:75><clip%%:20>%3</clip><spop>', %strHeader, %strName, %strDistance);
   }

   // Player scores:
   messageClient( %client, 'MsgDebriefAddLine', "", '\n<lmargin:0><spush><color:00dc00><font:univers condensed:18>PLAYER<lmargin%%:40>SCORE<lmargin%%:60>MAs<lmargin%%:80>KILLS<spop>' );
   %count = $TeamRank[0, count];
   for ( %i = 0; %i < %count; %i++ )
   {
      %cl = $TeamRank[0, %i];
      if ( %cl.score $= "" )
         %score = 0;
      else
         %score = %cl.score;
      if ( %cl.kills $= "" )
         %kills = 0;
      else
         %kills = %cl.kills;
         %MAs = %cl.DiscMAs + %cl.PlasmaMAs + %cl.BlasterMAs + %cl.GrenadeMAs + %cl.LanceMAs + %cl.MineMAs;
      messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><clip%%:40>%1</clip><lmargin%%:40><clip%%:20>%2</clip><lmargin%%:60><clip%%:20>%4</clip><lmargin%%:80><clip%%:20>%3</clip>', %cl.name, %score, %kills, %MAs);
   }

   // Show observers:
   %count = ClientGroup.getCount();
   %header = false;
   for ( %i = 0; %i < %count; %i++ )
   {
      %cl = ClientGroup.getObject( %i );
      if ( %cl.team <= 0 )
      {
         if ( !%header )
         {
            messageClient( %client, 'MsgDebriefAddLine', "", '\n<lmargin:0><spush><font:univers condensed:18><color:00dc00>OBSERVERS<lmargin%%:60>SCORE<spop>' );
            %header = true;
         }

         %score = %cl.score $= "" ? 0 : %cl.score;
         messageClient( %client, 'MsgDebriefAddLine', "", '<lmargin:0><clip%%:60> %1</clip><lmargin%%:60><clip%%:40> %2</clip>', %cl.name, %score );
      }
   }
}

